/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.core.CausticPhotonMapInterface;
import org.sunflow.core.GIEngine;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSource;
import org.sunflow.core.Options;
import org.sunflow.core.PhotonStore;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.gi.GIEngineFactory;
import org.sunflow.core.photonmap.CausticPhotonMap;
import org.sunflow.image.Color;
import org.sunflow.math.Point3;
import org.sunflow.math.QMC;
import org.sunflow.math.Vector3;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

class LightServer {
    private Scene scene;
    private LightSource[] lights;
    private Shader shaderOverride;
    private boolean shaderOverridePhotons;
    private int maxDiffuseDepth;
    private int maxReflectionDepth;
    private int maxRefractionDepth;
    private CausticPhotonMapInterface causticPhotonMap;
    private GIEngine giEngine;
    private int photonCounter;
    private CacheEntry[] shadingCache;
    private float shadingCacheResolution;
    private long cacheLookups;
    private long cacheEmptyEntryMisses;
    private long cacheWrongEntryMisses;
    private long cacheEntryAdditions;
    private long cacheHits;

    LightServer(Scene scene) {
        this.scene = scene;
        this.lights = new LightSource[0];
        this.causticPhotonMap = null;
        this.shaderOverride = null;
        this.shaderOverridePhotons = false;
        this.maxDiffuseDepth = 1;
        this.maxReflectionDepth = 4;
        this.maxRefractionDepth = 4;
        this.causticPhotonMap = null;
        this.giEngine = null;
        this.shadingCache(0.0f);
    }

    void setLights(LightSource[] lightSourceArray) {
        this.lights = lightSourceArray;
    }

    void shadingCache(float f) {
        this.shadingCache = f > 0.0f ? new CacheEntry[4096] : null;
        this.shadingCacheResolution = (float)(1.0 / Math.sqrt(f));
    }

    Scene getScene() {
        return this.scene;
    }

    void setShaderOverride(Shader shader, boolean bl) {
        this.shaderOverride = shader;
        this.shaderOverridePhotons = bl;
    }

    boolean build(Options options) {
        int n;
        this.maxDiffuseDepth = options.getInt("depths.diffuse", this.maxDiffuseDepth);
        this.maxReflectionDepth = options.getInt("depths.reflection", this.maxReflectionDepth);
        this.maxRefractionDepth = options.getInt("depths.refraction", this.maxRefractionDepth);
        this.giEngine = GIEngineFactory.create(options);
        String string = options.getString("caustics", null);
        if (string == null || string.equals("none")) {
            this.causticPhotonMap = null;
        } else if (string != null && string.equals("kd")) {
            this.causticPhotonMap = new CausticPhotonMap(options);
        } else {
            UI.printWarning(UI.Module.LIGHT, "Unrecognized caustics photon map engine \"%s\" - ignoring", string);
            this.causticPhotonMap = null;
        }
        this.maxDiffuseDepth = Math.max(0, this.maxDiffuseDepth);
        this.maxReflectionDepth = Math.max(0, this.maxReflectionDepth);
        this.maxRefractionDepth = Math.max(0, this.maxRefractionDepth);
        Timer timer = new Timer();
        timer.start();
        int n2 = 0;
        for (n = 0; n < this.lights.length; ++n) {
            n2 += this.lights[n].getNumSamples();
        }
        if (this.giEngine != null && !this.giEngine.init(this.scene)) {
            return false;
        }
        if (!this.calculatePhotons(this.causticPhotonMap, "caustic", 0)) {
            return false;
        }
        timer.end();
        this.cacheLookups = 0L;
        this.cacheHits = 0L;
        this.cacheEmptyEntryMisses = 0L;
        this.cacheWrongEntryMisses = 0L;
        this.cacheEntryAdditions = 0L;
        if (this.shadingCache != null) {
            for (n = 0; n < this.shadingCache.length; ++n) {
                this.shadingCache[n] = null;
            }
        }
        UI.printInfo(UI.Module.LIGHT, "Light Server stats:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Light sources found: %d", this.lights.length);
        UI.printInfo(UI.Module.LIGHT, "  * Light samples:       %d", n2);
        UI.printInfo(UI.Module.LIGHT, "  * Max raytrace depth:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "      - Diffuse          %d", this.maxDiffuseDepth);
        UI.printInfo(UI.Module.LIGHT, "      - Reflection       %d", this.maxReflectionDepth);
        UI.printInfo(UI.Module.LIGHT, "      - Refraction       %d", this.maxRefractionDepth);
        UI.printInfo(UI.Module.LIGHT, "  * GI engine            %s", options.getString("gi.engine", "none"));
        UI.printInfo(UI.Module.LIGHT, "  * Caustics:            %s", string == null ? "none" : string);
        UI.printInfo(UI.Module.LIGHT, "  * Shader override:     %b", this.shaderOverride);
        UI.printInfo(UI.Module.LIGHT, "  * Photon override:     %b", this.shaderOverridePhotons);
        UI.printInfo(UI.Module.LIGHT, "  * Shading cache:       %s", this.shadingCache == null ? "off" : "on");
        UI.printInfo(UI.Module.LIGHT, "  * Build time:          %s", timer.toString());
        return true;
    }

    void showStats() {
        if (this.shadingCache == null) {
            return;
        }
        int n = 0;
        for (CacheEntry cacheEntry : this.shadingCache) {
            n += cacheEntry != null ? 1 : 0;
        }
        UI.printInfo(UI.Module.LIGHT, "Shading cache stats:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Used entries:        %d (%d%%)", n, 100 * n / this.shadingCache.length);
        UI.printInfo(UI.Module.LIGHT, "  * Lookups:             %d", this.cacheLookups);
        UI.printInfo(UI.Module.LIGHT, "  * Hits:                %d", this.cacheHits);
        UI.printInfo(UI.Module.LIGHT, "  * Hit rate:            %d%%", 100L * this.cacheHits / this.cacheLookups);
        UI.printInfo(UI.Module.LIGHT, "  * Empty entry misses:  %d", this.cacheEmptyEntryMisses);
        UI.printInfo(UI.Module.LIGHT, "  * Wrong entry misses:  %d", this.cacheWrongEntryMisses);
        UI.printInfo(UI.Module.LIGHT, "  * Entry adds:          %d", this.cacheEntryAdditions);
    }

    boolean calculatePhotons(final PhotonStore photonStore, String string, final int n) {
        int n2;
        int n3;
        if (photonStore == null) {
            return true;
        }
        if (this.lights.length == 0) {
            UI.printError(UI.Module.LIGHT, "Unable to trace %s photons, no lights in scene", string);
            return false;
        }
        final float[] fArray = new float[this.lights.length];
        fArray[0] = this.lights[0].getPower();
        for (n3 = 1; n3 < this.lights.length; ++n3) {
            fArray[n3] = fArray[n3 - 1] + this.lights[n3].getPower();
        }
        UI.printInfo(UI.Module.LIGHT, "Tracing %s photons ...", string);
        n3 = photonStore.numEmit();
        if (n3 <= 0 || fArray[fArray.length - 1] <= 0.0f) {
            UI.printError(UI.Module.LIGHT, "Photon mapping enabled, but no %s photons to emit", string);
            return false;
        }
        photonStore.prepare(this.scene.getBounds());
        UI.taskStart("Tracing " + string + " photons", 0, n3);
        Thread[] threadArray = new Thread[this.scene.getThreads()];
        final float f = 1.0f / (float)n3;
        int n4 = n3 / threadArray.length;
        this.photonCounter = 0;
        Timer timer = new Timer();
        timer.start();
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            int n5 = n2;
            final int n6 = n5 * n4;
            final int n7 = n5 == threadArray.length - 1 ? n3 : (n5 + 1) * n4;
            threadArray[n2] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IntersectionState intersectionState = new IntersectionState();
                    for (int i = n6; i < n7; ++i) {
                        int n3;
                        LightServer lightServer = LightServer.this;
                        synchronized (lightServer) {
                            UI.taskUpdate(LightServer.this.photonCounter);
                            LightServer.this.photonCounter++;
                            if (UI.taskCanceled()) {
                                return;
                            }
                        }
                        int n2 = i + n;
                        double d = QMC.halton(0, n2) * (double)fArray[fArray.length - 1];
                        for (n3 = 0; d >= (double)fArray[n3] && n3 < fArray.length; ++n3) {
                        }
                        if (n3 == fArray.length) continue;
                        double d2 = n3 == 0 ? d / (double)fArray[0] : (d - (double)fArray[n3]) / (double)(fArray[n3] - fArray[n3 - 1]);
                        double d3 = QMC.halton(1, n2);
                        double d4 = QMC.halton(2, n2);
                        double d5 = QMC.halton(3, n2);
                        Point3 point3 = new Point3();
                        Vector3 vector3 = new Vector3();
                        Color color = new Color();
                        LightServer.this.lights[n3].getPhoton(d2, d3, d4, d5, point3, vector3, color);
                        color.mul(f);
                        Ray ray = new Ray(point3, vector3);
                        LightServer.this.scene.trace(ray, intersectionState);
                        if (!intersectionState.hit()) continue;
                        LightServer.this.shadePhoton(ShadingState.createPhotonState(ray, intersectionState, n2, photonStore, LightServer.this), color);
                    }
                }
            });
            threadArray[n2].setPriority(this.scene.getThreadPriority());
            threadArray[n2].start();
        }
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            try {
                threadArray[n2].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                UI.printError(UI.Module.LIGHT, "Photon thread %d of %d was interrupted", n2 + 1, threadArray.length);
                return false;
            }
        }
        if (UI.taskCanceled()) {
            UI.taskStop();
            return false;
        }
        timer.end();
        UI.taskStop();
        UI.printInfo(UI.Module.LIGHT, "Tracing time for %s photons: %s", string, timer.toString());
        photonStore.init();
        return true;
    }

    void shadePhoton(ShadingState shadingState, Color color) {
        shadingState.getInstance().prepareShadingState(shadingState);
        Shader shader = this.getPhotonShader(shadingState);
        if (shader != null) {
            shader.scatterPhoton(shadingState, color);
        }
    }

    void traceDiffusePhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createDiffuseBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    void traceReflectionPhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createReflectionBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    void traceRefractionPhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getRefractionDepth() >= this.maxRefractionDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createRefractionBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    private Shader getShader(ShadingState shadingState) {
        return this.shaderOverride != null ? this.shaderOverride : shadingState.getShader();
    }

    private Shader getPhotonShader(ShadingState shadingState) {
        return this.shaderOverride != null && this.shaderOverridePhotons ? this.shaderOverride : shadingState.getShader();
    }

    ShadingState getRadiance(float f, float f2, int n, Ray ray, IntersectionState intersectionState) {
        this.scene.trace(ray, intersectionState);
        if (intersectionState.hit()) {
            Color color;
            ShadingState shadingState = ShadingState.createState(intersectionState, f, f2, ray, n, this);
            shadingState.getInstance().prepareShadingState(shadingState);
            Shader shader = this.getShader(shadingState);
            if (shader == null) {
                shadingState.setResult(Color.BLACK);
                return shadingState;
            }
            if (this.shadingCache != null && (color = this.lookupShadingCache(shadingState, shader)) != null) {
                shadingState.setResult(color);
                return shadingState;
            }
            shadingState.setResult(shader.getRadiance(shadingState));
            if (this.shadingCache != null) {
                this.addShadingCache(shadingState, shader, shadingState.getResult());
            }
            return shadingState;
        }
        return null;
    }

    void shadeBakeResult(ShadingState shadingState) {
        Shader shader = this.getShader(shadingState);
        if (shader != null) {
            shadingState.setResult(shader.getRadiance(shadingState));
        } else {
            shadingState.setResult(Color.BLACK);
        }
    }

    Color shadeHit(ShadingState shadingState) {
        shadingState.getInstance().prepareShadingState(shadingState);
        Shader shader = this.getShader(shadingState);
        return shader != null ? shader.getRadiance(shadingState) : Color.BLACK;
    }

    private static final int hash(int n, int n2) {
        return n ^ n2;
    }

    private synchronized Color lookupShadingCache(ShadingState shadingState, Shader shader) {
        int n;
        if (shadingState.getNormal() == null) {
            return null;
        }
        ++this.cacheLookups;
        int n2 = (int)(shadingState.getRasterX() * this.shadingCacheResolution);
        int n3 = LightServer.hash(n2, n = (int)(shadingState.getRasterY() * this.shadingCacheResolution));
        CacheEntry cacheEntry = this.shadingCache[n3 & this.shadingCache.length - 1];
        if (cacheEntry == null) {
            ++this.cacheEmptyEntryMisses;
            return null;
        }
        if (cacheEntry.cx == n2 && cacheEntry.cy == n) {
            Sample sample = cacheEntry.first;
            while (sample != null) {
                if (sample.i == shadingState.getInstance() && sample.s == shader && !(shadingState.getNormal().dot(sample.nx, sample.ny, sample.nz) < 0.95f)) {
                    ++this.cacheHits;
                    return sample.c;
                }
                sample = sample.next;
            }
        } else {
            ++this.cacheWrongEntryMisses;
        }
        return null;
    }

    private synchronized void addShadingCache(ShadingState shadingState, Shader shader, Color color) {
        int n;
        if (shadingState.getNormal() == null) {
            return;
        }
        ++this.cacheEntryAdditions;
        int n2 = (int)(shadingState.getRasterX() * this.shadingCacheResolution);
        int n3 = LightServer.hash(n2, n = (int)(shadingState.getRasterY() * this.shadingCacheResolution)) & this.shadingCache.length - 1;
        CacheEntry cacheEntry = this.shadingCache[n3];
        if (cacheEntry == null) {
            cacheEntry = this.shadingCache[n3] = new CacheEntry();
        }
        Sample sample = new Sample();
        sample.i = shadingState.getInstance();
        sample.s = shader;
        sample.c = color;
        sample.nx = shadingState.getNormal().x;
        sample.ny = shadingState.getNormal().y;
        sample.nz = shadingState.getNormal().z;
        if (cacheEntry.cx == n2 && cacheEntry.cy == n) {
            sample.next = cacheEntry.first;
            cacheEntry.first = sample;
        } else {
            cacheEntry.cx = n2;
            cacheEntry.cy = n;
            sample.next = null;
            cacheEntry.first = sample;
        }
    }

    Color traceGlossy(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createGlossyBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    Color traceReflection(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createReflectionBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    Color traceRefraction(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getRefractionDepth() >= this.maxRefractionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createRefractionBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    ShadingState traceFinalGather(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return null;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? ShadingState.createFinalGatherState(shadingState, ray, n) : null;
    }

    Color getGlobalRadiance(ShadingState shadingState) {
        if (this.giEngine == null) {
            return Color.BLACK;
        }
        return this.giEngine.getGlobalRadiance(shadingState);
    }

    Color getIrradiance(ShadingState shadingState, Color color) {
        if (this.giEngine == null || shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return Color.BLACK;
        }
        return this.giEngine.getIrradiance(shadingState, color);
    }

    void initLightSamples(ShadingState shadingState) {
        for (LightSource lightSource : this.lights) {
            lightSource.getSamples(shadingState);
        }
    }

    void initCausticSamples(ShadingState shadingState) {
        if (this.causticPhotonMap != null) {
            this.causticPhotonMap.getSamples(shadingState);
        }
    }

    private static class Sample {
        Instance i;
        Shader s;
        float nx;
        float ny;
        float nz;
        Color c;
        Sample next;

        private Sample() {
        }
    }

    private static class CacheEntry {
        int cx;
        int cy;
        Sample first;

        private CacheEntry() {
        }
    }
}

