/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Geometry;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Modifier;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.RenderObject;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class Instance
implements RenderObject {
    private Matrix4 o2w;
    private Matrix4 w2o;
    private BoundingBox bounds;
    private Geometry geometry;
    private Shader[] shaders;
    private Modifier[] modifiers;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        Matrix4 matrix4;
        String[] stringArray;
        String[] stringArray2;
        String string = parameterList.getString("geometry", null);
        if (this.geometry == null || string != null) {
            if (string == null) {
                UI.printError(UI.Module.GEOM, "geometry parameter missing - unable to create instance", new Object[0]);
                return false;
            }
            this.geometry = sunflowAPI.lookupGeometry(string);
            if (this.geometry == null) {
                UI.printError(UI.Module.GEOM, "Geometry \"%s\" was not declared yet - instance is invalid", string);
                return false;
            }
        }
        if ((stringArray2 = parameterList.getStringArray("shaders", null)) != null) {
            this.shaders = new Shader[stringArray2.length];
            for (int i = 0; i < this.shaders.length; ++i) {
                this.shaders[i] = sunflowAPI.lookupShader(stringArray2[i]);
                if (this.shaders[i] != null) continue;
                UI.printWarning(UI.Module.GEOM, "Shader \"%s\" was not declared yet - ignoring", stringArray2[i]);
            }
        }
        if ((stringArray = parameterList.getStringArray("modifiers", null)) != null) {
            this.modifiers = new Modifier[stringArray.length];
            for (int i = 0; i < this.modifiers.length; ++i) {
                this.modifiers[i] = sunflowAPI.lookupModifier(stringArray[i]);
                if (this.modifiers[i] != null) continue;
                UI.printWarning(UI.Module.GEOM, "Modifier \"%s\" was not declared yet - ignoring", stringArray[i]);
            }
        }
        if ((matrix4 = parameterList.getMatrix("transform", this.o2w)) != this.o2w) {
            this.o2w = matrix4;
            if (this.o2w != null) {
                this.w2o = this.o2w.inverse();
                if (this.w2o == null) {
                    UI.printError(UI.Module.GEOM, "Unable to compute transform inverse - determinant is: %g", Float.valueOf(this.o2w.determinant()));
                    return false;
                }
            } else {
                this.w2o = null;
                this.o2w = null;
            }
        }
        return true;
    }

    public void updateBounds() {
        this.bounds = this.geometry.getWorldBounds(this.o2w);
    }

    public boolean hasGeometry(Geometry geometry) {
        return this.geometry == geometry;
    }

    public void removeShader(Shader shader) {
        if (this.shaders != null) {
            for (int i = 0; i < this.shaders.length; ++i) {
                if (this.shaders[i] != shader) continue;
                this.shaders[i] = null;
            }
        }
    }

    public void removeModifier(Modifier modifier) {
        if (this.modifiers != null) {
            for (int i = 0; i < this.modifiers.length; ++i) {
                if (this.modifiers[i] != modifier) continue;
                this.modifiers[i] = null;
            }
        }
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    int getNumPrimitives() {
        return this.geometry.getNumPrimitives();
    }

    void intersect(Ray ray, IntersectionState intersectionState) {
        Ray ray2 = ray.transform(this.w2o);
        intersectionState.current = this;
        this.geometry.intersect(ray2, intersectionState);
        ray.setMax(ray2.getMax());
    }

    public void prepareShadingState(ShadingState shadingState) {
        this.geometry.prepareShadingState(shadingState);
        if (shadingState.getNormal() != null && shadingState.getGeoNormal() != null) {
            shadingState.correctShadingNormal();
        }
        if (shadingState.getModifier() != null) {
            shadingState.getModifier().modify(shadingState);
        }
    }

    public Shader getShader(int n) {
        if (this.shaders == null || n < 0 || n >= this.shaders.length) {
            return null;
        }
        return this.shaders[n];
    }

    public Modifier getModifier(int n) {
        if (this.modifiers == null || n < 0 || n >= this.modifiers.length) {
            return null;
        }
        return this.modifiers[n];
    }

    public Point3 transformObjectToWorld(Point3 point3) {
        return this.o2w == null ? new Point3(point3) : this.o2w.transformP(point3);
    }

    public Point3 transformWorldToObject(Point3 point3) {
        return this.o2w == null ? new Point3(point3) : this.w2o.transformP(point3);
    }

    public Vector3 transformNormalObjectToWorld(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.w2o.transformTransposeV(vector3);
    }

    public Vector3 transformNormalWorldToObject(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.o2w.transformTransposeV(vector3);
    }

    public Vector3 transformVectorObjectToWorld(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.o2w.transformV(vector3);
    }

    public Vector3 transformVectorWorldToObject(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.w2o.transformV(vector3);
    }

    PrimitiveList getBakingPrimitives() {
        return this.geometry.getBakingPrimitives();
    }

    Geometry getGeometry() {
        return this.geometry;
    }
}

