/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.RenderObject;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class Camera
implements RenderObject {
    private final CameraLens lens;
    private Matrix4[] c2w;
    private Matrix4[] w2c;

    public Camera(CameraLens cameraLens) {
        this.lens = cameraLens;
        this.w2c = new Matrix4[1];
        this.c2w = this.w2c;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        int n;
        int n2 = parameterList.getInt("transform.steps", 0);
        if (n2 <= 0) {
            this.updateCameraMatrix(-1, parameterList);
        } else {
            this.c2w = new Matrix4[n2];
            for (n = 0; n < n2; ++n) {
                if (this.updateCameraMatrix(n, parameterList)) continue;
                UI.printError(UI.Module.CAM, "Camera matrix for step %d was not specified!", n + 1);
                return false;
            }
        }
        this.w2c = new Matrix4[this.c2w.length];
        for (n = 0; n < this.c2w.length; ++n) {
            if (this.c2w[n] != null) {
                this.w2c[n] = this.c2w[n].inverse();
                if (this.w2c[n] != null) continue;
                UI.printError(UI.Module.CAM, "Camera matrix is not invertible", new Object[0]);
                return false;
            }
            this.w2c[n] = null;
        }
        return this.lens.update(parameterList, sunflowAPI);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateCameraMatrix(int n, ParameterList parameterList) {
        Matrix4 matrix4;
        String string;
        String string2 = string = n < 0 ? "" : String.format("[%d]", n);
        if (n < 0) {
            n = 0;
        }
        if ((matrix4 = parameterList.getMatrix(String.format("transform%s", string), null)) != null) {
            this.c2w[n] = matrix4;
            return true;
        }
        Point3 point3 = parameterList.getPoint(String.format("eye%s", string), null);
        Point3 point32 = parameterList.getPoint(String.format("target%s", string), null);
        Vector3 vector3 = parameterList.getVector(String.format("up%s", string), null);
        if (point3 != null && point32 != null && vector3 != null) {
            this.c2w[n] = Matrix4.fromBasis(OrthoNormalBasis.makeFromWV(Point3.sub(point3, point32, new Vector3()), vector3));
            this.c2w[n] = Matrix4.translation(point3.x, point3.y, point3.z).multiply(this.c2w[n]);
            return true;
        }
        if (string.length() != 0) return false;
        return true;
    }

    public Ray getRay(float f, float f2, int n, int n2, double d, double d2, double d3) {
        Ray ray = this.lens.getRay(f, f2, n, n2, d, d2, d3);
        if (ray != null) {
            if (this.c2w.length == 1) {
                ray = ray.transform(this.c2w[0]);
            } else {
                double d4 = d3 * (double)(this.c2w.length - 1);
                int n3 = (int)d4;
                int n4 = Math.min(n3 + 1, this.c2w.length - 1);
                ray = ray.transform(Matrix4.blend(this.c2w[n3], this.c2w[n4], (float)(d4 - (double)n3)));
            }
            ray.normalize();
        }
        return ray;
    }

    Ray getRay(Point3 point3) {
        return new Ray(this.c2w == null ? new Point3(0.0f, 0.0f, 0.0f) : this.c2w[0].transformP(new Point3(0.0f, 0.0f, 0.0f)), point3);
    }

    Matrix4 getCameraToWorld() {
        return this.c2w == null ? Matrix4.IDENTITY : this.c2w[0];
    }

    Matrix4 getWorldToCamera() {
        return this.w2c == null ? Matrix4.IDENTITY : this.w2c[0];
    }
}

