/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.accel.BoundingIntervalHierarchy;
import org.sunflow.core.accel.KDTree;
import org.sunflow.core.accel.NullAccelerator;
import org.sunflow.core.accel.UniformGrid;
import org.sunflow.system.UI;

class AccelerationStructureFactory {
    AccelerationStructureFactory() {
    }

    static final AccelerationStructure create(String string, int n, boolean bl) {
        if (string == null || string.equals("auto")) {
            if (bl) {
                if (n > 20000000) {
                    return new UniformGrid();
                }
                if (n > 2000000) {
                    return new BoundingIntervalHierarchy();
                }
                if (n > 2) {
                    return new KDTree();
                }
                return new NullAccelerator();
            }
            if (n > 2) {
                return new BoundingIntervalHierarchy();
            }
            return new NullAccelerator();
        }
        if (string.equals("uniformgrid")) {
            return new UniformGrid();
        }
        if (string.equals("null")) {
            return new NullAccelerator();
        }
        if (string.equals("kdtree")) {
            return new KDTree();
        }
        if (string.equals("bih")) {
            return new BoundingIntervalHierarchy();
        }
        UI.printWarning(UI.Module.ACCEL, "Unrecognized intersection accelerator \"%s\" - using auto", string);
        return AccelerationStructureFactory.create(null, n, bl);
    }
}

