/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.sunflow.RenderObjectMap;
import org.sunflow.core.Camera;
import org.sunflow.core.CameraLens;
import org.sunflow.core.Display;
import org.sunflow.core.Geometry;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.Instance;
import org.sunflow.core.LightSource;
import org.sunflow.core.Modifier;
import org.sunflow.core.Options;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Scene;
import org.sunflow.core.SceneParser;
import org.sunflow.core.Shader;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.parser.RA2Parser;
import org.sunflow.core.parser.RA3Parser;
import org.sunflow.core.parser.SCParser;
import org.sunflow.core.parser.ShaveRibParser;
import org.sunflow.core.parser.TriParser;
import org.sunflow.core.renderer.BucketRenderer;
import org.sunflow.core.renderer.ProgressiveRenderer;
import org.sunflow.core.renderer.SimpleRenderer;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.SearchPath;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class SunflowAPI {
    public static final String VERSION = "0.07.2";
    public static final String DEFAULT_OPTIONS = "::options";
    private Scene scene;
    private BucketRenderer bucketRenderer;
    private ProgressiveRenderer progressiveRenderer;
    private SearchPath includeSearchPath;
    private SearchPath textureSearchPath;
    private ParameterList parameterList;
    private RenderObjectMap renderObjects;
    private int currentFrame;

    public static void runSystemCheck() {
        String string;
        long l = Runtime.getRuntime().maxMemory() / 0x100000L;
        if (l < 800L) {
            UI.printError(UI.Module.API, "JVM available memory is below %d MB (found %d MB only).\nPlease make sure you launched the program with the -Xmx command line options.", 800L, l);
        }
        if ((string = System.getProperty("java.vm.name")) == null || !string.contains("HotSpot") || !string.contains("Server")) {
            UI.printError(UI.Module.API, "You do not appear to be running Sun's server JVM\nPerformance may suffer", new Object[0]);
        }
        UI.printDetailed(UI.Module.API, "Java environment settings:", new Object[0]);
        UI.printDetailed(UI.Module.API, "  * Max memory available : %d MB", l);
        UI.printDetailed(UI.Module.API, "  * Virtual machine name : %s", string == null ? "<unknown" : string);
        UI.printDetailed(UI.Module.API, "  * Operating system     : %s", System.getProperty("os.name"));
        UI.printDetailed(UI.Module.API, "  * CPU architecture     : %s", System.getProperty("os.arch"));
    }

    public SunflowAPI() {
        this.reset();
    }

    public final void reset() {
        this.scene = new Scene();
        this.bucketRenderer = new BucketRenderer();
        this.progressiveRenderer = new ProgressiveRenderer();
        this.includeSearchPath = new SearchPath("include");
        this.textureSearchPath = new SearchPath("texture");
        this.parameterList = new ParameterList();
        this.renderObjects = new RenderObjectMap();
        this.currentFrame = 1;
    }

    public final String getUniqueName(String string) {
        String string2;
        int n = 1;
        do {
            string2 = String.format("%s_%d", string, n);
            ++n;
        } while (this.renderObjects.has(string2));
        return string2;
    }

    public final void parameter(String string, String string2) {
        this.parameterList.addString(string, string2);
    }

    public final void parameter(String string, boolean bl) {
        this.parameterList.addBoolean(string, bl);
    }

    public final void parameter(String string, int n) {
        this.parameterList.addInteger(string, n);
    }

    public final void parameter(String string, float f) {
        this.parameterList.addFloat(string, f);
    }

    public final void parameter(String string, Color color) {
        this.parameterList.addColor(string, color);
    }

    public final void parameter(String string, Point3 point3) {
        this.parameterList.addPoints(string, ParameterList.InterpolationType.NONE, new float[]{point3.x, point3.y, point3.z});
    }

    public final void parameter(String string, Vector3 vector3) {
        this.parameterList.addVectors(string, ParameterList.InterpolationType.NONE, new float[]{vector3.x, vector3.y, vector3.z});
    }

    public final void parameter(String string, Matrix4 matrix4) {
        this.parameterList.addMatrices(string, ParameterList.InterpolationType.NONE, matrix4.asRowMajor());
    }

    public final void parameter(String string, int[] nArray) {
        this.parameterList.addIntegerArray(string, nArray);
    }

    public final void parameter(String string, String[] stringArray) {
        this.parameterList.addStringArray(string, stringArray);
    }

    public final void parameter(String string, String string2, String string3, float[] fArray) {
        ParameterList.InterpolationType interpolationType;
        try {
            interpolationType = ParameterList.InterpolationType.valueOf(string3.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UI.printError(UI.Module.API, "Unknown interpolation type: %s -- ignoring parameter \"%s\"", string3, string);
            return;
        }
        if (string2.equals("float")) {
            this.parameterList.addFloats(string, interpolationType, fArray);
        } else if (string2.equals("point")) {
            this.parameterList.addPoints(string, interpolationType, fArray);
        } else if (string2.equals("vector")) {
            this.parameterList.addVectors(string, interpolationType, fArray);
        } else if (string2.equals("texcoord")) {
            this.parameterList.addTexCoords(string, interpolationType, fArray);
        } else if (string2.equals("matrix")) {
            this.parameterList.addMatrices(string, interpolationType, fArray);
        } else {
            UI.printError(UI.Module.API, "Unknown parameter type: %s -- ignoring parameter \"%s\"", string2, string);
        }
    }

    public void remove(String string) {
        this.renderObjects.remove(string);
    }

    public boolean update(String string) {
        boolean bl = this.renderObjects.update(string, this.parameterList, this);
        this.parameterList.clear(bl);
        return bl;
    }

    public final void addIncludeSearchPath(String string) {
        this.includeSearchPath.addSearchPath(string);
    }

    public final void addTextureSearchPath(String string) {
        this.textureSearchPath.addSearchPath(string);
    }

    public final String resolveTextureFilename(String string) {
        return this.textureSearchPath.resolvePath(string);
    }

    public final String resolveIncludeFilename(String string) {
        return this.includeSearchPath.resolvePath(string);
    }

    public final void shader(String string, Shader shader) {
        if (shader != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare shader \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, shader);
        }
        if (this.lookupShader(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update shader \"%s\" - shader object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void modifier(String string, Modifier modifier) {
        if (modifier != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare modifier \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, modifier);
        }
        if (this.lookupModifier(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update modifier \"%s\" - modifier object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void geometry(String string, PrimitiveList primitiveList) {
        if (primitiveList != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare geometry \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, primitiveList);
        }
        if (this.lookupGeometry(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update geometry \"%s\" - geometry object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void geometry(String string, Tesselatable tesselatable) {
        if (tesselatable != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare geometry \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, tesselatable);
        }
        if (this.lookupGeometry(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update geometry \"%s\" - geometry object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void instance(String string, String string2) {
        if (string2 != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare instance \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.parameter("geometry", string2);
            this.renderObjects.put(string, new Instance());
        }
        if (this.lookupInstance(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update instance \"%s\" - instance object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void light(String string, LightSource lightSource) {
        if (lightSource != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare light \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, lightSource);
        }
        if (this.lookupLight(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update instance \"%s\" - instance object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void camera(String string, CameraLens cameraLens) {
        if (cameraLens != null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare camera \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, new Camera(cameraLens));
        }
        if (this.lookupCamera(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update camera \"%s\" - camera object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void options(String string) {
        if (this.lookupOptions(string) == null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare options \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, new Options());
        }
        assert (this.lookupOptions(string) != null);
        this.update(string);
    }

    public final Geometry lookupGeometry(String string) {
        return this.renderObjects.lookupGeometry(string);
    }

    private final Instance lookupInstance(String string) {
        return this.renderObjects.lookupInstance(string);
    }

    private final Camera lookupCamera(String string) {
        return this.renderObjects.lookupCamera(string);
    }

    private final Options lookupOptions(String string) {
        return this.renderObjects.lookupOptions(string);
    }

    public final Shader lookupShader(String string) {
        return this.renderObjects.lookupShader(string);
    }

    public final Modifier lookupModifier(String string) {
        return this.renderObjects.lookupModifier(string);
    }

    private final LightSource lookupLight(String string) {
        return this.renderObjects.lookupLight(string);
    }

    public final void shaderOverride(String string, boolean bl) {
        this.scene.setShaderOverride(this.lookupShader(string), bl);
    }

    public final void render(String string, Display display) {
        Object object;
        this.renderObjects.updateScene(this.scene);
        Options options = this.lookupOptions(string);
        if (options == null) {
            options = new Options();
        }
        this.scene.setCamera(this.lookupCamera(options.getString("camera", null)));
        String string2 = options.getString("baking.instance", null);
        if (string2 != null) {
            object = this.lookupInstance(string2);
            if (object == null) {
                UI.printError(UI.Module.API, "Unable to bake instance \"%s\" - not found", string2);
                return;
            }
            this.scene.setBakingInstance((Instance)object);
        } else {
            this.scene.setBakingInstance(null);
        }
        object = options.getString("sampler", "bucket");
        ImageSampler imageSampler = null;
        if (((String)object).equals("none") || ((String)object).equals("null")) {
            imageSampler = null;
        } else if (((String)object).equals("bucket")) {
            imageSampler = this.bucketRenderer;
        } else if (((String)object).equals("ipr")) {
            imageSampler = this.progressiveRenderer;
        } else if (((String)object).equals("fast")) {
            imageSampler = new SimpleRenderer();
        } else {
            UI.printError(UI.Module.API, "Unknown sampler type: %s - aborting", object);
            return;
        }
        this.scene.render(options, imageSampler, display);
    }

    public final boolean parse(String string) {
        if (string == null) {
            return false;
        }
        string = this.includeSearchPath.resolvePath(string);
        SceneParser sceneParser = null;
        if (string.endsWith(".sc")) {
            sceneParser = new SCParser();
        } else if (string.endsWith(".ra2")) {
            sceneParser = new RA2Parser();
        } else if (string.endsWith(".ra3")) {
            sceneParser = new RA3Parser();
        } else if (string.endsWith(".tri")) {
            sceneParser = new TriParser();
        } else if (string.endsWith(".rib")) {
            sceneParser = new ShaveRibParser();
        } else {
            UI.printError(UI.Module.API, "Unable to find a suitable parser for: \"%s\"", string);
            return false;
        }
        String string2 = new File(string).getAbsoluteFile().getParentFile().getAbsolutePath();
        this.includeSearchPath.addSearchPath(string2);
        this.textureSearchPath.addSearchPath(string2);
        return sceneParser.parse(string, this);
    }

    public final BoundingBox getBounds() {
        return this.scene.getBounds();
    }

    public void build() {
    }

    public static SunflowAPI create(String string, int n) {
        if (string == null) {
            return new SunflowAPI();
        }
        SunflowAPI sunflowAPI = null;
        if (string.endsWith(".java")) {
            Object object;
            Timer timer = new Timer();
            UI.printInfo(UI.Module.API, "Compiling \"" + string + "\" ...", new Object[0]);
            timer.start();
            try {
                object = new FileInputStream(string);
                sunflowAPI = (SunflowAPI)ClassBodyEvaluator.createFastClassBodyEvaluator(new Scanner(string, (InputStream)object), SunflowAPI.class, ClassLoader.getSystemClassLoader());
                ((FileInputStream)object).close();
            }
            catch (CompileException compileException) {
                UI.printError(UI.Module.API, "Could not compile: \"%s\"", string);
                UI.printError(UI.Module.API, "%s", compileException.getMessage());
                return null;
            }
            catch (Parser.ParseException parseException) {
                UI.printError(UI.Module.API, "Could not compile: \"%s\"", string);
                UI.printError(UI.Module.API, "%s", parseException.getMessage());
                return null;
            }
            catch (Scanner.ScanException scanException) {
                UI.printError(UI.Module.API, "Could not compile: \"%s\"", string);
                UI.printError(UI.Module.API, "%s", scanException.getMessage());
                return null;
            }
            catch (IOException iOException) {
                UI.printError(UI.Module.API, "Could not compile: \"%s\"", string);
                UI.printError(UI.Module.API, "%s", iOException.getMessage());
                return null;
            }
            timer.end();
            UI.printInfo(UI.Module.API, "Compile time: " + timer.toString(), new Object[0]);
            if (sunflowAPI != null) {
                object = new File(string).getAbsoluteFile().getParentFile().getAbsolutePath();
                sunflowAPI.includeSearchPath.addSearchPath((String)object);
                sunflowAPI.textureSearchPath.addSearchPath((String)object);
            }
            UI.printInfo(UI.Module.API, "Build script running ...", new Object[0]);
            timer.start();
            sunflowAPI.setCurrentFrame(n);
            sunflowAPI.build();
            timer.end();
            UI.printInfo(UI.Module.API, "Build script time: %s", timer.toString());
        } else {
            sunflowAPI = new SunflowAPI();
            sunflowAPI = sunflowAPI.parse(string) ? sunflowAPI : null;
        }
        return sunflowAPI;
    }

    public static SunflowAPI compile(String string) {
        try {
            Timer timer = new Timer();
            timer.start();
            SunflowAPI sunflowAPI = (SunflowAPI)ClassBodyEvaluator.createFastClassBodyEvaluator(new Scanner(null, new StringReader(string)), SunflowAPI.class, null);
            timer.end();
            UI.printInfo(UI.Module.API, "Compile time: %s", timer.toString());
            return sunflowAPI;
        }
        catch (CompileException compileException) {
            UI.printError(UI.Module.API, "%s", compileException.getMessage());
            return null;
        }
        catch (Parser.ParseException parseException) {
            UI.printError(UI.Module.API, "%s", parseException.getMessage());
            return null;
        }
        catch (Scanner.ScanException scanException) {
            UI.printError(UI.Module.API, "%s", scanException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.API, "%s", iOException.getMessage());
            return null;
        }
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int n) {
        this.currentFrame = n;
    }
}

