/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Display;
import org.sunflow.core.camera.PinholeLens;
import org.sunflow.core.display.FastDisplay;
import org.sunflow.core.display.FileDisplay;
import org.sunflow.core.light.DirectionalSpotlight;
import org.sunflow.core.primitive.Plane;
import org.sunflow.core.shader.DiffuseShader;
import org.sunflow.core.shader.ShinyDiffuseShader;
import org.sunflow.core.tesselatable.Gumbo;
import org.sunflow.core.tesselatable.Teapot;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.system.ui.ConsoleInterface;

public class RealtimeBenchmark
extends SunflowAPI {
    public RealtimeBenchmark(boolean bl, int n) {
        Display display = bl ? new FastDisplay() : new FileDisplay(false);
        UI.printInfo(UI.Module.BENCH, "Preparing benchmarking scene ...", new Object[0]);
        this.parameter("threads", n);
        this.parameter("threads.lowPriority", false);
        this.parameter("resolutionX", 512);
        this.parameter("resolutionY", 512);
        this.parameter("aa.min", -3);
        this.parameter("aa.max", 0);
        this.parameter("depths.diffuse", 1);
        this.parameter("depths.reflection", 1);
        this.parameter("depths.refraction", 0);
        this.parameter("bucket.order", "hilbert");
        this.parameter("bucket.size", 32);
        this.options("::options");
        Point3 point3 = new Point3(30.0f, 0.0f, 10.967f);
        Point3 point32 = new Point3(0.0f, 0.0f, 5.4f);
        Vector3 vector3 = new Vector3(0.0f, 0.0f, 1.0f);
        this.parameter("eye", point3);
        this.parameter("target", point32);
        this.parameter("up", vector3);
        this.parameter("fov", 45.0f);
        String string = this.getUniqueName("camera");
        this.camera(string, new PinholeLens());
        this.parameter("camera", string);
        this.options("::options");
        this.createGeometry();
        UI.printInfo(UI.Module.BENCH, "Rendering warmup frame ...", new Object[0]);
        this.render("::options", display);
        UI.set(null);
        Timer timer = new Timer();
        timer.start();
        float f = 0.0f;
        int n2 = 0;
        while ((double)f < Math.PI * 4) {
            point3.x = 30.0f * (float)Math.cos(f);
            point3.y = 30.0f * (float)Math.sin(f);
            f = (float)((double)f + 0.10471975511965977);
            ++n2;
            this.parameter("eye", point3);
            this.parameter("target", point32);
            this.parameter("up", vector3);
            this.camera(string, null);
            this.render("::options", display);
        }
        timer.end();
        UI.set(new ConsoleInterface());
        UI.printInfo(UI.Module.BENCH, "Benchmark results:", new Object[0]);
        UI.printInfo(UI.Module.BENCH, "  * Average FPS:         %.2f", (double)n2 / timer.seconds());
        UI.printInfo(UI.Module.BENCH, "  * Total time:          %s", timer);
    }

    private void createGeometry() {
        this.parameter("source", new Point3(-15.5945f, -30.0581f, 45.967f));
        this.parameter("dir", new Vector3(15.5945f, 30.0581f, -45.967f));
        this.parameter("radius", 60.0f);
        this.parameter("radiance", Color.white().mul(3.0f));
        this.light("light", new DirectionalSpotlight());
        this.parameter("gi.engine", "fake");
        this.parameter("gi.fake.sky", new Color(0.25f, 0.25f, 0.25f));
        this.parameter("gi.fake.ground", new Color(0.01f, 0.01f, 0.5f));
        this.parameter("gi.fake.up", new Vector3(0.0f, 0.0f, 1.0f));
        this.options("::options");
        this.parameter("diffuse", Color.white().mul(0.5f));
        this.shader("default", new DiffuseShader());
        this.parameter("diffuse", Color.white().mul(0.5f));
        this.parameter("shiny", 0.2f);
        this.shader("refl", new ShinyDiffuseShader());
        this.parameter("subdivs", 10);
        this.geometry("teapot", new Teapot());
        this.parameter("shaders", "default");
        Matrix4 matrix4 = Matrix4.IDENTITY;
        matrix4 = Matrix4.scale(0.075f).multiply(matrix4);
        matrix4 = Matrix4.rotateZ((float)Math.toRadians(-45.0)).multiply(matrix4);
        matrix4 = Matrix4.translation(-7.0f, 0.0f, 0.0f).multiply(matrix4);
        this.parameter("transform", matrix4);
        this.instance("teapot.instance", "teapot");
        this.parameter("subdivs", 10);
        this.geometry("gumbo", new Gumbo());
        matrix4 = Matrix4.IDENTITY;
        matrix4 = Matrix4.scale(0.5f).multiply(matrix4);
        matrix4 = Matrix4.rotateZ((float)Math.toRadians(25.0)).multiply(matrix4);
        matrix4 = Matrix4.translation(3.0f, -7.0f, 0.0f).multiply(matrix4);
        this.parameter("shaders", "default");
        this.parameter("transform", matrix4);
        this.instance("gumbo.instance", "gumbo");
        this.parameter("center", new Point3(0.0f, 0.0f, 0.0f));
        this.parameter("normal", new Vector3(0.0f, 0.0f, 1.0f));
        this.geometry("ground", new Plane());
        this.parameter("shaders", "refl");
        this.instance("ground.instance", "ground");
    }
}

