/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Display;
import org.sunflow.core.camera.PinholeLens;
import org.sunflow.core.display.FileDisplay;
import org.sunflow.core.light.TriangleMeshLight;
import org.sunflow.core.primitive.Sphere;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.DiffuseShader;
import org.sunflow.core.shader.GlassShader;
import org.sunflow.core.shader.MirrorShader;
import org.sunflow.core.tesselatable.Teapot;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.BenchmarkFramework;
import org.sunflow.system.BenchmarkTest;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;

public class Benchmark
implements BenchmarkTest,
UserInterface,
Display {
    private int resolution;
    private boolean showOutput;
    private boolean showBenchmarkOutput;
    private boolean saveOutput;
    private int threads;
    private int[] referenceImage;
    private int[] validationImage;
    private int errorThreshold;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Benchmark options:");
            System.out.println("  -regen                        Regenerate reference images for a variety of sizes");
            System.out.println("  -bench [threads] [resolution] Run a single iteration of the benchmark using the specified thread count and image resolution");
            System.out.println("                                Default: threads=0 (auto-detect cpus), resolution=256");
        } else if (stringArray[0].equals("-regen")) {
            int[] nArray;
            for (int n : nArray = new int[]{32, 64, 96, 128, 256, 384, 512}) {
                Benchmark benchmark = new Benchmark(n, true, false, true);
                benchmark.kernelMain();
            }
        } else if (stringArray[0].equals("-bench")) {
            int n = 0;
            int n2 = 256;
            if (stringArray.length > 1) {
                n = Integer.parseInt(stringArray[1]);
            }
            if (stringArray.length > 2) {
                n2 = Integer.parseInt(stringArray[2]);
            }
            Benchmark benchmark = new Benchmark(n2, false, true, false, n);
            benchmark.kernelBegin();
            benchmark.kernelMain();
            benchmark.kernelEnd();
        }
    }

    public Benchmark() {
        this(384, false, true, false);
    }

    public Benchmark(int n, boolean bl, boolean bl2, boolean bl3) {
        this(n, bl, bl2, bl3, 0);
    }

    public Benchmark(int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        UI.set(this);
        this.resolution = n;
        this.showOutput = bl;
        this.showBenchmarkOutput = bl2;
        this.saveOutput = bl3;
        this.threads = n2;
        this.errorThreshold = 6;
        if (bl3) {
            return;
        }
        URL uRL = Benchmark.class.getResource(String.format("/resources/golden_%04X.png", n));
        if (uRL == null) {
            UI.printError(UI.Module.BENCH, "Unable to find reference frame!", new Object[0]);
        }
        UI.printInfo(UI.Module.BENCH, "Loading reference image from: %s", uRL);
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            if (bufferedImage.getWidth() != n || bufferedImage.getHeight() != n) {
                UI.printError(UI.Module.BENCH, "Reference image has invalid resolution! Expected %dx%d found %dx%d", n, n, bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.referenceImage = new int[n * n];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = 0;
                while (n4 < n) {
                    this.referenceImage[n3] = bufferedImage.getRGB(n4, n - 1 - i);
                    ++n4;
                    ++n3;
                }
            }
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.BENCH, "Unable to load reference frame!", new Object[0]);
        }
    }

    public void execute() {
        BenchmarkFramework benchmarkFramework = new BenchmarkFramework(10, 600);
        benchmarkFramework.execute(this);
    }

    public void kernelBegin() {
        this.validationImage = new int[this.resolution * this.resolution];
    }

    public void kernelMain() {
        new BenchmarkScene();
    }

    public void kernelEnd() {
        int n = 0;
        if (this.referenceImage != null && this.validationImage.length == this.referenceImage.length) {
            for (int i = 0; i < this.validationImage.length; ++i) {
                n += Math.abs((this.validationImage[i] & 0xFF) - (this.referenceImage[i] & 0xFF));
                n += Math.abs((this.validationImage[i] >> 8 & 0xFF) - (this.referenceImage[i] >> 8 & 0xFF));
                n += Math.abs((this.validationImage[i] >> 16 & 0xFF) - (this.referenceImage[i] >> 16 & 0xFF));
            }
            if (n > this.errorThreshold) {
                UI.printError(UI.Module.BENCH, "Image check failed! - #errors: %d", n);
            } else {
                UI.printInfo(UI.Module.BENCH, "Image check passed!", new Object[0]);
            }
        } else {
            UI.printError(UI.Module.BENCH, "Image check failed! - reference is not comparable", new Object[0]);
        }
    }

    public void print(UI.Module module, UI.PrintLevel printLevel, String string) {
        if (this.showOutput || this.showBenchmarkOutput && module == UI.Module.BENCH) {
            System.out.println(UI.formatOutput(module, printLevel, string));
        }
        if (printLevel == UI.PrintLevel.ERROR) {
            throw new RuntimeException(string);
        }
    }

    public void taskStart(String string, int n, int n2) {
    }

    public void taskStop() {
    }

    public void taskUpdate(int n) {
    }

    public void imageBegin(int n, int n2, int n3) {
    }

    public void imageEnd() {
    }

    public void imageFill(int n, int n2, int n3, int n4, Color color) {
    }

    public void imagePrepare(int n, int n2, int n3, int n4, int n5) {
    }

    public void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray) {
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = 0;
            int n8 = n + this.resolution * (this.resolution - 1 - n2);
            while (n7 < n3) {
                this.validationImage[n8] = colorArray[n6].copy().toNonLinear().toRGB();
                ++n7;
                ++n6;
                ++n8;
            }
            ++n5;
            ++n2;
        }
    }

    private class BenchmarkScene
    extends SunflowAPI {
        public BenchmarkScene() {
            this.build();
            this.render("::options", Benchmark.this.saveOutput ? new FileDisplay(String.format("resources/golden_%04X.png", Benchmark.this.resolution)) : Benchmark.this);
        }

        public void build() {
            this.parameter("threads", Benchmark.this.threads);
            this.parameter("threads.lowPriority", false);
            this.parameter("resolutionX", Benchmark.this.resolution);
            this.parameter("resolutionY", Benchmark.this.resolution);
            this.parameter("aa.min", -1);
            this.parameter("aa.max", 1);
            this.parameter("filter", "triangle");
            this.parameter("depths.diffuse", 2);
            this.parameter("depths.reflection", 2);
            this.parameter("depths.refraction", 2);
            this.parameter("bucket.order", "hilbert");
            this.parameter("bucket.size", 32);
            this.parameter("gi.engine", "igi");
            this.parameter("gi.igi.samples", 90);
            this.parameter("gi.igi.c", 8.0E-6f);
            this.options("::options");
            this.buildCornellBox();
        }

        private void buildCornellBox() {
            this.parameter("eye", new Point3(0.0f, 0.0f, -600.0f));
            this.parameter("target", new Point3(0.0f, 0.0f, 0.0f));
            this.parameter("up", new Vector3(0.0f, 1.0f, 0.0f));
            this.parameter("fov", 45.0f);
            this.camera("main_camera", new PinholeLens());
            this.parameter("camera", "main_camera");
            this.options("::options");
            Color color = new Color(0.7f, 0.7f, 0.7f);
            Color color2 = new Color(0.25f, 0.25f, 0.8f);
            Color color3 = new Color(0.8f, 0.25f, 0.25f);
            Color color4 = new Color(15.0f, 15.0f, 15.0f);
            float f = -200.0f;
            float f2 = 200.0f;
            float f3 = -160.0f;
            float f4 = f3 + 400.0f;
            float f5 = -250.0f;
            float f6 = 200.0f;
            float[] fArray = new float[]{f, f3, f5, f2, f3, f5, f2, f3, f6, f, f3, f6, f, f4, f5, f2, f4, f5, f2, f4, f6, f, f4, f6};
            int[] nArray = new int[]{0, 1, 2, 2, 3, 0, 4, 5, 6, 6, 7, 4, 1, 2, 5, 5, 6, 2, 2, 3, 6, 6, 7, 3, 0, 3, 4, 4, 7, 3};
            this.parameter("diffuse", color);
            this.shader("gray_shader", new DiffuseShader());
            this.parameter("diffuse", color3);
            this.shader("red_shader", new DiffuseShader());
            this.parameter("diffuse", color2);
            this.shader("blue_shader", new DiffuseShader());
            this.parameter("triangles", nArray);
            this.parameter("points", "point", "vertex", fArray);
            this.parameter("faceshaders", new int[]{0, 0, 0, 0, 1, 1, 0, 0, 2, 2});
            this.geometry("walls", new TriangleMesh());
            this.parameter("shaders", new String[]{"gray_shader", "red_shader", "blue_shader"});
            this.instance("walls.instance", "walls");
            this.parameter("points", "point", "vertex", new float[]{-50.0f, f4 - 1.0f, -50.0f, 50.0f, f4 - 1.0f, -50.0f, 50.0f, f4 - 1.0f, 50.0f, -50.0f, f4 - 1.0f, 50.0f});
            this.parameter("triangles", new int[]{0, 1, 2, 2, 3, 0});
            this.parameter("radiance", color4);
            this.parameter("samples", 8);
            TriangleMeshLight triangleMeshLight = new TriangleMeshLight();
            triangleMeshLight.init("light", this);
            this.parameter("eta", 1.6f);
            this.shader("Glass", new GlassShader());
            this.sphere("glass_sphere", "Glass", -120.0f, f3 + 55.0f, -150.0f, 50.0f);
            this.parameter("color", new Color(0.7f, 0.7f, 0.7f));
            this.shader("Mirror", new MirrorShader());
            this.sphere("mirror_sphere", "Mirror", 100.0f, f3 + 60.0f, -50.0f, 50.0f);
            this.geometry("teapot", new Teapot());
            this.parameter("transform", Matrix4.translation(80.0f, -50.0f, 100.0f).multiply(Matrix4.rotateX(-0.5235988f)).multiply(Matrix4.rotateY(0.7853982f)).multiply(Matrix4.rotateX(-1.5707964f).multiply(Matrix4.scale(1.2f))));
            this.parameter("shaders", "gray_shader");
            this.instance("teapot.instance1", "teapot");
            this.parameter("transform", Matrix4.translation(-80.0f, -160.0f, 50.0f).multiply(Matrix4.rotateY(0.7853982f)).multiply(Matrix4.rotateX(-1.5707964f).multiply(Matrix4.scale(1.2f))));
            this.parameter("shaders", "gray_shader");
            this.instance("teapot.instance2", "teapot");
        }

        private void sphere(String string, String string2, float f, float f2, float f3, float f4) {
            this.geometry(string, new Sphere());
            this.parameter("transform", Matrix4.translation(f, f2, f3).multiply(Matrix4.scale(f4)));
            this.parameter("shaders", string2);
            this.instance(string + ".instance", string);
        }
    }
}

