/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.sunflow.Benchmark;
import org.sunflow.RealtimeBenchmark;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Display;
import org.sunflow.core.Shader;
import org.sunflow.core.TextureCache;
import org.sunflow.core.accel.KDTree;
import org.sunflow.core.display.FileDisplay;
import org.sunflow.core.display.FrameDisplay;
import org.sunflow.core.display.ImgPipeDisplay;
import org.sunflow.core.display.OpenExrDisplay;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.AmbientOcclusionShader;
import org.sunflow.core.shader.IDShader;
import org.sunflow.core.shader.NormalShader;
import org.sunflow.core.shader.PrimIDShader;
import org.sunflow.core.shader.QuickGrayShader;
import org.sunflow.core.shader.UVShader;
import org.sunflow.core.shader.WireframeShader;
import org.sunflow.image.Color;
import org.sunflow.system.ImagePanel;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;

public class SunflowGUI
extends JFrame
implements UserInterface {
    private static final int DEFAULT_WIDTH = 1024;
    private static final int DEFAULT_HEIGHT = 768;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JMenuItem exitMenuItem;
    private JSeparator jSeparator2;
    private JPanel jPanel1;
    private JButton renderButton;
    private JMenuItem jMenuItem4;
    private JSeparator jSeparator1;
    private JMenuItem fitWindowMenuItem;
    private JMenuItem tileWindowMenuItem;
    private JSeparator jSeparator5;
    private JMenuItem consoleWindowMenuItem;
    private JMenuItem editorWindowMenuItem;
    private JMenuItem imageWindowMenuItem;
    private JMenu windowMenu;
    private JInternalFrame consoleFrame;
    private JInternalFrame editorFrame;
    private JInternalFrame imagePanelFrame;
    private JDesktopPane desktop;
    private JCheckBoxMenuItem smallTrianglesMenuItem;
    private JMenuItem textureCacheClearMenuItem;
    private JSeparator jSeparator4;
    private JMenuItem resetZoomMenuItem;
    private JMenu imageMenu;
    private ImagePanel imagePanel;
    private JPanel jPanel6;
    private JCheckBoxMenuItem clearLogMenuItem;
    private JPanel jPanel5;
    private JButton taskCancelButton;
    private JProgressBar taskProgressBar;
    private JSeparator jSeparator3;
    private JCheckBoxMenuItem autoBuildMenuItem;
    private JMenuItem iprMenuItem;
    private JMenuItem renderMenuItem;
    private JMenuItem buildMenuItem;
    private JMenu sceneMenu;
    private JTextArea editorTextArea;
    private JTextArea consoleTextArea;
    private JButton clearConsoleButton;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JButton iprButton;
    private JButton buildButton;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem openFileMenuItem;
    private JMenuItem newFileMenuItem;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private String currentFile = null;
    private String currentTask;
    private int currentTaskLastP;
    private SunflowAPI api = null;

    public static void usage(boolean bl) {
        System.out.println("Usage: SunflowGUI [options] scenefile");
        if (bl) {
            System.out.println("Sunflow v0.07.2 textmode");
            System.out.println("Renders the specified scene file");
            System.out.println("Options:");
            System.out.println("  -o filename      Saves the output as the specified filename (png, hdr, tga)");
            System.out.println("                   #'s get expanded to the current frame number");
            System.out.println("  -nogui           Don't open the frame showing rendering progress");
            System.out.println("  -ipr             Render using progressive algorithm");
            System.out.println("  -sampler type    Render using the specified algorithm");
            System.out.println("  -threads n       Render using n threads");
            System.out.println("  -lopri           Set thread priority to low (default)");
            System.out.println("  -hipri           Set thread priority to high");
            System.out.println("  -smallmesh       Load triangle meshes using triangles optimized for memory use");
            System.out.println("  -dumpkd          Dump KDTree to an obj file for visualization");
            System.out.println("  -buildonly       Do not call render method after loading the scene");
            System.out.println("  -showaa          Display sampling levels per pixel for bucket renderer");
            System.out.println("  -nogi            Disable any global illumination engines in the scene");
            System.out.println("  -nocaustics      Disable any caustic engine in the scene");
            System.out.println("  -pathgi n        Use path tracing with n samples to render global illumination");
            System.out.println("  -quick_ambocc d  Applies ambient occlusion to the scene with specified maximum distance");
            System.out.println("  -quick_uvs       Applies a surface uv visualization shader to the scene");
            System.out.println("  -quick_normals   Applies a surface normal visualization shader to the scene");
            System.out.println("  -quick_id        Renders using a unique color for each instance");
            System.out.println("  -quick_prims     Renders using a unique color for each primitive");
            System.out.println("  -quick_gray      Renders using a plain gray diffuse shader");
            System.out.println("  -quick_wire      Renders using a wireframe shader");
            System.out.println("  -resolution w h  Changes the render resolution to the specified width and height (in pixels)");
            System.out.println("  -aa min max      Overrides the image anti-aliasing depths");
            System.out.println("  -bucket n order  Changes the default bucket size to n pixels and the default order");
            System.out.println("  -bake name       Bakes a lightmap for the specified instance");
            System.out.println("  -bakedir dir     Selects the type of lightmap baking: dir=view or ortho");
            System.out.println("  -filter type     Selects the image filter to use");
            System.out.println("  -bench           Run several built-in scenes for benchmark purposes");
            System.out.println("  -rtbench         Run realtime ray-tracing benchmark");
            System.out.println("  -frame n         Set frame number to the specified value");
            System.out.println("  -anim n1 n2      Render all frames between the two specified values (inclusive)");
            System.out.println("  -v verbosity     Set the verbosity level: 0=none,1=errors,2=warnings,3=info,4=detailed");
            System.out.println("  -h               Prints this message");
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            boolean bl = true;
            String string = "bucket";
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            int n = 0;
            int n2 = 0;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            Shader shader = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = -5;
            int n7 = -5;
            int n8 = 0;
            String string4 = null;
            String string5 = null;
            boolean bl7 = false;
            String string6 = null;
            boolean bl8 = false;
            boolean bl9 = false;
            int n9 = 1;
            int n10 = 1;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-o")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    string2 = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-nogui")) {
                    bl = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-ipr")) {
                    string = "ipr";
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-threads")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    n2 = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-lopri")) {
                    bl3 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-hipri")) {
                    bl3 = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-sampler")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    string = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-smallmesh")) {
                    TriangleMesh.setSmallTriangles(true);
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-dumpkd")) {
                    KDTree.setDumpMode(true, "kdtree");
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-buildonly")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-showaa")) {
                    bl4 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-nogi")) {
                    bl5 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-nocaustics")) {
                    bl6 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-pathgi")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    n3 = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-quick_ambocc")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    float f = Float.parseFloat(stringArray[n + 1]);
                    shader = new AmbientOcclusionShader(Color.WHITE, f);
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-quick_uvs")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new UVShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-quick_normals")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new NormalShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-quick_id")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new IDShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-quick_prims")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new PrimIDShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-quick_gray")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new QuickGrayShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-quick_wire")) {
                    if (n > stringArray.length - 1) {
                        SunflowGUI.usage(false);
                    }
                    shader = new WireframeShader();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-resolution")) {
                    if (n > stringArray.length - 3) {
                        SunflowGUI.usage(false);
                    }
                    n4 = Integer.parseInt(stringArray[n + 1]);
                    n5 = Integer.parseInt(stringArray[n + 2]);
                    n += 3;
                    continue;
                }
                if (stringArray[n].equals("-aa")) {
                    if (n > stringArray.length - 3) {
                        SunflowGUI.usage(false);
                    }
                    n6 = Integer.parseInt(stringArray[n + 1]);
                    n7 = Integer.parseInt(stringArray[n + 2]);
                    n += 3;
                    continue;
                }
                if (stringArray[n].equals("-bucket")) {
                    if (n > stringArray.length - 3) {
                        SunflowGUI.usage(false);
                    }
                    n8 = Integer.parseInt(stringArray[n + 1]);
                    string4 = stringArray[n + 2];
                    n += 3;
                    continue;
                }
                if (stringArray[n].equals("-bake")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    string5 = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-bakedir")) {
                    String string7;
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    if ((string7 = stringArray[n + 1]).equals("view")) {
                        bl7 = true;
                    } else if (string7.equals("ortho")) {
                        bl7 = false;
                    } else {
                        SunflowGUI.usage(false);
                    }
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-filter")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    string6 = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-bench")) {
                    bl8 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-rtbench")) {
                    bl9 = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-frame")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    n9 = n10 = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-anim")) {
                    if (n > stringArray.length - 3) {
                        SunflowGUI.usage(false);
                    }
                    n9 = Integer.parseInt(stringArray[n + 1]);
                    n10 = Integer.parseInt(stringArray[n + 2]);
                    n += 3;
                    continue;
                }
                if (stringArray[n].equals("-v")) {
                    if (n > stringArray.length - 2) {
                        SunflowGUI.usage(false);
                    }
                    UI.verbosity(Integer.parseInt(stringArray[n + 1]));
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-h") || stringArray[n].equals("-help")) {
                    SunflowGUI.usage(true);
                    continue;
                }
                if (string3 != null) {
                    SunflowGUI.usage(false);
                }
                string3 = stringArray[n];
                ++n;
            }
            if (bl8) {
                SunflowAPI.runSystemCheck();
                new Benchmark().execute();
                return;
            }
            if (bl9) {
                SunflowAPI.runSystemCheck();
                new RealtimeBenchmark(bl, n2);
                return;
            }
            if (string3 == null) {
                SunflowGUI.usage(false);
            }
            SunflowAPI.runSystemCheck();
            if (n9 < n10 && bl) {
                UI.printWarning(UI.Module.GUI, "Animations should not be rendered without -nogui - forcing GUI off anyway", new Object[0]);
                bl = false;
            }
            if (n9 < n10 && string2 == null) {
                string2 = "output.#.png";
                UI.printWarning(UI.Module.GUI, "Animation output was not specified - defaulting to: \"%s\"", string2);
            }
            for (int i = n9; i <= n10; ++i) {
                Display display;
                String string8;
                SunflowAPI sunflowAPI = SunflowAPI.create(string3, i);
                if (sunflowAPI == null || bl2) continue;
                if (n4 > 0 && n5 > 0) {
                    sunflowAPI.parameter("resolutionX", n4);
                    sunflowAPI.parameter("resolutionY", n5);
                }
                if (n6 != -5 || n7 != -5) {
                    sunflowAPI.parameter("aa.min", n6);
                    sunflowAPI.parameter("aa.max", n7);
                }
                if (n8 > 0) {
                    sunflowAPI.parameter("bucket.size", n8);
                }
                if (string4 != null) {
                    sunflowAPI.parameter("bucket.order", string4);
                }
                sunflowAPI.parameter("aa.display", bl4);
                sunflowAPI.parameter("threads", n2);
                sunflowAPI.parameter("threads.lowPriority", bl3);
                if (string5 != null) {
                    sunflowAPI.parameter("baking.instance", string5);
                    sunflowAPI.parameter("baking.viewdep", bl7);
                }
                if (string6 != null) {
                    sunflowAPI.parameter("filter", string6);
                }
                if (bl5) {
                    sunflowAPI.parameter("gi.engine", "none");
                } else if (n3 > 0) {
                    sunflowAPI.parameter("gi.engine", "path");
                    sunflowAPI.parameter("gi.path.samples", n3);
                }
                if (bl6) {
                    sunflowAPI.parameter("caustics", "none");
                }
                sunflowAPI.parameter("sampler", string);
                sunflowAPI.options("::options");
                if (shader != null) {
                    sunflowAPI.shader("ambocc", shader);
                    sunflowAPI.shaderOverride("ambocc", true);
                }
                String string9 = string8 = string2 != null ? string2.replace("#", String.format("%04d", i)) : null;
                if (bl) {
                    display = new FrameDisplay(string8);
                } else if (string8 != null && string8.endsWith(".exr")) {
                    try {
                        display = new OpenExrDisplay(string8, "zip", "float");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                } else {
                    display = string8 != null && string8.equals("imgpipe") ? new ImgPipeDisplay() : new FileDisplay(string8);
                }
                sunflowAPI.render("::options", display);
            }
        } else {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            SunflowGUI sunflowGUI = new SunflowGUI();
            sunflowGUI.setVisible(true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (dimension.getWidth() <= 1024.0 || dimension.getHeight() <= 768.0) {
                sunflowGUI.setExtendedState(6);
            }
            sunflowGUI.tileWindowMenuItem.doClick();
            SunflowAPI.runSystemCheck();
        }
    }

    public SunflowGUI() {
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(null);
        this.newFileMenuItemActionPerformed(null);
        UI.set(this);
    }

    private void initGUI() {
        this.setTitle("Sunflow v0.07.2");
        this.setDefaultCloseOperation(3);
        this.desktop = new JDesktopPane();
        this.getContentPane().add((Component)this.desktop, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.getWidth() <= 1024.0 || dimension.getHeight() <= 768.0) {
            this.desktop.setPreferredSize(new Dimension(640, 480));
        } else {
            this.desktop.setPreferredSize(new Dimension(1024, 768));
        }
        this.imagePanelFrame = new JInternalFrame();
        this.desktop.add(this.imagePanelFrame);
        this.jPanel1 = new JPanel();
        LayoutManager layoutManager = new FlowLayout();
        layoutManager.setAlignment(0);
        this.jPanel1.setLayout(layoutManager);
        this.imagePanelFrame.getContentPane().add((Component)this.jPanel1, "North");
        this.renderButton = new JButton();
        this.jPanel1.add(this.renderButton);
        this.renderButton.setText("Render");
        this.renderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.renderMenuItemActionPerformed(actionEvent);
            }
        });
        this.iprButton = new JButton();
        this.jPanel1.add(this.iprButton);
        this.iprButton.setText("IPR");
        this.iprButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.iprMenuItemActionPerformed(actionEvent);
            }
        });
        this.imagePanel = new ImagePanel();
        this.imagePanelFrame.getContentPane().add((Component)this.imagePanel, "Center");
        this.imagePanelFrame.pack();
        this.imagePanelFrame.setResizable(true);
        this.imagePanelFrame.setMaximizable(true);
        this.imagePanelFrame.setVisible(true);
        this.imagePanelFrame.setTitle("Image");
        this.imagePanelFrame.setIconifiable(true);
        this.editorFrame = new JInternalFrame();
        this.desktop.add(this.editorFrame);
        this.editorFrame.setTitle("Script Editor");
        this.editorFrame.setMaximizable(true);
        this.editorFrame.setResizable(true);
        this.editorFrame.setIconifiable(true);
        this.jScrollPane1 = new JScrollPane();
        this.editorFrame.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(360, 280));
        this.editorTextArea = new JTextArea();
        this.jScrollPane1.setViewportView(this.editorTextArea);
        this.editorTextArea.setFont(new Font("Monospaced", 0, 12));
        this.editorTextArea.setTransferHandler(new SceneTransferHandler());
        this.jPanel3 = new JPanel();
        this.editorFrame.getContentPane().add((Component)this.jPanel3, "South");
        layoutManager = new FlowLayout();
        layoutManager.setAlignment(2);
        this.jPanel3.setLayout(layoutManager);
        this.buildButton = new JButton();
        this.jPanel3.add(this.buildButton);
        this.buildButton.setText("Build Scene");
        this.buildButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.buildMenuItemActionPerformed(actionEvent);
            }
        });
        this.editorFrame.pack();
        this.editorFrame.setVisible(true);
        this.consoleFrame = new JInternalFrame();
        this.desktop.add(this.consoleFrame);
        this.consoleFrame.setIconifiable(true);
        this.consoleFrame.setMaximizable(true);
        this.consoleFrame.setResizable(true);
        this.consoleFrame.setTitle("Console");
        this.jScrollPane2 = new JScrollPane();
        this.consoleFrame.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setPreferredSize(new Dimension(360, 100));
        this.consoleTextArea = new JTextArea();
        this.jScrollPane2.setViewportView(this.consoleTextArea);
        this.consoleTextArea.setFont(new Font("Monospaced", 0, 12));
        this.consoleTextArea.setEditable(false);
        this.jPanel4 = new JPanel();
        this.consoleFrame.getContentPane().add((Component)this.jPanel4, "South");
        layoutManager = new BorderLayout();
        this.jPanel4.setLayout(layoutManager);
        this.jPanel6 = new JPanel();
        LayoutManager layoutManager2 = new BorderLayout();
        this.jPanel6.setLayout(layoutManager2);
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.taskProgressBar = new JProgressBar();
        this.jPanel6.add(this.taskProgressBar);
        this.taskProgressBar.setEnabled(false);
        this.taskProgressBar.setString("");
        this.taskProgressBar.setStringPainted(true);
        this.taskProgressBar.setOpaque(false);
        this.jPanel5 = new JPanel();
        layoutManager2 = new FlowLayout();
        ((FlowLayout)layoutManager2).setAlignment(2);
        this.jPanel5.setLayout(layoutManager2);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.taskCancelButton = new JButton();
        this.jPanel5.add(this.taskCancelButton);
        this.taskCancelButton.setText("Cancel");
        this.taskCancelButton.setEnabled(false);
        this.taskCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UI.taskCancel();
            }
        });
        this.clearConsoleButton = new JButton();
        this.jPanel5.add(this.clearConsoleButton);
        this.clearConsoleButton.setText("Clear");
        this.clearConsoleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.clearConsole();
            }
        });
        this.consoleFrame.pack();
        this.consoleFrame.setVisible(true);
        this.jMenuBar1 = new JMenuBar();
        this.setJMenuBar(this.jMenuBar1);
        this.fileMenu = new JMenu();
        this.jMenuBar1.add(this.fileMenu);
        this.fileMenu.setText("File");
        this.newFileMenuItem = new JMenuItem();
        this.fileMenu.add(this.newFileMenuItem);
        this.newFileMenuItem.setText("New");
        this.newFileMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl N"));
        this.newFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.newFileMenuItemActionPerformed(actionEvent);
            }
        });
        this.openFileMenuItem = new JMenuItem();
        this.fileMenu.add(this.openFileMenuItem);
        this.openFileMenuItem.setText("Open ...");
        this.openFileMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl O"));
        this.openFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.openFileMenuItemActionPerformed(actionEvent);
            }
        });
        this.saveMenuItem = new JMenuItem();
        this.fileMenu.add(this.saveMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.saveCurrentFile(SunflowGUI.this.currentFile);
            }
        });
        this.saveAsMenuItem = new JMenuItem();
        this.fileMenu.add(this.saveAsMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.saveAsMenuItemActionPerformed(actionEvent);
            }
        });
        this.jSeparator2 = new JSeparator();
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem = new JMenuItem();
        this.fileMenu.add(this.exitMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.sceneMenu = new JMenu();
        this.jMenuBar1.add(this.sceneMenu);
        this.sceneMenu.setText("Scene");
        this.buildMenuItem = new JMenuItem();
        this.sceneMenu.add(this.buildMenuItem);
        this.buildMenuItem.setText("Build");
        this.buildMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl B"));
        this.buildMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SunflowGUI.this.sceneMenu.isEnabled()) {
                    SunflowGUI.this.buildMenuItemActionPerformed(actionEvent);
                }
            }
        });
        this.autoBuildMenuItem = new JCheckBoxMenuItem();
        this.sceneMenu.add(this.autoBuildMenuItem);
        this.autoBuildMenuItem.setText("Build on open");
        this.autoBuildMenuItem.setSelected(true);
        this.jSeparator3 = new JSeparator();
        this.sceneMenu.add(this.jSeparator3);
        this.renderMenuItem = new JMenuItem();
        this.sceneMenu.add(this.renderMenuItem);
        this.renderMenuItem.setText("Render");
        this.renderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.renderMenuItemActionPerformed(actionEvent);
            }
        });
        this.iprMenuItem = new JMenuItem();
        this.sceneMenu.add(this.iprMenuItem);
        this.iprMenuItem.setText("IPR");
        this.iprMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.iprMenuItemActionPerformed(actionEvent);
            }
        });
        this.clearLogMenuItem = new JCheckBoxMenuItem();
        this.sceneMenu.add(this.clearLogMenuItem);
        this.clearLogMenuItem.setText("Auto Clear Log");
        this.clearLogMenuItem.setToolTipText("Clears the console before building or rendering");
        this.clearLogMenuItem.setSelected(true);
        this.jSeparator4 = new JSeparator();
        this.sceneMenu.add(this.jSeparator4);
        this.textureCacheClearMenuItem = new JMenuItem();
        this.sceneMenu.add(this.textureCacheClearMenuItem);
        this.textureCacheClearMenuItem.setText("Clear Texture Cache");
        this.textureCacheClearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.textureCacheClearMenuItemActionPerformed(actionEvent);
            }
        });
        this.smallTrianglesMenuItem = new JCheckBoxMenuItem();
        this.sceneMenu.add(this.smallTrianglesMenuItem);
        this.smallTrianglesMenuItem.setText("Low Mem Triangles");
        this.smallTrianglesMenuItem.setToolTipText("Load future meshes using a low memory footprint triangle representation");
        this.smallTrianglesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.smallTrianglesMenuItemActionPerformed(actionEvent);
            }
        });
        this.imageMenu = new JMenu();
        this.jMenuBar1.add(this.imageMenu);
        this.imageMenu.setText("Image");
        this.resetZoomMenuItem = new JMenuItem();
        this.imageMenu.add(this.resetZoomMenuItem);
        this.resetZoomMenuItem.setText("Reset Zoom");
        this.resetZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.imagePanel.reset();
            }
        });
        this.fitWindowMenuItem = new JMenuItem();
        this.imageMenu.add(this.fitWindowMenuItem);
        this.fitWindowMenuItem.setText("Fit to Window");
        this.fitWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.imagePanel.fit();
            }
        });
        this.jSeparator1 = new JSeparator();
        this.imageMenu.add(this.jSeparator1);
        this.jMenuItem4 = new JMenuItem();
        this.imageMenu.add(this.jMenuItem4);
        this.jMenuItem4.setText("Save Image ...");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return "Image File";
                    }

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().endsWith(".png") || file.getName().endsWith(".tga");
                    }
                });
                if (jFileChooser.showSaveDialog(SunflowGUI.this) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    SunflowGUI.this.imagePanel.save(string);
                }
            }
        });
        this.windowMenu = new JMenu();
        this.jMenuBar1.add(this.windowMenu);
        this.windowMenu.setText("Window");
        this.imageWindowMenuItem = new JMenuItem();
        this.windowMenu.add(this.imageWindowMenuItem);
        this.imageWindowMenuItem.setText("Image");
        this.imageWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 1"));
        this.imageWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.selectFrame(SunflowGUI.this.imagePanelFrame);
            }
        });
        this.editorWindowMenuItem = new JMenuItem();
        this.windowMenu.add(this.editorWindowMenuItem);
        this.editorWindowMenuItem.setText("Script Editor");
        this.editorWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 2"));
        this.editorWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.selectFrame(SunflowGUI.this.editorFrame);
            }
        });
        this.consoleWindowMenuItem = new JMenuItem();
        this.windowMenu.add(this.consoleWindowMenuItem);
        this.consoleWindowMenuItem.setText("Console");
        this.consoleWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl 3"));
        this.consoleWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.selectFrame(SunflowGUI.this.consoleFrame);
            }
        });
        this.jSeparator5 = new JSeparator();
        this.windowMenu.add(this.jSeparator5);
        this.tileWindowMenuItem = new JMenuItem();
        this.windowMenu.add(this.tileWindowMenuItem);
        this.tileWindowMenuItem.setText("Tile");
        this.tileWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl T"));
        this.tileWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SunflowGUI.this.tileWindowMenuItemActionPerformed(actionEvent);
            }
        });
    }

    private void newFileMenuItemActionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            // empty if block
        }
        String string = "import org.sunflow.core.*;\nimport org.sunflow.core.accel.*;\nimport org.sunflow.core.camera.*;\nimport org.sunflow.core.primitive.*;\nimport org.sunflow.core.shader.*;\nimport org.sunflow.image.Color;\nimport org.sunflow.math.*;\n\npublic void build() {\n  // your code goes here\n\n}\n";
        this.editorTextArea.setText(string);
    }

    private void openFileMenuItemActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Scene File";
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".sc") || file.getName().endsWith(".java");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.openFile(string);
        }
    }

    private void buildMenuItemActionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                SunflowGUI.this.setEnableInterface(false);
                if (SunflowGUI.this.clearLogMenuItem.isSelected()) {
                    SunflowGUI.this.clearConsole();
                }
                Timer timer = new Timer();
                timer.start();
                try {
                    SunflowGUI.this.api = SunflowAPI.compile(SunflowGUI.this.editorTextArea.getText());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    UI.printError(UI.Module.GUI, "Janino library not found. Please check command line.", new Object[0]);
                    SunflowGUI.this.api = null;
                }
                if (SunflowGUI.this.api != null) {
                    try {
                        if (SunflowGUI.this.currentFile != null) {
                            String string = new File(SunflowGUI.this.currentFile).getAbsoluteFile().getParent();
                            SunflowGUI.this.api.addIncludeSearchPath(string);
                            SunflowGUI.this.api.addIncludeSearchPath(string);
                        }
                        SunflowGUI.this.api.build();
                    }
                    catch (Exception exception) {
                        UI.printError(UI.Module.GUI, "Build terminated abnormally: %s", exception.getMessage());
                        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                            UI.printInfo(UI.Module.GUI, "       at %s", stackTraceElement.toString());
                        }
                        exception.printStackTrace();
                    }
                    timer.end();
                    UI.printInfo(UI.Module.GUI, "Build time: %s", timer.toString());
                }
                SunflowGUI.this.setEnableInterface(true);
            }
        }.start();
    }

    private void clearConsole() {
        this.consoleTextArea.setText(null);
    }

    private void println(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SunflowGUI.this.consoleTextArea.append(string + "\n");
            }
        });
    }

    private void setEnableInterface(boolean bl) {
        this.newFileMenuItem.setEnabled(bl);
        this.openFileMenuItem.setEnabled(bl);
        this.saveMenuItem.setEnabled(bl);
        this.saveAsMenuItem.setEnabled(bl);
        this.sceneMenu.setEnabled(bl);
        this.buildButton.setEnabled(bl);
        this.renderButton.setEnabled(bl);
        this.iprButton.setEnabled(bl);
    }

    public void print(UI.Module module, UI.PrintLevel printLevel, String string) {
        if (printLevel == UI.PrintLevel.ERROR) {
            JOptionPane.showMessageDialog(this, string, String.format("Error - %s", module.name()), 0);
        }
        this.println(UI.formatOutput(module, printLevel, string));
    }

    public void taskStart(String string, int n, int n2) {
        this.currentTask = string;
        this.currentTaskLastP = -1;
        final int n3 = n;
        final int n4 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SunflowGUI.this.taskProgressBar.setEnabled(true);
                SunflowGUI.this.taskCancelButton.setEnabled(true);
                SunflowGUI.this.taskProgressBar.setMinimum(n3);
                SunflowGUI.this.taskProgressBar.setMaximum(n4);
                SunflowGUI.this.taskProgressBar.setValue(n3);
                SunflowGUI.this.taskProgressBar.setString(SunflowGUI.this.currentTask);
            }
        });
    }

    public void taskUpdate(int n) {
        final int n2 = n;
        final String string = this.currentTask;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SunflowGUI.this.taskProgressBar.setValue(n2);
                int n = (int)(100.0 * SunflowGUI.this.taskProgressBar.getPercentComplete());
                if (n > SunflowGUI.this.currentTaskLastP) {
                    SunflowGUI.this.taskProgressBar.setString(string + " [" + n + "%]");
                    SunflowGUI.this.currentTaskLastP = n;
                }
            }
        });
    }

    public void taskStop() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SunflowGUI.this.taskProgressBar.setValue(SunflowGUI.this.taskProgressBar.getMinimum());
                SunflowGUI.this.taskProgressBar.setString("");
                SunflowGUI.this.taskProgressBar.setEnabled(false);
                SunflowGUI.this.taskCancelButton.setEnabled(false);
            }
        });
    }

    private void renderMenuItemActionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                SunflowGUI.this.setEnableInterface(false);
                if (SunflowGUI.this.clearLogMenuItem.isSelected()) {
                    SunflowGUI.this.clearConsole();
                }
                if (SunflowGUI.this.api != null) {
                    SunflowGUI.this.api.parameter("sampler", "bucket");
                    SunflowGUI.this.api.options("::options");
                    SunflowGUI.this.api.render("::options", SunflowGUI.this.imagePanel);
                } else {
                    UI.printError(UI.Module.GUI, "Nothing to render!", new Object[0]);
                }
                SunflowGUI.this.setEnableInterface(true);
            }
        }.start();
    }

    private void iprMenuItemActionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                SunflowGUI.this.setEnableInterface(false);
                if (SunflowGUI.this.clearLogMenuItem.isSelected()) {
                    SunflowGUI.this.clearConsole();
                }
                if (SunflowGUI.this.api != null) {
                    SunflowGUI.this.api.parameter("sampler", "ipr");
                    SunflowGUI.this.api.options("::options");
                    SunflowGUI.this.api.render("::options", SunflowGUI.this.imagePanel);
                } else {
                    UI.printError(UI.Module.GUI, "Nothing to IPR!", new Object[0]);
                }
                SunflowGUI.this.setEnableInterface(true);
            }
        }.start();
    }

    private void textureCacheClearMenuItemActionPerformed(ActionEvent actionEvent) {
        TextureCache.flush();
    }

    private void smallTrianglesMenuItemActionPerformed(ActionEvent actionEvent) {
        TriangleMesh.setSmallTriangles(this.smallTrianglesMenuItem.isSelected());
    }

    private void saveAsMenuItemActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Scene File";
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".java");
            }
        });
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file;
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".java")) {
                string = string + ".java";
            }
            if (!(file = new File(string)).exists() || JOptionPane.showConfirmDialog(this, "This file already exists.\nOverwrite?", "Warning", 0) == 0) {
                this.saveCurrentFile(string);
            }
        }
    }

    private void saveCurrentFile(String string) {
        if (string == null) {
            this.saveAsMenuItemActionPerformed(null);
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.editorTextArea.getText());
            fileWriter.close();
            this.currentFile = string;
            UI.printInfo(UI.Module.GUI, "Saved current script to \"%s\"", string);
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.GUI, "Unable to save: \"%s\"", string);
            iOException.printStackTrace();
        }
    }

    private void selectFrame(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setSelected(true);
            jInternalFrame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private void tileWindowMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.imagePanelFrame.isIcon()) {
                this.imagePanelFrame.setIcon(false);
            }
            if (this.editorFrame.isIcon()) {
                this.editorFrame.setIcon(false);
            }
            if (this.consoleFrame.isIcon()) {
                this.consoleFrame.setIcon(false);
            }
            int n = this.desktop.getWidth();
            int n2 = this.desktop.getHeight();
            int n3 = n * 7 / 12;
            int n4 = n - n3;
            int n5 = 2;
            int n6 = n5 + n5;
            this.imagePanelFrame.reshape(n5, n5, n3 - n6, n2 - n6);
            this.editorFrame.reshape(n5 + n3, n5, n4 - n6, n2 / 2 - n6);
            this.consoleFrame.reshape(n5 + n3, n5 + n2 / 2, n4 - n6, n2 / 2 - n6);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    private void openFile(String string) {
        if (string.endsWith(".java")) {
            String string2 = "";
            try {
                String string3;
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    string2 = string2 + string3;
                    string2 = string2 + "\n";
                }
                fileReader.close();
                this.editorTextArea.setText(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                UI.printError(UI.Module.GUI, "Unable to load: \"%s\"", string);
                return;
            }
            catch (IOException iOException) {
                UI.printError(UI.Module.GUI, "Unable to load: \"%s\"", string);
                return;
            }
            this.currentFile = string;
            UI.printInfo(UI.Module.GUI, "Loaded script: \"%s\"", string);
        } else if (string.endsWith(".sc")) {
            String string4 = "import org.sunflow.core.*;\nimport org.sunflow.core.accel.*;\nimport org.sunflow.core.camera.*;\nimport org.sunflow.core.primitive.*;\nimport org.sunflow.core.shader.*;\nimport org.sunflow.image.Color;\nimport org.sunflow.math.*;\n\npublic void build() {\n  parse(\"" + string.replace("\\", "\\\\") + "\");\n}\n";
            this.editorTextArea.setText(string4);
            this.currentFile = null;
            UI.printInfo(UI.Module.GUI, "Created template for \"%s\"", string);
        } else {
            UI.printError(UI.Module.GUI, "Unknown file format selected", new Object[0]);
            return;
        }
        this.editorTextArea.setCaretPosition(0);
        if (this.autoBuildMenuItem.isSelected()) {
            this.buildMenuItemActionPerformed(null);
        }
    }

    private class SceneTransferHandler
    extends TransferHandler {
        private SceneTransferHandler() {
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (!SunflowGUI.this.sceneMenu.isEnabled()) {
                return false;
            }
            if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (int i = 0; i < list.size(); ++i) {
                    File file = (File)list.get(i);
                    String string = file.getAbsolutePath();
                    if (!string.endsWith(".sc") && !string.endsWith(".java")) continue;
                    SunflowGUI.this.openFile(string);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }
    }
}

