/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.util;

import java.util.Iterator;

public final class IntStack
implements Iterable<Integer>,
Cloneable {
    private final int[] values;
    private int top;

    public IntStack(int n) {
        this(new int[n], 0);
    }

    private IntStack(int[] nArray, int n) {
        this.values = nArray;
        this.top = n;
    }

    public int capacity() {
        return this.values.length;
    }

    public int size() {
        return this.top;
    }

    public int get(int n) {
        assert (this.inRange(n));
        return this.values[n];
    }

    public void push(int n) {
        assert (this.top < this.values.length);
        this.values[this.top++] = n;
    }

    public int pop() {
        assert (this.top > 0);
        return this.values[--this.top];
    }

    public int peek() {
        return this.values[this.top - 1];
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < IntStack.this.top;
            }

            @Override
            public Integer next() {
                return IntStack.this.values[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean inRange(int n) {
        return 0 <= n && n < this.top;
    }

    public IntStack clone() {
        return new IntStack((int[])this.values.clone(), this.top);
    }
}

