/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.util;

import java.util.BitSet;
import java.util.Iterator;

public class IntSet
implements Iterable<Integer> {
    private final int min;
    private final int max;
    private final BitSet bitSet;
    private int size;

    public IntSet(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.bitSet = new BitSet(n2 - n + 1);
        this.size = 0;
    }

    public void put(int n) {
        assert (this.inRange(n));
        int n2 = this.valueToBitIndex(n);
        if (!this.bitSet.get(n2)) {
            this.bitSet.set(n2);
            ++this.size;
        }
    }

    public boolean contains(int n) {
        assert (this.inRange(n));
        return this.bitSet.get(this.valueToBitIndex(n));
    }

    public void clear() {
        this.bitSet.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void remove(int n) {
        assert (this.inRange(n));
        int n2 = this.valueToBitIndex(n);
        if (this.bitSet.get(n2)) {
            this.bitSet.clear(n2);
            --this.size;
        }
    }

    private boolean inRange(int n) {
        return n >= this.min && n <= this.max;
    }

    private int valueToBitIndex(int n) {
        return n - this.min;
    }

    private int bitIndexToValue(int n) {
        return n + this.min;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntSetIterator();
    }

    private class IntSetIterator
    implements Iterator<Integer> {
        private int bitIndex = -1;
        private int index = 0;

        private IntSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < IntSet.this.size;
        }

        @Override
        public Integer next() {
            ++this.index;
            this.bitIndex = IntSet.this.bitSet.nextSetBit(this.bitIndex + 1);
            return IntSet.this.bitIndexToValue(this.bitIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

