/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.util;

import java.util.Iterator;

public class IntList
implements Iterable<Integer> {
    private final Node head = new Node(0);
    private final Node tail = new Node(0);
    private int size;

    public IntList() {
        this.clear();
    }

    public Node add(int n, int n2) {
        assert (0 <= n && n <= this.size);
        Node node = new Node(n2);
        Node node2 = this.getNode(n);
        Node node3 = node2.next;
        IntList.connect(node2, node);
        IntList.connect(node, node3);
        ++this.size;
        return node;
    }

    private static void connect(Node node, Node node2) {
        node.next = node2;
        node2.prev = node;
    }

    public void clear() {
        IntList.connect(this.head, this.tail);
        this.size = 0;
    }

    public Node get(int n) {
        assert (0 <= n && n < this.size);
        return this.getNode(n + 1);
    }

    private Node getNode(int n) {
        Node node;
        if (n < this.size() / 2) {
            node = this.head;
            while (n > 0) {
                node = node.next;
                --n;
            }
        } else {
            node = this.tail;
            for (n = this.size() + 1 - n; n > 0; --n) {
                node = node.prev;
            }
        }
        return node;
    }

    public void remove(int n) {
        this.remove(this.get(n));
    }

    public void remove(Node node) {
        IntList.connect(node.prev, node.next);
        node.prev = null;
        node.next = null;
        --this.size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntListIterator(this.head.next);
    }

    public final class Node {
        private final int value;
        private Node next;
        private Node prev;

        private Node(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }

    private class IntListIterator
    implements Iterator<Integer> {
        private Node cursor;

        public IntListIterator(Node node) {
            this.cursor = node;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != IntList.this.tail;
        }

        @Override
        public Integer next() {
            Integer n = this.cursor.getValue();
            this.cursor = this.cursor.next;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

