/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.util;

public class IntKeyMap<T> {
    private final int min;
    private final int max;
    private final Object[] values;
    private int size;

    public IntKeyMap(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.values = new Object[n2 - n + 1];
        this.size = 0;
    }

    public void put(int n, T t) {
        assert (this.inRange(n));
        assert (t != null);
        int n2 = this.keyToIndex(n);
        assert (this.values[n2] == null);
        this.values[n2] = t;
        ++this.size;
    }

    public boolean containsKey(int n) {
        assert (this.inRange(n));
        return this.values[this.keyToIndex(n)] != null;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
        this.size = 0;
    }

    public T get(int n) {
        assert (this.inRange(n));
        int n2 = this.keyToIndex(n);
        Object object = this.values[n2];
        if (object == null) {
            throw new IllegalArgumentException("Map does not contain this key");
        }
        return (T)object;
    }

    public int size() {
        return this.size;
    }

    public void remove(int n) {
        assert (this.inRange(n));
        int n2 = this.keyToIndex(n);
        if (this.values[n2] != null) {
            this.values[n2] = null;
            --this.size;
        } else {
            throw new IllegalArgumentException("Map does not contain this key");
        }
    }

    public int getMinimalValue() {
        return this.min;
    }

    public int getMaximalValue() {
        return this.max;
    }

    private boolean inRange(int n) {
        return n >= this.min && n <= this.max;
    }

    private int keyToIndex(int n) {
        return n - this.min;
    }
}

