/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.solver.queue;

import at.tasat.solver.Queue;
import at.tasat.solver.VariableOccurencesList;
import at.tasat.solver.queue.VariableComparator;

public final class DynamicVariableOccurencesQueue
extends Queue {
    private static final int DEFAULT_THREASHOLD = 20;
    private final int threashold;
    private final VariableComparator comparator;
    private int generations;

    public DynamicVariableOccurencesQueue(int n, int n2, VariableOccurencesList variableOccurencesList) {
        super(n2);
        this.threashold = n > 0 ? n : 20;
        this.comparator = new VariableComparator(variableOccurencesList);
        this.generations = 0;
    }

    @Override
    protected int getIndexForEnqueue(int n) {
        return this.size();
    }

    @Override
    protected int getIndexForReenqueue(int n) {
        return 0;
    }

    @Override
    protected void onAdded() {
        super.onAdded();
        this.onChanged();
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        this.onChanged();
    }

    private void onChanged() {
        if (++this.generations >= this.threashold) {
            this.generations = 0;
            this.sort(this.comparator);
            assert (this.comparator.isSorted(this));
        }
    }
}

