/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.solver;

import at.tasat.cnf.Clause;
import at.tasat.cnf.Literal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VariableOccurences
implements Cloneable {
    private final int variableId;
    private HashSet<Clause> positiveOccurences;
    private HashSet<Clause> negativeOccurences;

    public VariableOccurences(int n) {
        this(n, new HashSet<Clause>(), new HashSet<Clause>());
    }

    private VariableOccurences(int n, HashSet<Clause> hashSet, HashSet<Clause> hashSet2) {
        this.variableId = n;
        this.positiveOccurences = hashSet;
        this.negativeOccurences = hashSet2;
    }

    public int getVariableId() {
        return this.variableId;
    }

    public int getNumberOfOccurences() {
        return this.negativeOccurences.size() + this.positiveOccurences.size();
    }

    public boolean getDominantPhase() {
        return this.positiveOccurences.size() >= this.negativeOccurences.size();
    }

    public boolean isPurePositive() {
        return this.negativeOccurences.size() == 0;
    }

    public boolean isPureNegative() {
        return this.positiveOccurences.size() == 0;
    }

    public Iterator<Clause> getPositiveOccurences() {
        return this.positiveOccurences.iterator();
    }

    public Iterator<Clause> getNegativeOccurences() {
        return this.negativeOccurences.iterator();
    }

    public Iterator<Clause> getOccurences(boolean bl) {
        return bl ? this.getPositiveOccurences() : this.getNegativeOccurences();
    }

    public Set<Clause> removeOccurences(boolean bl) {
        HashSet<Clause> hashSet;
        if (bl) {
            hashSet = this.positiveOccurences;
            this.positiveOccurences = new HashSet();
        } else {
            hashSet = this.negativeOccurences;
            this.negativeOccurences = new HashSet();
        }
        return hashSet;
    }

    public void addClauses(Collection<Clause> collection) {
        for (Clause clause : collection) {
            this.addClause(clause);
        }
    }

    public void addClause(Clause clause) {
        int n = clause.getLiteralOfVariable(this.variableId);
        if (n != 0) {
            if (Literal.getPhase(n)) {
                this.positiveOccurences.add(clause);
            } else {
                this.negativeOccurences.add(clause);
            }
        }
    }

    public void removeClauses(Collection<Clause> collection) {
        this.negativeOccurences.removeAll(collection);
        this.positiveOccurences.removeAll(collection);
    }

    public VariableOccurences clone() {
        return new VariableOccurences(this.variableId, (HashSet)this.positiveOccurences.clone(), (HashSet)this.negativeOccurences.clone());
    }
}

