/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.solver;

import java.util.LinkedList;

public final class ThreadManager {
    private LinkedList<ManagedThread> availableThreads = new LinkedList();
    private ManagedThread[] threads;

    public ThreadManager(int n) {
        assert (n >= 0);
        this.threads = new ManagedThread[n];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ManagedThread();
        }
    }

    public void release() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAvailable(ManagedThread managedThread) {
        LinkedList<ManagedThread> linkedList = this.availableThreads;
        synchronized (linkedList) {
            this.availableThreads.addFirst(managedThread);
        }
    }

    private boolean can(int n) {
        return this.availableThreads.size() >= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedThread[] fork(int n) {
        if (this.can(n)) {
            LinkedList<ManagedThread> linkedList = this.availableThreads;
            synchronized (linkedList) {
                boolean bl = this.can(n);
                if (bl) {
                    ManagedThread[] managedThreadArray = new ManagedThread[n];
                    for (int i = 0; i < n; ++i) {
                        managedThreadArray[i] = this.availableThreads.removeLast();
                    }
                    return managedThreadArray;
                }
                return null;
            }
        }
        return null;
    }

    public class ManagedThread {
        private final Object monitor = new Object();
        private volatile Runnable runnable;
        private Thread thread;
        private Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Object object = ManagedThread.this.monitor;
                    synchronized (object) {
                        Thread.interrupted();
                        ManagedThread.this.runnable = null;
                        ManagedThread.this.monitor.notifyAll();
                        ThreadManager.this.addAvailable(ManagedThread.this);
                        while (ManagedThread.this.runnable == null) {
                            try {
                                ManagedThread.this.monitor.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                ManagedThread.this.thread = null;
                                return;
                            }
                        }
                    }
                    ManagedThread.this.runnable.run();
                }
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManagedThread() {
            Object object = this.monitor;
            synchronized (object) {
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                    }
                };
                this.thread = new Thread(this.runner);
                this.thread.start();
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(Runnable runnable) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.thread == null) {
                    throw new IllegalAccessError("Thread already terminated");
                }
                if (this.runnable != null) {
                    throw new IllegalAccessError("A runnable is already running on this managed thread");
                }
                this.runnable = runnable;
                this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            Thread thread;
            Object object = this.monitor;
            synchronized (object) {
                thread = this.thread;
                if (thread == null) {
                    throw new IllegalAccessError("Thread already terminated");
                }
                while (this.runnable != null) {
                    thread.interrupt();
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                thread.interrupt();
            }
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("runnable null");
            }
            Object object = this.monitor;
            synchronized (object) {
                if (this.runnable == runnable) {
                    this.thread.interrupt();
                }
            }
        }
    }
}

