/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.solver;

import at.tasat.assignment.PartialAssignment;
import at.tasat.cnf.Clause;
import at.tasat.cnf.Cnf;
import at.tasat.cnf.Literal;
import at.tasat.solver.Queue;
import at.tasat.solver.QueueFactory;
import at.tasat.solver.SolverConfiguration;
import at.tasat.solver.SolverException;
import at.tasat.solver.ThreadManager;
import at.tasat.solver.VariableOccurences;
import at.tasat.solver.VariableOccurencesList;
import at.tasat.util.IntSet;
import at.tasat.util.IntStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public final class Solver {
    private final SolverConfiguration config;
    private final Cnf cnf;
    private final ThreadManager threadManager;
    private final PartialAssignment assignment;
    private final VariableOccurencesList occurencesList;
    private final Queue variablesToAssign;
    private final Stack<Collection<Clause>> removedClauses;

    public static Solver create(Cnf cnf) {
        return Solver.create(new SolverConfiguration(), cnf);
    }

    public static Solver create(SolverConfiguration solverConfiguration, Cnf cnf) {
        PartialAssignment partialAssignment = new PartialAssignment(cnf.getNumberOfVariables());
        VariableOccurencesList variableOccurencesList = Solver.createOccurencesList(cnf, partialAssignment);
        Queue queue = Solver.createVariablesQueue(solverConfiguration.getQueueFactory(), cnf, partialAssignment, variableOccurencesList);
        Stack<Collection<Clause>> stack = new Stack<Collection<Clause>>();
        return new Solver(solverConfiguration, cnf, new ThreadManager((solverConfiguration.getMaxThreads() - 1) * 2), partialAssignment, variableOccurencesList, queue, stack);
    }

    private Solver(SolverConfiguration solverConfiguration, Cnf cnf, ThreadManager threadManager, PartialAssignment partialAssignment, VariableOccurencesList variableOccurencesList, Queue queue, Stack<Collection<Clause>> stack) {
        this.config = solverConfiguration;
        this.cnf = cnf;
        this.threadManager = threadManager;
        this.assignment = partialAssignment;
        this.occurencesList = variableOccurencesList;
        this.variablesToAssign = queue;
        this.removedClauses = stack;
    }

    public void releaseThreadManager() {
        this.threadManager.release();
    }

    private static VariableOccurencesList createOccurencesList(Cnf cnf, PartialAssignment partialAssignment) {
        VariableOccurencesList variableOccurencesList = new VariableOccurencesList(cnf.getNumberOfVariables());
        for (Clause clause : cnf) {
            for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
                int n = Literal.getVariableId(clause.getLiteral(i));
                VariableOccurences variableOccurences = variableOccurencesList.getOccurences(n);
                if (partialAssignment.isSatisfied(clause)) continue;
                variableOccurences.addClause(clause);
            }
        }
        return variableOccurencesList;
    }

    private static Queue createVariablesQueue(QueueFactory queueFactory, Cnf cnf, PartialAssignment partialAssignment, VariableOccurencesList variableOccurencesList) {
        Queue queue = queueFactory.create(cnf.getNumberOfVariables(), variableOccurencesList);
        for (int i = 1; i <= cnf.getNumberOfVariables(); ++i) {
            if (partialAssignment.isAssigned(i)) continue;
            queue.enqueue(i);
        }
        return queue;
    }

    public boolean solve() throws InterruptedException, SolverException {
        return this.solve(0L, Solver.getMaxNumberOfSteps(this.cnf.getNumberOfVariables()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean solve(long l, long l2) throws InterruptedException, SolverException {
        Thread thread = Thread.currentThread();
        int n = 0;
        boolean bl = false;
        ThreadManager.ManagedThread[] managedThreadArray = null;
        int n2 = 1;
        IntStack intStack = new IntStack(this.cnf.getNumberOfVariables() + 1 - this.assignment.getNumberOfAssignments());
        IntStack intStack2 = new IntStack(this.cnf.getNumberOfVariables() + 1 - this.assignment.getNumberOfAssignments());
        intStack.push(0);
        intStack2.push(0);
        boolean bl2 = false;
        try {
            block16: while (n2 != 0) {
                if (thread.isInterrupted()) {
                    throw new InterruptedException();
                }
                assert (intStack.size() - 1 <= this.cnf.getNumberOfVariables());
                assert (intStack2.size() <= intStack.size());
                assert (this.variablesToAssign.size() <= this.cnf.getNumberOfVariables());
                assert (this.assignment.getNumberOfAssignments() <= this.cnf.getNumberOfVariables());
                assert (l < l2);
                bl2 = false;
                switch (n2) {
                    case 1: {
                        boolean bl3;
                        boolean bl4 = bl3 = !this.propagateUnits();
                        assert (bl3 == this.isAnyClauseUnsatisfied(this.cnf));
                        bl2 = !bl3;
                        n2 = bl3 ? 9 : 2;
                        continue block16;
                    }
                    case 2: {
                        this.assignPureLiterals();
                        bl2 = this.areAllClausesSatisfied();
                        n2 = bl2 ? 0 : 3;
                        continue block16;
                    }
                    case 3: {
                        assert (this.variablesToAssign.size() > 0);
                        n = this.variablesToAssign.peek();
                        managedThreadArray = this.threadManager.fork(2);
                        n2 = managedThreadArray != null ? 11 : 4;
                        continue block16;
                    }
                    case 4: {
                        bl = this.occurencesList.getOccurences(n).getDominantPhase();
                        this.doDecision(n, bl);
                        ++l;
                        intStack.push(5);
                        n2 = 10;
                        continue block16;
                    }
                    case 5: {
                        this.undoDecision(n);
                        n2 = 6;
                        continue block16;
                    }
                    case 6: {
                        bl = !bl;
                        this.doDecision(n, bl);
                        ++l;
                        intStack.push(7);
                        n2 = 10;
                        continue block16;
                    }
                    case 7: {
                        this.undoDecision(n);
                        n2 = 8;
                        continue block16;
                    }
                    case 8: {
                        bl2 = false;
                        n2 = 9;
                        continue block16;
                    }
                    case 9: {
                        int n3 = intStack2.pop();
                        n = Literal.getVariableId(n3);
                        bl = Literal.getPhase(n3);
                        n2 = intStack.pop();
                        continue block16;
                    }
                    case 10: {
                        intStack2.push(Literal.toLiteral(n, bl));
                        n2 = 1;
                        continue block16;
                    }
                    case 11: {
                        bl2 = this.forkAndSolve(managedThreadArray, n, l, l2);
                        n2 = bl2 ? 0 : 9;
                        continue block16;
                    }
                }
                assert (false);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw interruptedException;
        }
        catch (Throwable throwable) {
            throw new SolverException(throwable, n2, intStack);
        }
        assert (bl2 == this.areAllClausesSatisfied());
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forkAndSolve(ThreadManager.ManagedThread[] managedThreadArray, int n, long l, long l2) throws InterruptedException {
        Object object = new Object();
        MyRunnable myRunnable = new MyRunnable(object, this, n, true, l, l2);
        MyRunnable myRunnable2 = new MyRunnable(object, this, n, false, l, l2);
        ThreadManager.ManagedThread managedThread = managedThreadArray[0];
        ThreadManager.ManagedThread managedThread2 = managedThreadArray[1];
        boolean bl = false;
        try {
            Object object2 = object;
            synchronized (object2) {
                managedThread.start(myRunnable);
                managedThread2.start(myRunnable2);
                while (!(bl || myRunnable.isFinished() && myRunnable2.isFinished())) {
                    object.wait();
                    if (myRunnable.hasFailed()) {
                        throw new RuntimeException(myRunnable.getException());
                    }
                    if (myRunnable2.hasFailed()) {
                        throw new RuntimeException(myRunnable2.getException());
                    }
                    bl = myRunnable.getResult() || myRunnable2.getResult();
                }
            }
            if (bl) {
                object2 = (myRunnable.getResult() ? myRunnable : myRunnable2).solver.getAssignment();
                ((PartialAssignment)object2).copyTo(this.assignment);
            }
        }
        finally {
            managedThread.interrupt(myRunnable);
            managedThread2.interrupt(myRunnable2);
        }
        return bl;
    }

    private boolean propagateUnits() {
        HashSet<Clause> hashSet = new HashSet<Clause>();
        IntSet intSet = this.getUnitLiterals(this.cnf);
        while (intSet.size() > 0) {
            hashSet.clear();
            for (int n : intSet) {
                int n2 = Literal.getVariableId(n);
                if (this.assignment.isAssigned(n2)) {
                    assert (!this.assignment.getAssignmentOfVariable(n2).isTrue(n));
                    return false;
                }
                boolean bl = Literal.getPhase(n);
                VariableOccurences variableOccurences = this.occurencesList.getOccurences(n2);
                this.makeAssignment(n2, bl, false);
                Iterator<Clause> iterator = variableOccurences.getOccurences(!bl);
                while (iterator.hasNext()) {
                    Clause clause = iterator.next();
                    if (this.assignment.isUnsatisfied(clause)) {
                        return false;
                    }
                    if (this.assignment.isSatisfied(clause)) continue;
                    hashSet.add(clause);
                }
            }
            intSet = this.getUnitLiterals(hashSet);
        }
        return true;
    }

    private IntSet getUnitLiterals(Cnf cnf) {
        IntSet intSet = new IntSet(-this.cnf.getNumberOfVariables(), this.cnf.getNumberOfVariables());
        for (Clause clause : cnf) {
            int n = this.assignment.getUnitVariableId(clause);
            if (n == 0) continue;
            int n2 = clause.getLiteralOfVariable(n);
            intSet.put(n2);
        }
        return intSet;
    }

    private IntSet getUnitLiterals(HashSet<Clause> hashSet) {
        IntSet intSet = new IntSet(-this.cnf.getNumberOfVariables(), this.cnf.getNumberOfVariables());
        for (Clause clause : hashSet) {
            int n = this.assignment.getUnitVariableId(clause);
            if (n == 0) continue;
            int n2 = clause.getLiteralOfVariable(n);
            intSet.put(n2);
        }
        return intSet;
    }

    private boolean isAnyClauseUnsatisfied(Iterable<Clause> iterable) {
        for (Clause clause : iterable) {
            if (!this.assignment.isUnsatisfied(clause)) continue;
            return true;
        }
        return false;
    }

    private void assignPureLiterals() {
        for (int i = 1; i <= this.cnf.getNumberOfVariables(); ++i) {
            if (this.assignment.isAssigned(i)) continue;
            VariableOccurences variableOccurences = this.occurencesList.getOccurences(i);
            if (variableOccurences.isPurePositive()) {
                this.makeAssignment(i, true, false);
                continue;
            }
            if (!variableOccurences.isPureNegative()) continue;
            this.makeAssignment(i, false, false);
        }
    }

    private boolean areAllClausesSatisfied() {
        for (Clause clause : this.cnf) {
            if (this.assignment.isSatisfied(clause)) continue;
            return false;
        }
        return true;
    }

    private void doDecision(int n, boolean bl) {
        this.makeAssignment(n, bl, true);
    }

    private void undoDecision(int n) {
        int n2 = 0;
        int n3 = this.assignment.getNumberOfCurrentDecisionAssignments();
        for (int i = 0; i < n3; ++i) {
            n2 = this.assignment.popAssignment();
            assert (!this.variablesToAssign.contains(n2));
            this.variablesToAssign.reenqueue(n2);
            VariableOccurences variableOccurences = this.occurencesList.getOccurences(n2);
            variableOccurences.addClauses(this.removedClauses.pop());
        }
        assert (n2 == n);
    }

    private void makeAssignment(int n, boolean bl, boolean bl2) {
        assert (this.variablesToAssign.contains(n));
        this.variablesToAssign.remove(n);
        this.assignment.pushAssignment(n, bl, bl2);
        VariableOccurences variableOccurences = this.occurencesList.getOccurences(n);
        Set<Clause> set = variableOccurences.removeOccurences(bl);
        assert (this.allSatisfied(set));
        this.removedClauses.push(set);
    }

    private boolean allSatisfied(Set<Clause> set) {
        for (Clause clause : set) {
            if (this.assignment.isSatisfied(clause)) continue;
            return false;
        }
        return true;
    }

    private static long getMaxNumberOfSteps(int n) {
        return (long)Math.pow(2.0, n + 1) - 2L;
    }

    public PartialAssignment getAssignment() {
        return this.assignment;
    }

    public String toString() {
        return this.assignment.toString();
    }

    private static class MyRunnable
    implements Runnable {
        private final Object monitor;
        private final Solver solver;
        private final long nSteps;
        private final long nMaxSteps;
        private volatile Boolean sat;
        private volatile SolverException exception;

        public MyRunnable(Object object, Solver solver, int n, boolean bl, long l, long l2) {
            PartialAssignment partialAssignment = solver.assignment.clone();
            VariableOccurencesList variableOccurencesList = solver.occurencesList.clone();
            Queue queue = solver.config.getQueueFactory().clone(solver.variablesToAssign, variableOccurencesList);
            Stack stack = new Stack();
            this.monitor = object;
            this.solver = new Solver(solver.config, solver.cnf, solver.threadManager, partialAssignment, variableOccurencesList, queue, stack);
            this.solver.doDecision(n, bl);
            this.nSteps = l + 1L;
            this.nMaxSteps = l2;
            this.sat = null;
            this.exception = null;
        }

        public boolean isFinished() {
            return this.sat != null || this.exception != null;
        }

        public boolean hasFailed() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean getResult() {
            return this.sat != null ? this.sat : false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.sat = this.solver.solve(this.nSteps, this.nMaxSteps);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.sat = null;
            }
            catch (SolverException solverException) {
                this.exception = solverException;
            }
            finally {
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                }
            }
        }
    }
}

