/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.solver;

import at.tasat.util.IntKeyMap;
import at.tasat.util.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class Queue
implements Iterable<Integer>,
Cloneable {
    private final IntList queue = new IntList();
    private final IntKeyMap<IntList.Node> nodes;

    public Queue(int n) {
        this.nodes = new IntKeyMap(1, n);
    }

    public final int size() {
        return this.nodes.size();
    }

    public final boolean contains(int n) {
        return this.nodes.containsKey(n);
    }

    public final int peek() {
        assert (this.size() > 0);
        return this.queue.get(0).getValue();
    }

    public final Integer dequeue() {
        assert (this.size() > 0);
        int n = this.peek();
        this.nodes.remove(n);
        this.queue.remove(0);
        return n;
    }

    public final void enqueue(int n) {
        this.insert(this.getIndexForEnqueue(n), n, true);
    }

    protected abstract int getIndexForEnqueue(int var1);

    public final void reenqueue(int n) {
        this.insert(this.getIndexForReenqueue(n), n, true);
    }

    protected abstract int getIndexForReenqueue(int var1);

    private void insert(int n, int n2, boolean bl) {
        assert (!this.contains(n2));
        IntList.Node node = this.queue.add(n, n2);
        this.nodes.put(n2, node);
        if (bl) {
            this.onAdded();
        }
    }

    protected void onAdded() {
    }

    public final void remove(int n) {
        assert (this.contains(n));
        IntList.Node node = this.nodes.get(n);
        this.queue.remove(node);
        this.nodes.remove(n);
        this.onRemoved();
    }

    protected void onRemoved() {
    }

    protected void sort(Comparator<Integer> comparator) {
        Integer[] integerArray = this.toArray();
        Arrays.sort(integerArray, comparator);
        this.queue.clear();
        this.nodes.clear();
        for (int i = 0; i < integerArray.length; ++i) {
            this.insert(i, integerArray[i], false);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.queue.iterator();
    }

    public Integer[] toArray() {
        Integer[] integerArray = new Integer[this.size()];
        Iterator<Integer> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            integerArray[n++] = iterator.next();
        }
        return integerArray;
    }

    public void copy(Queue queue) {
        assert (queue.size() == 0);
        int n = 0;
        for (Integer n2 : this) {
            queue.insert(n++, n2, false);
        }
    }

    public int getNumVariables() {
        return this.nodes.getMaximalValue();
    }

    public String toString() {
        return Arrays.toString((Object[])this.toArray());
    }
}

