/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.parser;

import at.tasat.cnf.Clause;
import at.tasat.cnf.Cnf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DimacsParser {
    public static Cnf parse(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null && string.startsWith("c")) {
            string = bufferedReader.readLine();
        }
        String[] stringArray = string.split(" ");
        if (stringArray.length != 4) {
            throw new IOException("Header must contain 4 tokens");
        }
        if (!stringArray[0].equals("p")) {
            throw new IOException("Header must start with 'p'");
        }
        if (!stringArray[1].toLowerCase().equals("cnf")) {
            throw new IOException("Only cnf-format supported");
        }
        int n = Integer.parseInt(stringArray[3]);
        int n2 = 0;
        Clause[] clauseArray = new Clause[n];
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.charAt(0) != 'c') {
                if (n2 >= n) {
                    throw new IOException("Found more clauses than stated in the header");
                }
                clauseArray[n2] = DimacsParser.ReadClause(string2.split(" "), n2);
                ++n2;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return new Cnf(clauseArray);
    }

    private static Clause ReadClause(String[] stringArray, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] objectArray = stringArray;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = objectArray[i];
            String string2 = string.trim();
            if (string2.length() <= 0) continue;
            int n3 = Integer.parseInt(string2);
            if (n3 == 0) break;
            arrayList.add(Integer.parseInt(string2));
        }
        int[] nArray = new int[arrayList.size()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (Integer)arrayList.get(n2);
        }
        return new Clause(n, nArray);
    }
}

