/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.io;

import at.tasat.assignment.Assignment;
import at.tasat.cnf.Literal;
import java.util.Arrays;
import java.util.Comparator;

public final class OutputFormatter {
    public static String getResultString(boolean bl, Assignment[] assignmentArray) {
        if (bl) {
            Arrays.sort(assignmentArray, new AssignmentComparator());
            StringBuilder stringBuilder = new StringBuilder("s SATISFIABLE");
            stringBuilder.append('\n');
            stringBuilder.append('v');
            for (Assignment assignment : assignmentArray) {
                stringBuilder.append(' ');
                stringBuilder.append(Literal.toLiteral(assignment.getVariableId(), assignment.getPhase()));
            }
            return stringBuilder.toString().trim();
        }
        return "s UNSATISFIABLE";
    }

    public static String getCommentString(String string) {
        return OutputFormatter.getString('c', string);
    }

    public static String getErrorString(Throwable throwable) {
        return OutputFormatter.getErrorString(OutputFormatter.toString(throwable));
    }

    private static String toString(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stringBuilder.append('\n');
            stringBuilder.append(stackTraceElement.toString());
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuilder.append('\n');
            stringBuilder.append(OutputFormatter.toString(throwable2));
        }
        return stringBuilder.toString();
    }

    public static String getErrorString(String string) {
        return OutputFormatter.getString('e', string);
    }

    private static String getString(char c, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\n")) {
            stringBuilder.append(c);
            stringBuilder.append(' ');
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }

    private OutputFormatter() {
    }

    private static final class AssignmentComparator
    implements Comparator<Assignment> {
        private AssignmentComparator() {
        }

        @Override
        public int compare(Assignment assignment, Assignment assignment2) {
            return Integer.compare(assignment.getVariableId(), assignment2.getVariableId());
        }
    }
}

