/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.cnf;

import at.tasat.cnf.Clause;
import at.tasat.cnf.Literal;
import at.tasat.util.ArrayIterator;
import java.util.BitSet;
import java.util.Iterator;

public final class Cnf
implements Iterable<Clause> {
    private final Clause[] clauses;
    private final int numVariables;

    public Cnf(Clause[] clauseArray) {
        this.clauses = (Clause[])clauseArray.clone();
        BitSet bitSet = new BitSet();
        int n = 0;
        for (Clause clause : this.clauses) {
            for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
                int n2 = Literal.getVariableId(clause.getLiteral(i));
                if (n2 > n) {
                    n = n2;
                }
                bitSet.set(n2);
            }
        }
        this.numVariables = n;
        for (int i = 1; i <= this.numVariables; ++i) {
            if (bitSet.get(i)) continue;
            throw new IllegalArgumentException("Not all variables used");
        }
    }

    public int getNumberOfVariables() {
        return this.numVariables;
    }

    public int getNumberOfClauses() {
        return this.clauses.length;
    }

    public Clause getClause(int n) {
        return this.clauses[n];
    }

    @Override
    public Iterator<Clause> iterator() {
        return new ArrayIterator<Clause>(this.clauses);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Clause clause : this.clauses) {
            stringBuilder.append(clause);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }
}

