/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.cnf;

import at.tasat.cnf.Literal;
import java.util.HashSet;

public final class Clause {
    private final int id;
    private final int[] literals;

    public Clause(int n, int ... nArray) {
        this.id = n;
        this.literals = (int[])nArray.clone();
        assert (this.isSane());
    }

    private boolean isSane() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : this.literals) {
            if (Literal.isLiteral(n) && hashSet.add(n)) continue;
            return false;
        }
        return true;
    }

    public int getId() {
        return this.id;
    }

    public int getNumberOfLiterals() {
        return this.literals.length;
    }

    public int getLiteral(int n) {
        return this.literals[n];
    }

    public int getLiteralOfVariable(int n) {
        assert (Literal.isVariable(n));
        for (int i = 0; i < this.getNumberOfLiterals(); ++i) {
            int n2 = this.getLiteral(i);
            if (Literal.getVariableId(n2) != n) continue;
            return n2;
        }
        return 0;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.literals) {
            if (!Literal.getPhase(n)) {
                stringBuilder.append("!");
            }
            stringBuilder.append(Literal.getVariableId(n));
            stringBuilder.append(' ');
        }
        return this.id + ": (" + stringBuilder.toString().trim() + ')';
    }
}

