/*
 * Decompiled with CFR 0.152.
 */
package at.tasat.assignment;

import at.tasat.assignment.Assignment;
import at.tasat.cnf.Clause;
import at.tasat.cnf.Literal;
import at.tasat.util.IntKeyMap;
import at.tasat.util.IntStack;
import java.util.Stack;

public final class PartialAssignment
implements Cloneable {
    private final int nVariables;
    private int decisionLevel;
    private final IntStack control;
    private final Stack<Assignment> trail;
    private final IntKeyMap<Assignment> assignments;

    public PartialAssignment(int n) {
        this(n, 0, new IntStack(n + 1), new Stack<Assignment>());
        assert (n >= 0);
        this.control.push(0);
    }

    private PartialAssignment(int n, int n2, IntStack intStack, Stack<Assignment> stack) {
        this.nVariables = n;
        this.decisionLevel = n2;
        this.control = intStack;
        this.trail = stack;
        this.assignments = new IntKeyMap(1, n);
        for (Assignment assignment : stack) {
            this.assignments.put(assignment.getVariableId(), assignment);
        }
    }

    private boolean isSane() {
        return this.decisionLevel >= 0 && this.control.size() == this.decisionLevel + 1 && this.trail.size() >= this.control.peek();
    }

    public int getDecisionLevel() {
        return this.decisionLevel;
    }

    public Assignment getDecision(int n) {
        assert (n > 0);
        return (Assignment)this.trail.get(this.control.get(n));
    }

    public int getNumberOfCurrentDecisionAssignments() {
        return this.trail.size() - this.control.peek();
    }

    public boolean isAssigned(int n) {
        return this.assignments.containsKey(n);
    }

    public Assignment getAssignmentOfVariable(int n) {
        return this.assignments.get(n);
    }

    public int getNumberOfAssignments() {
        return this.trail.size();
    }

    public Assignment getAssignment(int n) {
        return (Assignment)this.trail.get(n);
    }

    public Assignment[] getAllAssignments() {
        return this.trail.toArray(new Assignment[this.trail.size()]);
    }

    public boolean isSatisfied(Clause clause) {
        for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
            int n = clause.getLiteral(i);
            int n2 = Literal.getVariableId(n);
            if (!this.assignments.containsKey(n2) || !this.assignments.get(n2).isTrue(n)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnsatisfied(Clause clause) {
        for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
            int n = clause.getLiteral(i);
            int n2 = Literal.getVariableId(n);
            if (this.assignments.containsKey(n2) && !this.assignments.get(n2).isTrue(n)) continue;
            return false;
        }
        return true;
    }

    public int getUnitVariableId(Clause clause) {
        int n = 0;
        for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
            int n2 = clause.getLiteral(i);
            int n3 = Literal.getVariableId(n2);
            if (this.assignments.containsKey(n3)) {
                if (!this.assignments.get(n3).isTrue(n2)) continue;
                return 0;
            }
            if (n > 0) {
                return 0;
            }
            n = n3;
        }
        return n;
    }

    public int getNumberOfUnassignedLiterals(Clause clause) {
        int n = 0;
        for (int i = 0; i < clause.getNumberOfLiterals(); ++i) {
            int n2 = Literal.getVariableId(clause.getLiteral(i));
            if (this.isAssigned(n2)) continue;
            ++n;
        }
        return n;
    }

    public Assignment pushAssignment(int n, boolean bl, boolean bl2) {
        assert (this.isSane());
        Assignment assignment = new Assignment(n, bl);
        assert (!this.assignments.containsKey(assignment.getVariableId()));
        this.assignments.put(n, assignment);
        this.trail.push(assignment);
        if (bl2) {
            this.control.push(this.trail.size() - 1);
            ++this.decisionLevel;
        }
        assert (this.isSane());
        return assignment;
    }

    public int popAssignment() {
        assert (this.isSane());
        Assignment assignment = this.trail.pop();
        this.assignments.remove(assignment.getVariableId());
        if (this.control.size() > 1 && this.control.peek() >= this.trail.size()) {
            this.control.pop();
            --this.decisionLevel;
        }
        assert (this.isSane());
        return assignment.getVariableId();
    }

    public void copyTo(PartialAssignment partialAssignment) {
        assert (this.isSane());
        assert (this.getNumberOfAssignments() > partialAssignment.getNumberOfAssignments());
        int n = 1;
        for (int i = 0; i < this.trail.size(); ++i) {
            boolean bl;
            boolean bl2 = n < this.control.size() ? this.control.get(n) == i : (bl = false);
            if (bl) {
                ++n;
            }
            Assignment assignment = (Assignment)this.trail.get(i);
            if (i >= partialAssignment.getNumberOfAssignments()) {
                partialAssignment.pushAssignment(assignment.getVariableId(), assignment.getPhase(), bl);
                continue;
            }
            assert (assignment.equals(partialAssignment.getAssignment(i)));
        }
        assert (this.isSane());
    }

    public PartialAssignment clone() {
        return new PartialAssignment(this.nVariables, this.decisionLevel, this.control.clone(), (Stack)this.trail.clone());
    }

    public String toString() {
        return "decisionlevel = " + this.decisionLevel + ", control stack = " + this.toStringControl() + ", trail = " + this.toStringTrail();
    }

    private String toStringControl() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int n : this.control) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n);
        }
        return '(' + stringBuilder.toString() + ')';
    }

    private String toStringTrail() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Assignment assignment : this.trail) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(assignment);
        }
        return '(' + stringBuilder.toString() + ')';
    }
}

