/*
 * Decompiled with CFR 0.152.
 */
package at.tasat;

import at.tasat.Configuration;
import at.tasat.cnf.Cnf;
import at.tasat.io.OutputFormatter;
import at.tasat.parser.DimacsParser;
import at.tasat.solver.Solver;
import at.tasat.solver.SolverException;
import java.io.PrintStream;

public final class Main {
    public static void main(String[] stringArray) {
        Configuration configuration = Configuration.get(stringArray);
        int n = Main.main(configuration);
        System.exit(n);
    }

    public static int main(Configuration configuration) {
        PrintStream printStream = new PrintStream(configuration.getOut());
        PrintStream printStream2 = new PrintStream(configuration.getErr());
        try {
            if (configuration.isVerboseConfig()) {
                printStream.println(OutputFormatter.getCommentString(configuration.toString()));
            }
            Cnf cnf = DimacsParser.parse(configuration.getIn());
            configuration.getIn().close();
            Solver solver = Solver.create(configuration.getSolverConfig(), cnf);
            long l = System.currentTimeMillis();
            boolean bl = solver.solve();
            long l2 = System.currentTimeMillis() - l;
            solver.releaseThreadManager();
            if (configuration.isVerboseTime()) {
                printStream.println(OutputFormatter.getCommentString(l2 + "[ms]"));
            }
            printStream.println(OutputFormatter.getResultString(bl, solver.getAssignment().getAllAssignments()));
            return 0;
        }
        catch (SolverException solverException) {
            printStream2.println(OutputFormatter.getErrorString(solverException));
            return 1;
        }
        catch (Throwable throwable) {
            printStream2.println(OutputFormatter.getErrorString(throwable));
            return 2;
        }
    }
}

