/*
 * Decompiled with CFR 0.152.
 */
package at.tasat;

import at.tasat.solver.QueueFactory;
import at.tasat.solver.SolverConfiguration;
import at.tasat.solver.queue.DefaultQueueFactory;
import at.tasat.solver.queue.DynamicVariableOccurencesQueueFactory;
import at.tasat.solver.queue.InvertingQueueFactory;
import at.tasat.solver.queue.RandomQueueFactory;
import at.tasat.solver.queue.StaticVariableOccurencesQueueFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public final class Configuration {
    private InputStream in = System.in;
    private OutputStream out = System.out;
    private OutputStream err = System.err;
    private File file = null;
    private boolean isVerboseTime = false;
    private boolean isVerboseConfig = false;
    private Random random = new Random();
    private final SolverConfiguration solverConfig = new SolverConfiguration();

    public static Configuration get(String[] stringArray) {
        Configuration configuration = new Configuration();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() == 0) continue;
            if (string.startsWith("-")) {
                int n = string.indexOf(61);
                String string2 = string.substring(1, n);
                String string3 = string.substring(n + 1);
                if (string2.equals("v") || string2.equals("-verbose")) {
                    String[] stringArray2;
                    for (String string4 : stringArray2 = string3.split(",")) {
                        if (string4.equals("time")) {
                            configuration.setVerboseTime(true);
                            continue;
                        }
                        if (string4.equals("config")) {
                            configuration.setVerboseConfig(true);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown verbose mode: " + string4);
                    }
                    continue;
                }
                if (string2.equals("s") || string2.equals("-seed")) {
                    configuration.setRandom(new Random(Long.valueOf(string3)));
                    continue;
                }
                if (string2.equals("q") || string2.equals("-queue")) {
                    QueueFactory queueFactory;
                    if (string3.equals("default")) {
                        queueFactory = new DefaultQueueFactory();
                    } else if (string3.equals("inverting")) {
                        queueFactory = new InvertingQueueFactory();
                    } else if (string3.equals("random")) {
                        queueFactory = new RandomQueueFactory(configuration.getRandom());
                    } else if (string3.startsWith("dynamic-occurences")) {
                        int n2 = 0;
                        if (string3.contains(":")) {
                            n2 = Integer.valueOf(string3.substring(string3.indexOf(58) + 1));
                        }
                        queueFactory = new DynamicVariableOccurencesQueueFactory(n2);
                    } else if (string3.equals("static-occurences")) {
                        queueFactory = new StaticVariableOccurencesQueueFactory();
                    } else {
                        throw new IllegalArgumentException("Unknown queue: " + string3);
                    }
                    configuration.getSolverConfig().setQueueFactory(queueFactory);
                    continue;
                }
                if (string2.equals("t") || string2.equals("-threads")) {
                    int n3 = Integer.parseInt(string3);
                    if (n3 < 0) {
                        throw new IllegalArgumentException("Number of threads must be at least 1!");
                    }
                    configuration.solverConfig.setMaxThreads(n3);
                    continue;
                }
                throw new IllegalArgumentException("Unknown property name: " + string2);
            }
            configuration.setIn(new File(string));
            break;
        }
        return configuration;
    }

    public InputStream getIn() throws IOException {
        return this.in != null ? this.in : (this.in = new FileInputStream(this.file));
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public boolean isVerboseTime() {
        return this.isVerboseTime;
    }

    public boolean isVerboseConfig() {
        return this.isVerboseConfig;
    }

    public Random getRandom() {
        return this.random;
    }

    public SolverConfiguration getSolverConfig() {
        return this.solverConfig;
    }

    public void setIn(InputStream inputStream) {
        assert (inputStream != null);
        this.in = inputStream;
        this.file = null;
    }

    public void setIn(File file) {
        assert (file != null);
        this.file = file;
        this.in = null;
    }

    public void setOut(OutputStream outputStream) {
        assert (outputStream != null);
        this.out = outputStream;
    }

    public void setErr(OutputStream outputStream) {
        assert (outputStream != null);
        this.err = outputStream;
    }

    public void setVerboseTime(boolean bl) {
        this.isVerboseTime = bl;
    }

    public void setVerboseConfig(boolean bl) {
        this.isVerboseConfig = bl;
    }

    public void setRandom(Random random) {
        assert (random != null);
        this.random = random;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("--verbose=%s,%s ", String.valueOf(this.isVerboseTime ? "time" : ""), String.valueOf(this.isVerboseConfig ? "config" : "")));
        stringBuilder.append(String.format("--queue=%s ", this.solverConfig.getQueueFactory().getName()));
        if (this.file != null) {
            stringBuilder.append(this.file.getAbsolutePath());
        }
        return stringBuilder.toString().trim();
    }
}

