/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.util.BaseFileObject;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Paths;
import com.sun.tools.javac.util.Version;
import com.sun.tools.javac.zip.ZipFileIndex;
import com.sun.tools.javac.zip.ZipFileIndexEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JavacFileManager.java\t1.48 07/05/05")
public class JavacFileManager
implements StandardJavaFileManager {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    public static final String symbolFilePrefix = "META-INF/sym/rt.jar/";
    boolean useZipFileIndex;
    private static int symbolFilePrefixLength = 0;
    private static boolean CHECK_ZIP_TIMESTAMP;
    private static Map<File, Boolean> isDirectory;
    protected Log log;
    private Paths paths;
    private Options options;
    private final File uninited = new File("U N I N I T E D");
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private File classOutDir = this.uninited;
    private File sourceOutDir = this.uninited;
    protected boolean mmappedIO;
    protected boolean ignoreSymbolFile;
    protected Charset charset;
    private static final boolean fileSystemIsCaseSensitive;
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private Map<JavaFileObject, SoftReference<CharBuffer>> contentCache = new HashMap<JavaFileObject, SoftReference<CharBuffer>>();
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    private static JavacOption[] javacFileManagerOptions;

    public static char[] toArray(CharBuffer charBuffer) {
        if (charBuffer.hasArray()) {
            return ((CharBuffer)charBuffer.compact().flip()).array();
        }
        return charBuffer.toString().toCharArray();
    }

    public static void preRegister(final Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make() {
                return new JavacFileManager(context, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean bl, Charset charset) {
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.byteBufferCache = new ByteBufferCache();
        this.charset = charset;
        this.setContext(context);
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        if (this.paths == null) {
            this.paths = Paths.instance(context);
        } else {
            this.paths.setContext(context);
        }
        this.options = Options.instance(context);
        this.useZipFileIndex = System.getProperty("useJavaUtilZip") == null;
        CHECK_ZIP_TIMESTAMP = System.getProperty("checkZipIndexTimestamp") != null;
        this.mmappedIO = this.options.get("mmappedIO") != null;
        this.ignoreSymbolFile = this.options.get("ignore.symbol.file") != null;
    }

    public JavaFileObject getFileForInput(String string) {
        return this.getRegularFile(new File(string));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(file);
    }

    public JavaFileObject getFileForOutput(String string, JavaFileObject.Kind kind, JavaFileObject javaFileObject) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, kind, javaFileObject);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ListBuffer<File> listBuffer = new ListBuffer<File>();
        for (String string : iterable) {
            listBuffer.append(new File(JavacFileManager.nullCheck(string)));
        }
        return this.getJavaFileObjectsFromFiles(listBuffer.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(stringArray)));
    }

    protected JavaFileObject.Kind getKind(String string) {
        if (string.equals(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.equals(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.equals(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static boolean isValidName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String string) {
        if (!JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid class name: " + string);
        }
    }

    private static void validatePackageName(String string) {
        if (string.length() > 0 && !JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid packageName name: " + string);
        }
    }

    public static void testName(String string, boolean bl, boolean bl2) {
        try {
            JavacFileManager.validatePackageName(string);
            if (!bl) {
                throw new AssertionError((Object)("Invalid package name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new AssertionError((Object)("Valid package name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", string);
        }
        try {
            JavacFileManager.validateClassName(string);
            if (!bl2) {
                throw new AssertionError((Object)("Invalid class name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl2) {
                throw new AssertionError((Object)("Valid class name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", string);
        }
    }

    private static void printAscii(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = new String(String.format(null, string, objectArray).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        System.out.println(string2);
    }

    private static String externalizeFileName(CharSequence charSequence) {
        return ((Object)charSequence).toString().replace('.', File.separatorChar);
    }

    private static String externalizeFileName(CharSequence charSequence, JavaFileObject.Kind kind) {
        return JavacFileManager.externalizeFileName(charSequence) + kind.extension;
    }

    private static String baseName(String string) {
        return string.substring(string.lastIndexOf(File.separatorChar) + 1);
    }

    private void listDirectory(File file, String string, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) {
        block21: {
            Object object;
            block20: {
                Archive archive = this.archives.get(file);
                boolean bl2 = false;
                if (CHECK_ZIP_TIMESTAMP) {
                    object = isDirectory.get(file);
                    if (object == null) {
                        bl2 = file.isFile();
                        isDirectory.put(file, bl2);
                    } else {
                        bl2 = file.isFile();
                    }
                } else {
                    bl2 = file.isFile();
                }
                if (archive == null && !bl2) break block20;
                if (archive == null) {
                    try {
                        archive = this.openArchive(file);
                    }
                    catch (IOException iOException) {
                        this.log.error("error.reading.file", file, iOException.getLocalizedMessage());
                        return;
                    }
                }
                if (string.length() != 0) {
                    if (!this.useZipFileIndex) {
                        if (!(string = string.replace('\\', '/')).endsWith("/")) {
                            string = string + "/";
                        }
                    } else {
                        string = File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
                        if (!string.endsWith(File.separator)) {
                            string = string + File.separator;
                        }
                    }
                }
                if ((object = archive.getFiles(string)) != null) {
                    while (!((List)object).isEmpty()) {
                        String string2 = (String)((List)object).head;
                        if (this.isValidFile(string2, set)) {
                            listBuffer.append(archive.getFileObject(string, string2));
                        }
                        object = ((List)object).tail;
                    }
                }
                if (!bl) break block21;
                for (String string3 : archive.getSubdirectories()) {
                    if (!string3.startsWith(string) || string3.equals(string)) continue;
                    this.listDirectory(file, string3, set, false, listBuffer);
                }
                break block21;
            }
            Object object2 = object = string.length() != 0 ? new File(file, string) : file;
            if (!this.caseMapCheck((File)object, string)) {
                return;
            }
            File[] fileArray = ((File)object).listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                String string4 = file2.getName();
                if (file2.isDirectory()) {
                    if (!bl || !SourceVersion.isIdentifier(string4)) continue;
                    this.listDirectory(file, string + File.separator + string4, set, bl, listBuffer);
                    continue;
                }
                if (!this.isValidFile(string4, set)) continue;
                RegularFileObject regularFileObject = new RegularFileObject(string4, new File((File)object, string4));
                listBuffer.append(regularFileObject);
            }
        }
    }

    private boolean isValidFile(String string, Set<JavaFileObject.Kind> set) {
        int n = string.lastIndexOf(".");
        String string2 = n == -1 ? string : string.substring(n);
        JavaFileObject.Kind kind = this.getKind(string2);
        return set.contains((Object)kind);
    }

    private boolean caseMapCheck(File file, String string) {
        String string2;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        char[] cArray = string2.toCharArray();
        char[] cArray2 = string.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == File.separatorChar) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == File.separatorChar) {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    protected Archive openArchive(File object) throws IOException {
        Archive archive = this.archives.get(object);
        if (archive == null) {
            Object object2;
            Object file = object;
            if (!this.ignoreSymbolFile && this.paths.isBootClassPathRtJar((File)object)) {
                object2 = ((File)object).getParentFile().getParentFile();
                if (new File(((File)object2).getName()).equals(new File("jre"))) {
                    object2 = ((File)object2).getParentFile();
                }
                for (String object3 : symbolFileLocation) {
                    object2 = new File((File)object2, object3);
                }
                if (((File)object2).exists()) {
                    object = object2;
                }
            }
            try {
                object2 = null;
                boolean bl = false;
                String string = null;
                if (!this.useZipFileIndex) {
                    object2 = new ZipFile((File)object);
                } else {
                    bl = this.options.get("usezipindex") != null;
                    string = this.options.get("java.io.tmpdir");
                    String string2 = this.options.get("cachezipindexdir");
                    if (string2 != null && string2.length() != 0) {
                        File file2;
                        if (string2.startsWith("\"")) {
                            string2 = string2.endsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.substring(1);
                        }
                        if ((file2 = new File(string2)).exists() && file2.canWrite() && !(string = string2).endsWith("/") && !string.endsWith(File.separator)) {
                            string = string + File.separator;
                        }
                    }
                }
                archive = file == object ? (!this.useZipFileIndex ? new ZipArchive((ZipFile)object2) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex((File)object, 0, bl, string, this.options.get("writezipindexfiles") != null))) : (!this.useZipFileIndex ? new SymbolArchive((File)file, (ZipFile)object2) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex((File)object, symbolFilePrefixLength, bl, string, this.options.get("writezipindexfiles") != null)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                archive = new MissingArchive((File)object);
            }
            catch (IOException iOException) {
                this.log.error("error.reading.file", object, iOException.getLocalizedMessage());
                archive = new MissingArchive((File)object);
            }
            this.archives.put((File)file, archive);
        }
        return archive;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> iterator = this.archives.values().iterator();
        while (iterator.hasNext()) {
            Archive archive = iterator.next();
            iterator.remove();
            try {
                archive.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    protected String getEncodingName() {
        String string = this.options.get(OptionName.ENCODING);
        if (string == null) {
            return this.getDefaultEncodingName();
        }
        return string;
    }

    protected Source getSource() {
        String string = this.options.get(OptionName.SOURCE);
        Source source = null;
        if (string != null) {
            source = Source.lookup(string);
        }
        return source != null ? source : Source.DEFAULT;
    }

    private ByteBuffer makeByteBuffer(InputStream inputStream) throws IOException {
        int n = inputStream.available();
        if (this.mmappedIO && inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            return fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, n);
        }
        if (n < 1024) {
            n = 1024;
        }
        ByteBuffer byteBuffer = this.byteBufferCache.get(n);
        int n2 = 0;
        while (inputStream.available() != 0) {
            int n3;
            if (n2 >= n) {
                byteBuffer = ByteBuffer.allocate(n <<= 1).put((ByteBuffer)byteBuffer.flip());
            }
            if ((n3 = inputStream.read(byteBuffer.array(), n2, n - n2)) < 0) break;
            byteBuffer.position(n2 += n3);
        }
        return (ByteBuffer)byteBuffer.flip();
    }

    private CharsetDecoder getDecoder(String string, boolean bl) {
        Charset charset = this.charset == null ? Charset.forName(string) : this.charset;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CodingErrorAction codingErrorAction = bl ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return charsetDecoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    private CharBuffer decode(ByteBuffer byteBuffer, boolean bl) {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder;
        String string = this.getEncodingName();
        try {
            charsetDecoder = this.getDecoder(string, bl);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            this.log.error("unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.log.error("unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float f = charsetDecoder.averageCharsPerByte() * 0.8f + charsetDecoder.maxCharsPerByte() * 0.2f;
        CharBuffer charBuffer = CharBuffer.allocate(10 + (int)((float)byteBuffer.remaining() * f));
        while (true) {
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            if (coderResult.isUnderflow()) {
                if (charBuffer.limit() == charBuffer.capacity()) {
                    charBuffer = CharBuffer.allocate(charBuffer.capacity() + 1).put(charBuffer);
                    charBuffer.flip();
                }
                return charBuffer;
            }
            if (coderResult.isOverflow()) {
                int n = 10 + charBuffer.capacity() + (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
                charBuffer = CharBuffer.allocate(n).put(charBuffer);
                continue;
            }
            if (!coderResult.isMalformed() && !coderResult.isUnmappable()) break;
            if (!this.getSource().allowEncodingErrors()) {
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(charBuffer.limit()), "illegal.char.for.encoding", this.charset == null ? string : this.charset.name());
            } else {
                this.log.warning(new JCDiagnostic.SimpleDiagnosticPosition(charBuffer.limit()), "illegal.char.for.encoding", this.charset == null ? string : this.charset.name());
            }
            byteBuffer.position(byteBuffer.position() + coderResult.length());
            charBuffer.position(charBuffer.limit());
            charBuffer.limit(charBuffer.capacity());
            charBuffer.put('\ufffd');
        }
        throw new AssertionError(coderResult);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : iterable) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return new URLClassLoader(listBuffer.toArray(new URL[listBuffer.size()]), this.getClass().getClassLoader());
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(set);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return List.nil();
        }
        String string2 = JavacFileManager.externalizeFileName(string);
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (File file : iterable) {
            this.listDirectory(file, string2, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        javaFileObject.getClass();
        location.getClass();
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof RegularFileObject) {
            RegularFileObject regularFileObject = (RegularFileObject)javaFileObject;
            String string = regularFileObject.getPath();
            for (File file : iterable) {
                String string2 = file.getPath();
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                if (!string.regionMatches(true, 0, string2, 0, string2.length()) || !new File(string.substring(0, string2.length())).equals(new File(string2))) continue;
                String string3 = string.substring(string2.length());
                return JavacFileManager.removeExtension(string3).replace(File.separatorChar, '.');
            }
        } else {
            if (javaFileObject instanceof ZipFileObject) {
                ZipFileObject zipFileObject = (ZipFileObject)javaFileObject;
                String string = zipFileObject.getZipEntryName();
                if (string.startsWith(symbolFilePrefix)) {
                    string = string.substring(symbolFilePrefix.length());
                }
                return JavacFileManager.removeExtension(string).replace('/', '.');
            }
            if (javaFileObject instanceof ZipFileIndexFileObject) {
                ZipFileIndexFileObject zipFileIndexFileObject = (ZipFileIndexFileObject)javaFileObject;
                String string = zipFileIndexFileObject.getZipEntryName();
                if (string.startsWith(symbolFilePrefix)) {
                    string = string.substring(symbolFilePrefix.length());
                }
                return JavacFileManager.removeExtension(string).replace(File.separatorChar, '.');
            }
            throw new IllegalArgumentException(javaFileObject.getClass().getName());
        }
        return null;
    }

    private static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacFileManager.nullCheck(fileObject);
        JavacFileManager.nullCheck(fileObject2);
        if (!(fileObject instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject);
        }
        if (!(fileObject2 instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject2);
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        for (JavacOption javacOption : javacFileManagerOptions) {
            if (!javacOption.matches(string)) continue;
            if (javacOption.hasArg() ? iterator.hasNext() && !javacOption.process(this.options, string, iterator.next()) : !javacOption.process(this.options, string)) {
                return true;
            }
            throw new IllegalArgumentException(string);
        }
        return false;
    }

    @Override
    public int isSupportedOption(String string) {
        for (JavacOption javacOption : javacFileManagerOptions) {
            if (!javacOption.matches(string)) continue;
            return javacOption.hasArg() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, JavacFileManager.externalizeFileName(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(URI.create(string2))) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        String string3 = string.length() == 0 ? string2 : new File(JavacFileManager.externalizeFileName(string), string2).getPath();
        return this.getFileForInput(location, string3);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, String string) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        for (File file : iterable) {
            Object object;
            if (file.isDirectory()) {
                object = new File(file, string.replace('/', File.separatorChar));
                if (!((File)object).exists()) continue;
                return new RegularFileObject((File)object);
            }
            object = this.openArchive(file);
            if (!object.contains(string)) continue;
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            return object.getFileObject(string2, string3);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, JavacFileManager.externalizeFileName(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(URI.create(string2))) {
            throw new IllegalArgumentException("relativeName is invalid");
        }
        String string3 = string.length() == 0 ? string2 : new File(JavacFileManager.externalizeFileName(string), string2).getPath();
        return this.getFileForOutput(location, string3, fileObject);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, String string, FileObject fileObject) throws IOException {
        File file;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    file = this.getClassOutDir();
                    break block7;
                } else {
                    void var5_7;
                    Object var5_5 = null;
                    if (fileObject == null) return new RegularFileObject(new File((File)var5_7, JavacFileManager.baseName(string)));
                    if (fileObject instanceof RegularFileObject) {
                        File file2 = ((RegularFileObject)fileObject).f.getParentFile();
                    }
                    return new RegularFileObject(new File((File)var5_7, JavacFileManager.baseName(string)));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                file = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Paths.Path path = this.paths.getPathForLocation(location);
                file = null;
                Iterator iterator = path.iterator();
                if (iterator.hasNext()) {
                    File file3;
                    file = file3 = (File)iterator.next();
                }
            }
        }
        File file4 = file == null ? new File(string) : new File(file, string);
        return new RegularFileObject(file4);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<RegularFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<RegularFileObject>();
        for (File file : iterable) {
            arrayList.add(new RegularFileObject(JavacFileManager.nullCheck(file)));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(fileArray)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        File file;
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        File file2 = file = location.isOutputLocation() ? this.getOutputDirectory(iterable) : null;
        if (location == StandardLocation.CLASS_OUTPUT) {
            this.classOutDir = this.getOutputLocation(file, OptionName.D);
        } else if (location == StandardLocation.SOURCE_OUTPUT) {
            this.sourceOutDir = this.getOutputLocation(file, OptionName.S);
        } else {
            this.paths.setPathForLocation(location, iterable);
        }
    }

    private File getOutputDirectory(Iterable<? extends File> iterable) throws IOException {
        if (iterable == null) {
            return null;
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        File file = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file + ": does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException(file + ": not a directory");
        }
        return file;
    }

    private File getOutputLocation(File file, OptionName optionName) {
        if (file != null) {
            return file;
        }
        String string = this.options.get(optionName);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.getClassOutDir() == null ? null : List.of(this.getClassOutDir());
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return this.getSourceOutDir() == null ? null : List.of(this.getSourceOutDir());
        }
        return this.paths.getPathForLocation(location);
    }

    private File getClassOutDir() {
        if (this.classOutDir == this.uninited) {
            this.classOutDir = this.getOutputLocation(null, OptionName.D);
        }
        return this.classOutDir;
    }

    private File getSourceOutDir() {
        if (this.sourceOutDir == this.uninited) {
            this.sourceOutDir = this.getOutputLocation(null, OptionName.S);
        }
        return this.sourceOutDir;
    }

    protected static boolean isRelativeUri(URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.normalize().getPath();
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c != '.' && c != '/';
    }

    public static String getRelativeName(File file) {
        String string;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(URI.create(string = file.getPath().replace(File.separatorChar, '/')))) {
            return string;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    protected static String getJavacFileName(FileObject fileObject) {
        if (fileObject instanceof BaseFileObject) {
            return ((BaseFileObject)fileObject).getPath();
        }
        URI uRI = fileObject.toUri();
        String string = uRI.getScheme();
        if (string == null || string.equals("file") || string.equals("jar")) {
            return uRI.getPath();
        }
        return uRI.toString();
    }

    protected static String getJavacBaseFileName(FileObject fileObject) {
        if (fileObject instanceof BaseFileObject) {
            return ((BaseFileObject)fileObject).getName();
        }
        URI uRI = fileObject.toUri();
        String string = uRI.getScheme();
        if (string == null || string.equals("file") || string.equals("jar")) {
            String string2 = uRI.getPath();
            if (string2 == null) {
                return null;
            }
            if (string != null && string.equals("jar")) {
                string2 = string2.substring(string2.lastIndexOf(33) + 1);
            }
            return string2.substring(string2.lastIndexOf(47) + 1);
        }
        return uRI.toString();
    }

    private static <T> T nullCheck(T t) {
        t.getClass();
        return t;
    }

    private static <T> Iterable<T> nullCheck(Iterable<T> iterable) {
        for (T t : iterable) {
            t.getClass();
        }
        return iterable;
    }

    static {
        try {
            symbolFilePrefixLength = symbolFilePrefix.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        CHECK_ZIP_TIMESTAMP = false;
        isDirectory = new ConcurrentHashMap<File, Boolean>();
        fileSystemIsCaseSensitive = File.separatorChar == '/';
        javacFileManagerOptions = RecognizedOptions.getJavacFileManagerOptions(new RecognizedOptions.GrumpyHelper());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipFileIndexArchive
    implements Archive {
        private final ZipFileIndex zfIndex;
        private JavacFileManager fileManager;

        public ZipFileIndexArchive(JavacFileManager javacFileManager2, ZipFileIndex zipFileIndex) throws IOException {
            this.fileManager = javacFileManager2;
            this.zfIndex = zipFileIndex;
        }

        @Override
        public boolean contains(String string) {
            return this.zfIndex.contains(string);
        }

        @Override
        public List<String> getFiles(String string) {
            return this.zfIndex.getFiles(string.endsWith("/") || string.endsWith("\\") ? string.substring(0, string.length() - 1) : string);
        }

        @Override
        public JavaFileObject getFileObject(String string, String string2) {
            String string3 = string + string2;
            ZipFileIndexEntry zipFileIndexEntry = this.zfIndex.getZipIndexEntry(string3);
            ZipFileIndexFileObject zipFileIndexFileObject = new ZipFileIndexFileObject(this.fileManager, this.zfIndex, zipFileIndexEntry, this.zfIndex.getZipFile().getPath());
            return zipFileIndexFileObject;
        }

        @Override
        public Set<String> getSubdirectories() {
            return this.zfIndex.getAllDirectories();
        }

        @Override
        public void close() throws IOException {
            this.zfIndex.close();
        }
    }

    public class ZipFileIndexFileObject
    extends BaseFileObject {
        private String name;
        ZipFileIndex zfIndex;
        ZipFileIndexEntry entry;
        InputStream inputStream = null;
        String zipName;
        JavacFileManager defFileManager = null;

        public ZipFileIndexFileObject(JavacFileManager javacFileManager2, ZipFileIndex zipFileIndex, ZipFileIndexEntry zipFileIndexEntry, String string) {
            this.name = zipFileIndexEntry.getFileName();
            this.zfIndex = zipFileIndex;
            this.entry = zipFileIndexEntry;
            this.zipName = string;
            this.defFileManager = javacFileManager2;
        }

        public InputStream openInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(this.read());
            }
            return this.inputStream;
        }

        protected CharsetDecoder getDecoder(boolean bl) {
            return JavacFileManager.this.getDecoder(JavacFileManager.this.getEncodingName(), bl);
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getName() {
            return this.name;
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            return this.name.equals(string + kind.extension);
        }

        @Deprecated
        public String getPath() {
            return this.entry.getName() + "(" + this.entry + ")";
        }

        public long getLastModified() {
            return this.entry.getLastModified();
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ZipFileIndexFileObject)) {
                return false;
            }
            ZipFileIndexFileObject zipFileIndexFileObject = (ZipFileIndexFileObject)object;
            return this.entry.equals(zipFileIndexFileObject.entry);
        }

        public int hashCode() {
            return this.zipName.hashCode() + (this.name.hashCode() << 10);
        }

        public String getZipName() {
            return this.zipName;
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        public URI toUri() {
            String string = new File(this.getZipName()).toURI().normalize().getPath();
            String string2 = this.getZipEntryName();
            if (File.separatorChar != '/') {
                string2 = string2.replace(File.separatorChar, '/');
            }
            return URI.create("jar:" + string + "!" + string2);
        }

        private byte[] read() throws IOException {
            if (this.entry == null) {
                this.entry = this.zfIndex.getZipIndexEntry(this.name);
                if (this.entry == null) {
                    throw new FileNotFoundException();
                }
            }
            return this.zfIndex.read(this.entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer;
            SoftReference softReference = (SoftReference)this.defFileManager.contentCache.get(this);
            CharBuffer charBuffer2 = charBuffer = softReference == null ? null : (CharBuffer)softReference.get();
            if (charBuffer == null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.zfIndex.read(this.entry));
                try {
                    ByteBuffer byteBuffer = JavacFileManager.this.makeByteBuffer(byteArrayInputStream);
                    JavaFileObject javaFileObject = JavacFileManager.this.log.useSource(this);
                    try {
                        charBuffer = JavacFileManager.this.decode(byteBuffer, bl);
                        Object var8_7 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                        throw throwable;
                    }
                    JavacFileManager.this.byteBufferCache.put(byteBuffer);
                    if (!bl) {
                        this.defFileManager.contentCache.put(this, new SoftReference<CharBuffer>(charBuffer));
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    ((InputStream)byteArrayInputStream).close();
                    throw throwable;
                }
                ((InputStream)byteArrayInputStream).close();
                {
                }
            }
            return charBuffer;
        }
    }

    public class ZipFileObject
    extends BaseFileObject {
        private String name;
        ZipFile zdir;
        ZipEntry entry;

        public ZipFileObject(String string, ZipFile zipFile, ZipEntry zipEntry) {
            this.name = string;
            this.zdir = zipFile;
            this.entry = zipEntry;
        }

        public InputStream openInputStream() throws IOException {
            return this.zdir.getInputStream(this.entry);
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected CharsetDecoder getDecoder(boolean bl) {
            return JavacFileManager.this.getDecoder(JavacFileManager.this.getEncodingName(), bl);
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getName() {
            return this.name;
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            return this.name.equals(string + kind.extension);
        }

        @Deprecated
        public String getPath() {
            return this.zdir.getName() + "(" + this.entry + ")";
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer;
            SoftReference softReference = (SoftReference)JavacFileManager.this.contentCache.get(this);
            CharBuffer charBuffer2 = charBuffer = softReference == null ? null : (CharBuffer)softReference.get();
            if (charBuffer == null) {
                InputStream inputStream = this.zdir.getInputStream(this.entry);
                try {
                    ByteBuffer byteBuffer = JavacFileManager.this.makeByteBuffer(inputStream);
                    JavaFileObject javaFileObject = JavacFileManager.this.log.useSource(this);
                    try {
                        charBuffer = JavacFileManager.this.decode(byteBuffer, bl);
                        Object var8_7 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                        throw throwable;
                    }
                    JavacFileManager.this.byteBufferCache.put(byteBuffer);
                    if (!bl) {
                        JavacFileManager.this.contentCache.put(this, new SoftReference<CharBuffer>(charBuffer));
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            return charBuffer;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ZipFileObject)) {
                return false;
            }
            ZipFileObject zipFileObject = (ZipFileObject)object;
            return this.zdir.equals(zipFileObject.zdir) || this.name.equals(zipFileObject.name);
        }

        public int hashCode() {
            return this.zdir.hashCode() + this.name.hashCode();
        }

        public String getZipName() {
            return this.zdir.getName();
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        public URI toUri() {
            String string = new File(this.getZipName()).toURI().normalize().getPath();
            String string2 = this.getZipEntryName();
            return URI.create("jar:" + string + "!" + string2);
        }
    }

    public class RegularFileObject
    extends BaseFileObject {
        private boolean hasParents = false;
        private String name;
        final File f;

        public RegularFileObject(File file) {
            this(file.getName(), file);
        }

        public RegularFileObject(String string, File file) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("directories not supported");
            }
            this.name = string;
            this.f = file;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.f);
        }

        protected CharsetDecoder getDecoder(boolean bl) {
            return JavacFileManager.this.getDecoder(JavacFileManager.this.getEncodingName(), bl);
        }

        public OutputStream openOutputStream() throws IOException {
            this.ensureParentDirectoriesExist();
            return new FileOutputStream(this.f);
        }

        public Writer openWriter() throws IOException {
            this.ensureParentDirectoriesExist();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), JavacFileManager.this.getEncodingName());
        }

        private void ensureParentDirectoriesExist() throws IOException {
            if (!this.hasParents) {
                File file = this.f.getParentFile();
                if (!(file == null || file.exists() || file.mkdirs() || file.exists() && file.isDirectory())) {
                    throw new IOException("could not create parent directories");
                }
                this.hasParents = true;
            }
        }

        @Deprecated
        public String getName() {
            return this.name;
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            String string2 = string + kind.extension;
            if (this.name.equals(string2)) {
                return true;
            }
            if (this.name.equalsIgnoreCase(string2)) {
                try {
                    return this.f.getCanonicalFile().getName().equals(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String getPath() {
            return this.f.getPath();
        }

        public long getLastModified() {
            return this.f.lastModified();
        }

        public boolean delete() {
            return this.f.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer;
            SoftReference softReference = (SoftReference)JavacFileManager.this.contentCache.get(this);
            CharBuffer charBuffer2 = charBuffer = softReference == null ? null : (CharBuffer)softReference.get();
            if (charBuffer == null) {
                FileInputStream fileInputStream = new FileInputStream(this.f);
                try {
                    ByteBuffer byteBuffer = JavacFileManager.this.makeByteBuffer(fileInputStream);
                    JavaFileObject javaFileObject = JavacFileManager.this.log.useSource(this);
                    try {
                        charBuffer = JavacFileManager.this.decode(byteBuffer, bl);
                        Object var8_7 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        JavacFileManager.this.log.useSource(javaFileObject);
                        throw throwable;
                    }
                    JavacFileManager.this.byteBufferCache.put(byteBuffer);
                    if (!bl) {
                        JavacFileManager.this.contentCache.put(this, new SoftReference<CharBuffer>(charBuffer));
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                {
                }
            }
            return charBuffer;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RegularFileObject)) {
                return false;
            }
            RegularFileObject regularFileObject = (RegularFileObject)object;
            try {
                return this.f.equals(regularFileObject.f) || this.f.getCanonicalFile().equals(regularFileObject.f.getCanonicalFile());
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public URI toUri() {
            try {
                String string = this.f.getAbsolutePath().replace(File.separatorChar, '/');
                return new URI("file://" + string).normalize();
            }
            catch (URISyntaxException uRISyntaxException) {
                return this.f.toURI();
            }
        }
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int n) {
            if (n < 20480) {
                n = 20480;
            }
            ByteBuffer byteBuffer = this.cached != null && this.cached.capacity() >= n ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(n + n >> 1);
            this.cached = null;
            return byteBuffer;
        }

        void put(ByteBuffer byteBuffer) {
            this.cached = byteBuffer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File file) {
            this.zipFileName = file;
        }

        @Override
        public boolean contains(String string) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(String string, String string2) {
            return null;
        }

        @Override
        public List<String> getFiles(String string) {
            return List.nil();
        }

        @Override
        public Set<String> getSubdirectories() {
            return Collections.emptySet();
        }
    }

    public class SymbolArchive
    extends ZipArchive {
        final File origFile;

        public SymbolArchive(File file, ZipFile zipFile) throws IOException {
            super(zipFile);
            this.origFile = file;
        }

        void addZipEntry(ZipEntry zipEntry) {
            String string = zipEntry.getName();
            if (!string.startsWith(JavacFileManager.symbolFilePrefix)) {
                return;
            }
            string = string.substring(JavacFileManager.symbolFilePrefix.length());
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string3.length() == 0) {
                return;
            }
            List<String> list = (List<String>)this.map.get(string2);
            if (list == null) {
                list = List.nil();
            }
            list = list.prepend(string3);
            this.map.put(string2, list);
        }

        public JavaFileObject getFileObject(String string, String string2) {
            return super.getFileObject(JavacFileManager.symbolFilePrefix + string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipArchive
    implements Archive {
        protected final Map<String, List<String>> map;
        protected final ZipFile zdir;

        public ZipArchive(ZipFile zipFile) throws IOException {
            this.zdir = zipFile;
            this.map = new HashMap<String, List<String>>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry;
                try {
                    zipEntry = enumeration.nextElement();
                }
                catch (InternalError internalError) {
                    IOException iOException = new IOException();
                    iOException.initCause(internalError);
                    throw iOException;
                }
                this.addZipEntry(zipEntry);
            }
        }

        void addZipEntry(ZipEntry zipEntry) {
            String string = zipEntry.getName();
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string3.length() == 0) {
                return;
            }
            List<String> list = this.map.get(string2);
            if (list == null) {
                list = List.nil();
            }
            list = list.prepend(string3);
            this.map.put(string2, list);
        }

        @Override
        public boolean contains(String string) {
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string3.length() == 0) {
                return false;
            }
            List<String> list = this.map.get(string2);
            return list != null && list.contains(string3);
        }

        @Override
        public List<String> getFiles(String string) {
            return this.map.get(string);
        }

        @Override
        public JavaFileObject getFileObject(String string, String string2) {
            ZipEntry zipEntry = this.zdir.getEntry(string + string2);
            return new ZipFileObject(string2, this.zdir, zipEntry);
        }

        @Override
        public Set<String> getSubdirectories() {
            return this.map.keySet();
        }

        @Override
        public void close() throws IOException {
            this.zdir.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(String var1);

        public JavaFileObject getFileObject(String var1, String var2);

        public List<String> getFiles(String var1);

        public Set<String> getSubdirectories();
    }
}

