/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Version;

@Version(value="@(#)Constants.java\t1.7 07/05/05")
public class Constants {
    public static Object decode(Object object, Type type) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            switch (type.tag) {
                case 8: {
                    return n != 0;
                }
                case 2: {
                    return Character.valueOf((char)n);
                }
                case 1: {
                    return (byte)n;
                }
                case 3: {
                    return (short)n;
                }
            }
        }
        return object;
    }

    public static String format(Object object, Type type) {
        object = Constants.decode(object, type);
        switch (type.tag) {
            case 1: {
                return Constants.formatByte((Byte)object);
            }
            case 5: {
                return Constants.formatLong((Long)object);
            }
            case 6: {
                return Constants.formatFloat(((Float)object).floatValue());
            }
            case 7: {
                return Constants.formatDouble((Double)object);
            }
            case 2: {
                return Constants.formatChar(((Character)object).charValue());
            }
        }
        if (object instanceof String) {
            return Constants.formatString((String)object);
        }
        return object + "";
    }

    public static String format(Object object) {
        if (object instanceof Byte) {
            return Constants.formatByte((Byte)object);
        }
        if (object instanceof Long) {
            return Constants.formatLong((Long)object);
        }
        if (object instanceof Float) {
            return Constants.formatFloat(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Constants.formatDouble((Double)object);
        }
        if (object instanceof Character) {
            return Constants.formatChar(((Character)object).charValue());
        }
        if (object instanceof String) {
            return Constants.formatString((String)object);
        }
        return object + "";
    }

    private static String formatByte(byte by) {
        return String.format("0x%02x", by);
    }

    private static String formatLong(long l) {
        return l + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c) + '\'';
    }

    private static String formatString(String string) {
        return '\"' + Convert.quote(string) + '\"';
    }
}

