/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Version;
import java.io.PrintWriter;

@Version(value="@(#)JavacOption.java\t1.7 07/05/05")
public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName optionName) {
            super(optionName, null, null);
        }

        HiddenOption(OptionName optionName, String string) {
            super(optionName, string, null);
        }

        void help(PrintWriter printWriter) {
        }

        void xhelp(PrintWriter printWriter) {
        }

        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    public static class XOption
    extends Option {
        XOption(OptionName optionName, String string, String string2) {
            super(optionName, string, string2);
        }

        XOption(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        void help(PrintWriter printWriter) {
        }

        void xhelp(PrintWriter printWriter) {
            super.help(printWriter);
        }

        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }

    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;

        Option(OptionName optionName, String string, String string2) {
            this.name = optionName;
            this.argsNameKey = string;
            this.descrKey = string2;
            char c = optionName.optionName.charAt(optionName.optionName.length() - 1);
            this.hasSuffix = c == ':' || c == '=';
        }

        Option(OptionName optionName, String string) {
            this(optionName, null, string);
        }

        public String toString() {
            return this.name.optionName;
        }

        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        public boolean matches(String string) {
            return this.hasSuffix ? string.startsWith(this.name.optionName) : string.equals(this.name.optionName);
        }

        void help(PrintWriter printWriter) {
            String string = "  " + this.helpSynopsis();
            printWriter.print(string);
            for (int i = string.length(); i < 29; ++i) {
                printWriter.print(" ");
            }
            Log.printLines(printWriter, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            return (Object)((Object)this.name) + (this.argsNameKey == null ? "" : (this.hasSuffix ? "" : " ") + Main.getLocalizedString(this.argsNameKey, new Object[0]));
        }

        void xhelp(PrintWriter printWriter) {
        }

        public boolean process(Options options, String string, String string2) {
            if (options != null) {
                options.put(string, string2);
            }
            return false;
        }

        public boolean process(Options options, String string) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, string.substring(this.name.optionName.length()));
            }
            return this.process(options, string, string);
        }

        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        public OptionName getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }
}

