/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.dacapo.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public abstract class AbstractBenchmark
extends Benchmark {
    private Properties original;

    public AbstractBenchmark(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    protected Properties overrideProperties(Properties original, String size) throws Exception {
        return original;
    }

    @Override
    public void preIteration(String size) throws Exception {
        super.preIteration(size);
        this.original = System.getProperties();
        System.setProperties(this.overrideProperties(this.original, size));
    }

    @Override
    public void postIteration(String size) throws Exception {
        System.setProperties(this.original);
        super.postIteration(size);
    }

    protected final String getJarClasspath() throws IOException {
        File scratchJarDir = new File(this.scratch, "jar");
        return this.assembleClasspathEntries(scratchJarDir);
    }

    private String assembleClasspathEntries(File scratchJarDir) throws IOException {
        if (this.config.libs == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.config.libs.length; ++i) {
            File jar = new File(scratchJarDir, this.config.libs[i]);
            result.append(jar.getCanonicalPath());
            if (i >= this.config.libs.length - 1) continue;
            result.append(File.pathSeparatorChar);
        }
        return result.toString();
    }

    public static String[] concat(String[] lhs, String[] rhs) {
        String[] result = Arrays.copyOf(lhs, lhs.length + rhs.length);
        System.arraycopy(rhs, 0, result, lhs.length, rhs.length);
        return result;
    }
}

