/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.tmt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class TMT
extends AbstractBenchmark {
    public TMT(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    @Override
    protected Properties overrideProperties(Properties original, String size) throws Exception {
        Properties overridden = new Properties(System.getProperties());
        overridden.setProperty("scalala.library.random.seed", "0");
        return overridden;
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.method = this.getScriptClass("example-2-lda-learn").getMethod("main", String[].class);
    }

    private Class<?> getScriptClass(String script) throws MalformedURLException, ClassNotFoundException {
        URLClassLoader scriptLoader = new URLClassLoader(new URL[]{new File(this.scratch, this.config.name).toURI().toURL()}, this.loader);
        return scriptLoader.loadClass(script);
    }

    @Override
    public void iterate(String size) throws Exception {
        this.performCd(new File(this.scratch, this.config.name).getAbsoluteFile());
        this.method.invoke(null, new Object[]{new String[]{this.config.getArgs(size)[0]}});
    }

    @Override
    public void postIteration(String size) throws Exception {
        TMT.deleteTree(new File(new File(this.scratch, this.config.name), "lda"));
        TMT.deleteFiles(new File(this.scratch, this.config.name), ".*\\.gz");
        super.postIteration(size);
    }

    private void performCd(File workingDirectory) throws Exception {
        Class<?> pipesClass = this.loader.loadClass("scalanlp.pipes.Pipes");
        Class<?> pipesDollarClass = this.loader.loadClass("scalanlp.pipes.Pipes$");
        Object pipesDollar = this.getSingleton(pipesDollarClass);
        Object global = pipesDollarClass.getMethod("global", new Class[0]).invoke(pipesDollar, new Object[0]);
        pipesClass.getMethod("cd", File.class).invoke(global, workingDirectory);
    }

    private Object getSingleton(Class<?> objectClass) throws Exception {
        return objectClass.getField("MODULE$").get(null);
    }
}

