/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.specs;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class Specs
extends AbstractBenchmark {
    private URL[] testClasspath;

    public Specs(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.testClasspath = new URL[]{new File(this.scratch, this.config.name).toURI().toURL()};
    }

    @Override
    public void iterate(String size) throws Exception {
        URLClassLoader testClassLoader = new URLClassLoader(this.testClasspath, this.loader);
        Thread.currentThread().setContextClassLoader(testClassLoader);
        for (String testClassName : this.config.getArgs(size)) {
            this.runTestClass(testClassLoader.loadClass(testClassName));
        }
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    private void runTestClass(Class<?> testClass) throws Exception {
        testClass.getMethod("args_$eq", String[].class).invoke(null, new Object[]{new String[]{"--reject", "slow"}});
        testClass.getMethod("reportSpecs", new Class[0]).invoke(null, new Object[0]);
    }
}

