/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.scalatest;

import java.io.File;
import java.io.IOException;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class ScalaTest
extends AbstractBenchmark {
    private String[] args;
    private boolean preexistingTargetDirectory = true;
    private static final File TARGET_DIRECTORY = new File("target");

    public ScalaTest(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        String[] options = new String[]{"-c" + this.config.getThreadCount(size), "-oW", "-p", new File(this.scratch, this.config.name).getAbsolutePath().replace(" ", "\\ ")};
        this.method = this.loader.loadClass("org.scalatest.tools.Runner").getMethod("run", String[].class);
        this.args = ScalaTest.concat(options, this.intersperseSuiteParameters(this.config.getArgs(size)));
        boolean bl = this.preexistingTargetDirectory = TARGET_DIRECTORY.exists() && TARGET_DIRECTORY.isDirectory();
        if (!this.preexistingTargetDirectory && !TARGET_DIRECTORY.mkdir()) {
            throw new IOException("Couldn't create temporary directory: " + TARGET_DIRECTORY.getCanonicalPath());
        }
    }

    @Override
    public void iterate(String size) throws Exception {
        this.method.invoke(null, new Object[]{this.args});
    }

    private String[] intersperseSuiteParameters(String[] args) {
        String[] runnerArgs = new String[2 * args.length];
        for (int i = 0; i < args.length; ++i) {
            runnerArgs[2 * i] = "-s";
            runnerArgs[2 * i + 1] = args[i];
        }
        return runnerArgs;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (!this.preexistingTargetDirectory) {
            TARGET_DIRECTORY.delete();
        }
    }
}

