/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.scalap;

import java.io.File;
import java.util.Properties;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class Scalap
extends AbstractBenchmark {
    private String[] args;
    private final File nonExistingFile;

    public Scalap(Config config, File scratch) throws Exception {
        super(config, scratch);
        this.nonExistingFile = File.createTempFile(this.config.name, null);
    }

    @Override
    protected Properties overrideProperties(Properties original, String size) throws Exception {
        Properties overridden = new Properties(System.getProperties());
        overridden.setProperty("sun.boot.class.path", this.nonExistingFile.getCanonicalPath());
        overridden.setProperty("java.ext.dirs", this.nonExistingFile.getCanonicalPath());
        return overridden;
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.method = this.loader.loadClass("scala.tools.scalap.Main").getMethod("main", String[].class);
        String[] options = new String[]{"-classpath", this.fileInScratch(this.config.name)};
        this.args = Scalap.concat(options, this.config.getArgs(size));
    }

    @Override
    public void iterate(String size) throws Exception {
        this.method.invoke(null, new Object[]{this.args});
    }
}

