/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.kiama;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class Kiama
extends AbstractBenchmark {
    private String[] args;
    private HashMap<String, Method> methodsForExtension = new HashMap();
    private HashMap<String, String[]> optionsForExtension = new HashMap();
    private static final String ISWIM_FILE_EXTENSION = ".is";
    private static final String OBR_FILE_EXTENSION = ".obr";

    public Kiama(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.methodsForExtension.put(ISWIM_FILE_EXTENSION, this.loader.loadClass("org.kiama.example.iswim.driver.Main").getMethod("main", String[].class));
        this.optionsForExtension.put(ISWIM_FILE_EXTENSION, new String[]{"-e"});
        this.methodsForExtension.put(OBR_FILE_EXTENSION, this.loader.loadClass("org.kiama.example.obr.Main").getMethod("main", String[].class));
        this.args = this.config.preprocessArgs(size, this.scratch);
    }

    @Override
    public void iterate(String size) throws Exception {
        for (String arg : this.args) {
            String extension = arg.substring(arg.lastIndexOf(46));
            this.methodsForExtension.get(extension).invoke(null, new Object[]{this.buildCommandLine(arg)});
        }
    }

    private String[] buildCommandLine(String sourceFile) {
        String extension = sourceFile.substring(sourceFile.lastIndexOf(46));
        String[] options = this.optionsForExtension.containsKey(extension) ? this.optionsForExtension.get(extension) : new String[]{};
        return Kiama.concat(options, new String[]{sourceFile});
    }
}

