/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.apparat;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class Apparat
extends AbstractBenchmark {
    private Method stripperMethod;
    private Method tdsiMethod;
    private Method reducerMethod;
    private Method dumpMethod;
    private String[] args;
    private final File nonExistingFile;

    public Apparat(Config config, File scratch) throws Exception {
        super(config, scratch);
        this.nonExistingFile = File.createTempFile(this.config.name, null, new File(this.scratch, this.config.name));
    }

    @Override
    protected Properties overrideProperties(Properties original, String size) throws Exception {
        Properties overridden = new Properties(System.getProperties());
        overridden = this.addApparatProperties(overridden);
        return overridden;
    }

    private Properties addApparatProperties(Properties properties) {
        properties.setProperty("apparat.threads", "true");
        properties.setProperty("apparat.7z.enabled", "false");
        properties.setProperty("apparat.7z.path", this.nonExistingFile.getAbsolutePath());
        properties.setProperty("apparat.debug", "false");
        properties.setProperty("apparat.quiet", "false");
        return properties;
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.stripperMethod = this.loader.loadClass("apparat.tools.stripper.Stripper").getMethod("main", String[].class);
        this.tdsiMethod = this.loader.loadClass("apparat.tools.tdsi.TurboDieselSportInjection").getMethod("main", String[].class);
        this.reducerMethod = this.loader.loadClass("apparat.tools.reducer.Reducer").getMethod("main", String[].class);
        this.dumpMethod = this.loader.loadClass("apparat.tools.dump.Dump").getMethod("main", String[].class);
        this.args = this.config.preprocessArgs(size, this.scratch);
    }

    @Override
    public void iterate(String size) throws Exception {
        for (String arg : this.args) {
            this.stripperMethod.invoke(null, new Object[]{new String[]{"-i", arg, "-o", arg + ".out"}});
            this.tdsiMethod.invoke(null, new Object[]{new String[]{"-i", arg + ".out"}});
            this.reducerMethod.invoke(null, new Object[]{new String[]{"-i", arg + ".out", "-m", "true", "-s", "true"}});
            this.dumpMethod.invoke(null, new Object[]{new String[]{"-i", arg + ".out", "-o", this.fileInScratch("apparat"), "-swf", "-uml"}});
        }
    }
}

