/*
 * Decompiled with CFR 0.152.
 */
package org.scalabench.benchmarks.actors;

import java.io.File;
import java.util.Properties;
import org.dacapo.parser.Config;
import org.scalabench.dacapo.utils.AbstractBenchmark;

public class Actors
extends AbstractBenchmark {
    private Class<?>[] performanceTestClasses;

    public Actors(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    @Override
    protected Properties overrideProperties(Properties original, String size) throws Exception {
        Properties overridden = new Properties(System.getProperties());
        overridden = this.addTradingSampleProperties(overridden, size);
        overridden = this.addAkkaProperties(overridden);
        overridden = this.addLoggingProperties(overridden);
        return overridden;
    }

    private Properties addTradingSampleProperties(Properties properties, String size) {
        properties.setProperty("benchmark", "true");
        properties.setProperty("minClients", Integer.toString(this.config.getThreadCount(size)));
        properties.setProperty("maxClients", Integer.toString(this.config.getThreadCount(size)));
        properties.setProperty("useTxLogFile", "false");
        properties.setProperty("useDummyOrderbook", "false");
        properties.setProperty("randomSeed", "23");
        properties.setProperty("warmupRepeatFactor", "0");
        properties.setProperty("repeatFactor", this.config.getArgs(size)[0]);
        return properties;
    }

    private Properties addAkkaProperties(Properties properties) {
        properties.setProperty("akka.home", "");
        properties.setProperty("akka.mode", "");
        properties.setProperty("akka.config", "");
        return properties;
    }

    private Properties addLoggingProperties(Properties properties) {
        properties.setProperty("logback.basedir", this.fileInScratch("actors"));
        return properties;
    }

    @Override
    protected void prepare(String size) throws Exception {
        super.prepare(size);
        this.performanceTestClasses = new Class[]{this.loader.loadClass("org.samples.trading.basic.BasicPerformanceTest"), this.loader.loadClass("org.samples.trading.actor.ActorPerformanceTest"), this.loader.loadClass("org.samples.trading.actorbang.ActorBangPerformanceTest"), this.loader.loadClass("org.samples.trading.akka.AkkaPerformanceTest"), this.loader.loadClass("org.samples.trading.akkabang.AkkaBangPerformanceTest"), this.loader.loadClass("org.samples.trading.akkahawt.AkkaHawtPerformanceTest")};
        this.method = this.loader.loadClass("org.samples.trading.common.BenchmarkScenarios").getMethod("complexScenario", Integer.TYPE);
    }

    @Override
    public void iterate(String size) throws Exception {
        for (Class<?> performanceTestClass : this.performanceTestClasses) {
            Object performanceTest = performanceTestClass.newInstance();
            this.runJUnitTest(size, performanceTest);
        }
    }

    private void runJUnitTest(String size, Object performanceTest) throws Exception {
        performanceTest.getClass().getMethod("setUp", new Class[0]).invoke(performanceTest, new Object[0]);
        this.method.invoke(performanceTest, this.config.getThreadCount(size));
        performanceTest.getClass().getMethod("tearDown", new Class[0]).invoke(performanceTest, new Object[0]);
    }

    @Override
    public void preIteration(String size) throws Exception {
        super.preIteration(size);
        this.resetStatSingleton();
    }

    private void resetStatSingleton() throws Exception {
        Class<?> statSingletonClass = this.loader.loadClass("org.samples.trading.common.StatSingleton");
        Class<?> listClass = this.loader.loadClass("scala.collection.immutable.List");
        Object nil = this.getSingleton(this.loader.loadClass("scala.collection.immutable.Nil$"));
        statSingletonClass.getMethod("results_$eq", listClass).invoke(null, nil);
    }

    private Object getSingleton(Class<?> objectClass) throws Exception {
        return objectClass.getField("MODULE$").get(null);
    }
}

