/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Method;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Tradesoap
extends Benchmark {
    private Method initializeMethod;

    public Tradesoap(Config config, File scratch) throws Exception {
        super(config, scratch, false);
        Class<?> clazz = Class.forName("org.dacapo.daytrader.Launcher", true, this.loader);
        this.initializeMethod = clazz.getMethod("initialize", File.class, Integer.TYPE, String.class, Boolean.TYPE);
        this.method = clazz.getMethod("performIteration", new Class[0]);
    }

    protected void prepare() throws Exception {
        Tradesoap.unpackZipFileResource("dat/daytrader.zip", this.scratch);
    }

    protected void prepare(String size) throws Exception {
        String[] args = this.config.preprocessArgs(size, this.scratch);
        String dtSize = "medium";
        if (args.length == 1) {
            dtSize = args[0];
        }
        this.initializeMethod.invoke(null, this.scratch, this.config.getThreadCount(size), dtSize, false);
    }

    public void cleanup() {
        System.out.println("Shutting down Geronimo...");
        if (!Tradesoap.getPreserve()) {
            Tradesoap.deleteTree(new File(this.scratch, "tradesoap"));
            Tradesoap.deleteTree(new File(this.scratch, "geronimo-jetty6-minimal-2.1.4"));
        }
    }

    public void iterate(String size) throws Exception {
        if (Tradesoap.getVerbose()) {
            System.out.println("tradesoap benchmark starting");
        }
        this.method.invoke(null, new Object[0]);
    }
}

