/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Vector;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Batik
extends Benchmark {
    private String[] args;
    private final Constructor<?> constructor;

    public Batik(Config config, File scratch) throws Exception {
        super(config, scratch, false);
        Class<?> clazz = Class.forName("org.apache.batik.apps.rasterizer.Main", true, this.loader);
        this.method = clazz.getMethod("execute", new Class[0]);
        this.constructor = clazz.getConstructor(String[].class);
    }

    protected void prepare(String size) throws Exception {
        super.prepare(size);
        String[] args = this.config.preprocessArgs(size, this.scratch);
        Vector<String> newArgs = new Vector<String>(args.length + 2);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-m") || args[i].equals("-d")) {
                    newArgs.add(args[i]);
                    newArgs.add(args[++i]);
                    continue;
                }
                newArgs.add(args[i]);
                continue;
            }
            newArgs.add(new File(this.scratch, args[i]).getPath());
        }
        String[] newArgStrings = newArgs.toArray(new String[0]);
        if (Batik.getVerbose()) {
            for (int i = 0; i < newArgStrings.length; ++i) {
                System.out.print(newArgStrings[i] + " ");
            }
            System.out.println();
        }
        this.args = newArgStrings;
    }

    public void iterate(String size) throws Exception {
        Object object = this.constructor.newInstance(new Object[]{this.args});
        this.method.invoke(object, new Object[0]);
    }
}

