/*
 * Decompiled with CFR 0.152.
 */
package spec.validity;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import spec.harness.Context;
import spec.harness.StopBenchmarkException;
import spec.validity.DigestDefinition;

public class Digests {
    boolean debug = false;
    PrintStream out;

    public Digests(PrintStream out) {
        this.out = out;
    }

    public String crunch_jars() {
        String prefix = Context.getSpecBasePath() + "/";
        String ret = this.crunch("Jar", prefix, 1);
        return ret;
    }

    public String crunch_resources() {
        String prefix = Context.getSpecBasePath() + "/resources/";
        String ret = this.crunch("Resource", prefix, 5);
        return ret;
    }

    private String crunch(String target, String prefix, int step) {
        DigestDefinition digests = this.createDigester(target);
        Iterator<String> iter = digests.iterator();
        String ret = null;
        int s = 0;
        while (iter.hasNext()) {
            String res = null;
            String current = iter.next();
            String current_name = new String(prefix + current);
            try {
                FileInputStream the_one = new FileInputStream(current_name);
                byte[] expected = digests.getArray(current);
                MessageDigest md = MessageDigest.getInstance("SHA");
                DigestInputStream dis = new DigestInputStream(the_one, md);
                int count = (int)new File(current_name).length();
                for (int i = 0; i < count; ++i) {
                    dis.read();
                }
                byte[] a = md.digest();
                for (int i = 0; i < 10; ++i) {
                    if (this.debug) {
                        System.out.println(", " + a[i]);
                    }
                    if (a[i] == expected[i]) continue;
                    res = "Checksum test failed on " + current;
                }
                if (this.debug) {
                    System.out.println(current + " validity is " + (res == null));
                }
            }
            catch (Exception e) {
                res = "Digests: caught exception " + e.getMessage();
            }
            if (res != null) {
                ret = ret == null ? res : ret + ", " + res;
                this.out.print('!');
            } else if (s % step == 0) {
                this.out.print('.');
            }
            ++s;
        }
        return ret;
    }

    private DigestDefinition createDigester(String type) {
        try {
            Class<?> cls = Class.forName("spec.validity.Expected" + type + "Digests");
            Constructor<?> constr = cls.getConstructor(null);
            DigestDefinition jarDigests = (DigestDefinition)constr.newInstance(null);
            return jarDigests;
        }
        catch (Exception e) {
            throw new StopBenchmarkException("Failed to create checksum digester.", (Throwable)e);
        }
    }
}

