/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.util;

import java.io.IOException;
import java.io.OutputStream;

public final class SequenceInsertingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final byte[] postfix;
    private final byte[] sequence;
    private int position;

    public SequenceInsertingOutputStream(OutputStream outputStream, byte[] byArray, byte[] byArray2) {
        if (outputStream == null || byArray == null || byArray2 == null) {
            throw new NullPointerException();
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Length of prefix must be greater than zero!");
        }
        this.out = outputStream;
        this.postfix = (byte[])byArray.clone();
        this.sequence = (byte[])byArray2.clone();
        this.position = 0;
    }

    @Override
    public void write(int n) throws IOException {
        byte by = (byte)n;
        if (this.postfix[this.position] == by) {
            ++this.position;
            if (this.position == this.postfix.length) {
                this.out.write(this.sequence);
                this.out.write(this.postfix);
                this.position = 0;
            }
        } else {
            this.out.write(this.postfix, 0, this.position);
            this.out.write(by);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this.postfix, 0, this.position);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

