/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BufferingOutputStream
extends OutputStream {
    private final OutputStream out;
    private byte[] buffer;
    private int size;

    public BufferingOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.out = outputStream;
        this.buffer = new byte[1024];
        this.size = 0;
    }

    private void ensureCapacity(int n) {
        if (this.buffer.length < n) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
    }

    @Override
    public void write(int n) {
        this.write((byte)n);
    }

    public void write(byte by) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = by;
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this.buffer, 0, this.size);
        this.size = 0;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

