/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.solver.thread;

import at.ptasat.solver.AsyncSolver;
import at.ptasat.solver.AsyncSolverListener;
import at.tasat.Configuration;
import at.tasat.cnf.Cnf;
import at.tasat.io.OutputFormatter;
import at.tasat.parser.DimacsParser;
import at.tasat.solver.Solver;
import at.tasat.solver.SolverConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class AsyncThreadSolver
extends AsyncSolver {
    private Thread thread = null;

    public AsyncThreadSolver(int n, AsyncSolverListener asyncSolverListener, OutputStream outputStream, OutputStream outputStream2, String string) {
        super(n, asyncSolverListener, outputStream, outputStream2, string);
    }

    @Override
    public void start(String string, File file) throws Exception {
        String string2 = string + " " + this.getArguments() + " " + file.getAbsolutePath();
        final SolverConfiguration solverConfiguration = Configuration.get(string2.split(" ")).getSolverConfig();
        final Cnf cnf = AsyncThreadSolver.parse(file);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AsyncThreadSolver.this.runWorker(solverConfiguration, cnf);
            }
        });
        this.thread.start();
    }

    private static Cnf parse(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Cnf cnf = DimacsParser.parse(fileInputStream);
            return cnf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorker(SolverConfiguration solverConfiguration, Cnf cnf) {
        Solver solver = Solver.create(solverConfiguration, cnf);
        try {
            boolean bl = solver.solve();
            new PrintStream(this.getOut()).println(OutputFormatter.getResultString(bl, solver.getAssignment().getAllAssignments()));
            this.fireSolved();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable throwable) {
            new PrintStream(this.getErr()).println(OutputFormatter.getErrorString(throwable));
        }
        finally {
            solver.releaseThreadManager();
            this.thread = null;
        }
    }

    @Override
    public void kill() throws InterruptedException {
        Thread thread = this.thread;
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }
}

