/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.solver.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PollingRedirection {
    private final InputStream in;
    private final OutputStream out;
    private final Thread worker;

    public PollingRedirection(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, PollingRedirection.class.getName());
    }

    public PollingRedirection(InputStream inputStream, OutputStream outputStream, String string) {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.out = outputStream;
        this.worker = new Thread(new MyRunnable());
        this.worker.setName(string);
        this.worker.setDaemon(true);
        this.worker.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
            }
        });
        this.worker.start();
    }

    public void close() throws IOException, InterruptedException {
        this.in.close();
        this.worker.interrupt();
        this.worker.join();
        this.out.close();
    }

    private final class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            assert (Thread.currentThread().equals(PollingRedirection.this.worker));
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while (!PollingRedirection.this.worker.isInterrupted()) {
                    n = PollingRedirection.this.in.read(byArray);
                    if (n < 0) {
                        PollingRedirection.this.worker.interrupt();
                        continue;
                    }
                    PollingRedirection.this.out.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

