/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.solver.process;

import at.ptasat.solver.AsyncSolver;
import at.ptasat.solver.AsyncSolverListener;
import at.ptasat.solver.process.PollingRedirection;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

final class AsyncProcessSolver
extends AsyncSolver {
    private static final String JAVA = "java";
    private static final String[] VM_ARGUMENTS = ("-" + (AsyncProcessSolver.class.desiredAssertionStatus() ? "e" : "d") + "a" + " -jar tasat.jar").split(" ");
    private Thread worker = null;
    private Process process = null;
    private PollingRedirection outRedirection;
    private PollingRedirection errRedirection;

    public AsyncProcessSolver(int n, AsyncSolverListener asyncSolverListener, OutputStream outputStream, OutputStream outputStream2, String string) {
        super(n, asyncSolverListener, outputStream, outputStream2, string);
    }

    @Override
    public void start(String string, File file) throws Exception {
        int n;
        String[] stringArray = this.getArguments().split(" ");
        String[] stringArray2 = string.split(" ");
        String[] stringArray3 = new String[1 + VM_ARGUMENTS.length + stringArray2.length + stringArray.length + 1];
        int n2 = 0;
        stringArray3[n2++] = JAVA;
        for (n = 0; n < VM_ARGUMENTS.length; ++n) {
            stringArray3[n2++] = VM_ARGUMENTS[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        stringArray3[n2++] = file.getAbsolutePath();
        assert (n2 == stringArray3.length);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray3);
        processBuilder.directory(new File(System.getProperty("user.dir")));
        this.process = processBuilder.start();
        this.outRedirection = new PollingRedirection(this.process.getInputStream(), this.getOut(), this.getId() + " out");
        this.errRedirection = new PollingRedirection(this.process.getErrorStream(), this.getErr(), this.getId() + " err");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = AsyncProcessSolver.this.process.waitFor();
                    if (n == 0) {
                        AsyncProcessSolver.this.fireSolved();
                    } else {
                        AsyncProcessSolver.this.fireFailed();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.worker = new Thread(runnable);
        this.worker.start();
    }

    @Override
    public void kill() {
        if (this.worker != null && this.worker.isAlive()) {
            this.worker.interrupt();
            this.worker = null;
        }
        if (this.process != null) {
            this.process.destroy();
            try {
                this.outRedirection.close();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.errRedirection.close();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.outRedirection = null;
            this.errRedirection = null;
            this.process = null;
        }
    }
}

