/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat.solver;

import at.ptasat.solver.AsyncSolverListener;
import at.ptasat.util.SequenceInsertingOutputStream;
import java.io.File;
import java.io.OutputStream;

public abstract class AsyncSolver {
    private static final byte[] PREFIX = "\n".getBytes();
    private final int id;
    private final AsyncSolverListener callback;
    private final OutputStream out;
    private final OutputStream err;
    private final String argument;

    public AsyncSolver(int n, AsyncSolverListener asyncSolverListener, OutputStream outputStream, OutputStream outputStream2, String string) {
        this.id = n;
        this.callback = asyncSolverListener;
        byte[] byArray = String.format(" (worker %d)", n).getBytes();
        this.out = new SequenceInsertingOutputStream(outputStream, PREFIX, byArray);
        this.err = new SequenceInsertingOutputStream(outputStream2, PREFIX, byArray);
        this.argument = string;
        asyncSolverListener.enroll(this);
    }

    public int getId() {
        return this.id;
    }

    public String getArguments() {
        return this.argument;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    protected void fireSolved() {
        this.callback.solved(this);
    }

    protected void fireFailed() {
        this.callback.failed(this);
    }

    public abstract void start(String var1, File var2) throws Exception;

    public abstract void kill() throws InterruptedException;
}

