/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat;

import at.ptasat.Configuration;
import at.ptasat.solver.AsyncSolver;
import at.ptasat.solver.AsyncSolverListener;
import at.ptasat.util.BufferingOutputStream;
import at.ptasat.util.NullOutputStream;
import at.tasat.io.OutputFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public final class Main {
    public static void main(String[] stringArray) {
        Configuration configuration = Configuration.get(stringArray);
        int n = Main.main(configuration);
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(Configuration configuration) {
        int n;
        boolean bl = configuration.isVerboseStatus();
        PrintStream printStream = new PrintStream(configuration.getOut());
        PrintStream printStream2 = new PrintStream(configuration.getErr());
        Configuration.ArgumentConfig[] argumentConfigArray = configuration.getArgumentConfigs();
        ArrayList<AsyncSolver> arrayList = new ArrayList<AsyncSolver>(argumentConfigArray.length);
        try {
            if (configuration.isVerboseConfig()) {
                printStream.println(OutputFormatter.getCommentString(configuration.toString()));
            }
            Main.log(bl, printStream, "creating workers", new Object[0]);
            File file = configuration.isInFile() ? configuration.getInFile() : Main.writeToTempFile(configuration.getIn());
            Handler handler = new Handler(printStream, printStream2, configuration.isVerboseWinner());
            block13: for (Configuration.ArgumentConfig stringArray : argumentConfigArray) {
                for (int i = 0; i < stringArray.nInstances; ++i) {
                    OutputStream outputStream = Main.createSolverStream(configuration.getOut(), configuration.getOutPipeMode());
                    OutputStream outputStream2 = Main.createSolverStream(configuration.getErr(), configuration.getErrPipeMode());
                    arrayList.add(configuration.getFactory().create(handler, outputStream, outputStream2, stringArray.argument));
                    if (configuration.getMax() > 0 && arrayList.size() >= configuration.getMax()) break block13;
                }
            }
            Main.log(bl, printStream, "starting workers", new Object[0]);
            for (AsyncSolver asyncSolver : arrayList) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : configuration.getGlobalArguments()) {
                    stringBuilder.append(string);
                    stringBuilder.append(' ');
                }
                if (!asyncSolver.getArguments().contains("--seed") && !asyncSolver.getArguments().contains("-s")) {
                    stringBuilder.append("--seed=" + configuration.getRandom().nextLong());
                    stringBuilder.append(' ');
                }
                if (configuration.isVerboseWorker()) {
                    printStream.println(OutputFormatter.getCommentString("worker " + asyncSolver.getId() + ": \"" + stringBuilder + " " + asyncSolver.getArguments() + "\""));
                }
                Main.log(bl, printStream, "starting worker %d: (\"%s\")", asyncSolver.getId(), asyncSolver.getArguments());
                asyncSolver.start(stringBuilder.toString().trim(), file);
                Main.log(bl, printStream, "started worker %d: (\"%s\")", asyncSolver.getId(), asyncSolver.getArguments());
            }
            Main.log(bl, printStream, "started %d workers", arrayList.size());
            Main.log(bl, printStream, "waiting for workers", new Object[0]);
            Handler handler2 = handler;
            synchronized (handler2) {
                while (!handler.isFinished()) {
                    handler.wait();
                }
            }
            Main.log(bl, printStream, "finished", new Object[0]);
            n = 0;
        }
        catch (Throwable throwable) {
            int n2;
            try {
                Main.log(bl, printStream2, "failed", new Object[0]);
                printStream2.println(OutputFormatter.getErrorString(throwable));
                n2 = 1;
            }
            catch (Throwable throwable2) {
                Main.log(bl, printStream, "killing all workers", new Object[0]);
                for (AsyncSolver asyncSolver : arrayList) {
                    Main.log(bl, printStream, "killing worker %d", asyncSolver.getId());
                    try {
                        asyncSolver.kill();
                    }
                    catch (InterruptedException interruptedException) {
                        Main.log(bl, printStream, "killing worker %d failed (was interrupted)", asyncSolver.getId());
                    }
                    Main.log(bl, printStream, "killed worker %d", asyncSolver.getId());
                }
                Main.log(bl, printStream, "killed all workers", new Object[0]);
                throw throwable2;
            }
            Main.log(bl, printStream, "killing all workers", new Object[0]);
            for (AsyncSolver asyncSolver : arrayList) {
                Main.log(bl, printStream, "killing worker %d", asyncSolver.getId());
                try {
                    asyncSolver.kill();
                }
                catch (InterruptedException interruptedException) {
                    Main.log(bl, printStream, "killing worker %d failed (was interrupted)", asyncSolver.getId());
                }
                Main.log(bl, printStream, "killed worker %d", asyncSolver.getId());
            }
            Main.log(bl, printStream, "killed all workers", new Object[0]);
            return n2;
        }
        Main.log(bl, printStream, "killing all workers", new Object[0]);
        for (AsyncSolver asyncSolver : arrayList) {
            Main.log(bl, printStream, "killing worker %d", asyncSolver.getId());
            try {
                asyncSolver.kill();
            }
            catch (InterruptedException interruptedException) {
                Main.log(bl, printStream, "killing worker %d failed (was interrupted)", asyncSolver.getId());
            }
            Main.log(bl, printStream, "killed worker %d", asyncSolver.getId());
        }
        Main.log(bl, printStream, "killed all workers", new Object[0]);
        return n;
    }

    private static File writeToTempFile(InputStream inputStream) throws IOException, FileNotFoundException {
        File file = File.createTempFile("p-tasat_", "cnf");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        ((OutputStream)fileOutputStream).close();
        return file;
    }

    private static void log(boolean bl, PrintStream printStream, String string, Object ... objectArray) {
        if (bl) {
            printStream.println(OutputFormatter.getCommentString(String.format(string.trim(), objectArray)));
        }
    }

    private static OutputStream createSolverStream(OutputStream outputStream, Configuration.PipeMode pipeMode) {
        switch (pipeMode) {
            case IMMEDIATE: {
                return outputStream;
            }
            case LATE_ON_SELF_TERMINATION: {
                return new BufferingOutputStream(outputStream);
            }
            case SILENT: {
                return new NullOutputStream();
            }
        }
        throw new IllegalArgumentException();
    }

    private static final class Handler
    implements AsyncSolverListener {
        private final PrintStream out;
        private final PrintStream err;
        private final boolean isVerboseWinner;
        private int nSolvers;
        private int nFinished;
        private boolean finished;

        public Handler(PrintStream printStream, PrintStream printStream2, boolean bl) {
            this.out = printStream;
            this.err = printStream2;
            this.nSolvers = 0;
            this.isVerboseWinner = bl;
            this.nFinished = 0;
            this.finished = false;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public synchronized void enroll(AsyncSolver asyncSolver) {
            ++this.nSolvers;
        }

        @Override
        public synchronized void solved(AsyncSolver asyncSolver) {
            if (!this.finished) {
                ++this.nFinished;
                this.finished = true;
                this.notifyAll();
                try {
                    asyncSolver.getErr().flush();
                    asyncSolver.getOut().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.isVerboseWinner) {
                    this.out.println(OutputFormatter.getCommentString("winner: worker " + asyncSolver.getId() + " (\"" + asyncSolver.getArguments() + "\")"));
                }
            }
        }

        @Override
        public synchronized void failed(AsyncSolver asyncSolver) {
            if (!this.finished) {
                ++this.nFinished;
                this.finished |= this.nFinished >= this.nSolvers;
                if (this.finished) {
                    this.notifyAll();
                }
                try {
                    asyncSolver.getOut().flush();
                    asyncSolver.getErr().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.err.println(OutputFormatter.getErrorString("failed: worker " + asyncSolver.getId() + " (\"" + asyncSolver.getArguments() + "\")"));
            }
        }
    }
}

