/*
 * Decompiled with CFR 0.152.
 */
package at.ptasat;

import at.ptasat.solver.AsyncSolverFactory;
import at.ptasat.solver.process.AsyncProcessSolverFactory;
import at.ptasat.solver.thread.AsyncThreadSolverFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class Configuration {
    private static final String[] DEFAULT_ARGUMENTS = new String[]{"--queue=default", "--queue=inverting", "--queue=static-occurences", "--queue=dynamic-occurences:5", "--queue=dynamic-occurences:1", "--queue=dynamic-occurences:25"};
    private static final String DEFAULT_REST_ARGUMENT = "--queue=random";
    private static final ArgumentConfig[] DEFAULT_ARGUMENT_CONFIGS;
    private InputStream in = System.in;
    private OutputStream out = System.out;
    private OutputStream err = System.err;
    private File file = null;
    private AsyncSolverFactory factory = new AsyncThreadSolverFactory();
    private final List<ArgumentConfig> argumentConfigs = new ArrayList<ArgumentConfig>();
    private boolean isDefaultArgumentConfigs;
    private List<String> globalArguments;
    private Random random;
    private int max;
    private PipeMode outPipeMode;
    private PipeMode errPipeMode;
    private boolean isVerboseConfig;
    private boolean isVerboseStatus;
    private boolean isVerboseWinner;
    private boolean isVerboseWorkers;

    public Configuration() {
        for (ArgumentConfig argumentConfig : DEFAULT_ARGUMENT_CONFIGS) {
            this.argumentConfigs.add(argumentConfig);
        }
        this.isDefaultArgumentConfigs = true;
        this.globalArguments = new ArrayList<String>();
        this.random = new Random();
        this.max = Runtime.getRuntime().availableProcessors();
        this.outPipeMode = PipeMode.LATE_ON_SELF_TERMINATION;
        this.errPipeMode = PipeMode.LATE_ON_SELF_TERMINATION;
        this.isVerboseConfig = false;
        this.isVerboseStatus = false;
        this.isVerboseWinner = false;
        this.isVerboseWorkers = false;
    }

    public static Configuration get(String[] stringArray) {
        Configuration configuration = new Configuration();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() == 0) continue;
            if (string.startsWith("-")) {
                if (string.equals("-t") || string.equals("--threads")) {
                    configuration.setFactory(new AsyncThreadSolverFactory());
                    continue;
                }
                if (string.equals("-p") || string.equals("--processes")) {
                    configuration.setFactory(new AsyncProcessSolverFactory());
                    continue;
                }
                if (string.startsWith("-w")) {
                    configuration.addArgumentConfig(new ArgumentConfig(string.substring("-w".length())));
                    continue;
                }
                if (string.startsWith("--worker")) {
                    configuration.addArgumentConfig(new ArgumentConfig(string.substring("--worker".length())));
                    continue;
                }
                String string2 = string.substring(0, string.indexOf(61));
                String string3 = string.substring(string.indexOf(61) + 1, string.length());
                if (string2.equals("-v") || string2.equals("--verbose")) {
                    for (String string4 : string3.split(",")) {
                        if (string4.equals("status")) {
                            configuration.setVerboseStatus(true);
                            continue;
                        }
                        if (string4.equals("winner")) {
                            configuration.setVerboseWinner(true);
                            continue;
                        }
                        if (string4.equals("workers")) {
                            configuration.setVerboseWorkers(true);
                            continue;
                        }
                        if (string4.equals("config")) {
                            configuration.setVerboseConfig(true);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown verbose value: " + string4);
                    }
                    continue;
                }
                if (string2.equals("-g") || string2.equals("--global")) {
                    configuration.addGlobalArguments(string3);
                    continue;
                }
                if (string2.equals("-m") || string2.equals("--max")) {
                    int n = Integer.valueOf(string3);
                    if (n < 0) {
                        throw new IllegalArgumentException("max must be zero or greater but was " + n + "!");
                    }
                    configuration.setMax(n);
                    continue;
                }
                if (string2.equals("-o") || string2.equals("--out-pipe-mode")) {
                    configuration.setOutPipeMode(PipeMode.parse(string3));
                    continue;
                }
                if (string2.equals("-e") || string2.equals("--err-pipe-mode")) {
                    configuration.setErrPipeMode(PipeMode.parse(string3));
                    continue;
                }
                if (string2.equals("-s") || string2.equals("--seed")) {
                    configuration.setRandom(new Random(Long.parseLong(string3)));
                    continue;
                }
                throw new IllegalArgumentException("Unknown property name: " + string2);
            }
            configuration.setIn(new File(string));
            break;
        }
        return configuration;
    }

    public boolean isInFile() {
        return this.file != null;
    }

    public InputStream getIn() throws IOException {
        return this.in != null ? this.in : (this.in = new FileInputStream(this.file));
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public File getInFile() {
        return this.file;
    }

    public AsyncSolverFactory getFactory() {
        return this.factory;
    }

    public ArgumentConfig[] getArgumentConfigs() {
        return this.argumentConfigs.toArray(new ArgumentConfig[this.argumentConfigs.size()]);
    }

    public String[] getGlobalArguments() {
        return this.globalArguments.toArray(new String[this.globalArguments.size()]);
    }

    public Random getRandom() {
        return this.random;
    }

    public int getMax() {
        return this.max;
    }

    public PipeMode getOutPipeMode() {
        return this.outPipeMode;
    }

    public PipeMode getErrPipeMode() {
        return this.errPipeMode;
    }

    public boolean isVerboseConfig() {
        return this.isVerboseConfig;
    }

    public boolean isVerboseStatus() {
        return this.isVerboseStatus;
    }

    public boolean isVerboseWinner() {
        return this.isVerboseWinner;
    }

    public boolean isVerboseWorker() {
        return this.isVerboseWorkers;
    }

    public void setIn(InputStream inputStream) {
        assert (inputStream != null);
        this.in = inputStream;
        this.file = null;
    }

    public void setIn(File file) {
        assert (file != null);
        this.file = file;
        this.in = null;
    }

    public void setOut(OutputStream outputStream) {
        assert (outputStream != null);
        this.out = outputStream;
    }

    public void setErr(OutputStream outputStream) {
        assert (outputStream != null);
        this.err = outputStream;
    }

    public void setFactory(AsyncSolverFactory asyncSolverFactory) {
        assert (asyncSolverFactory != null);
        this.factory = asyncSolverFactory;
    }

    public void addArgumentConfig(ArgumentConfig argumentConfig) {
        assert (argumentConfig != null);
        if (this.isDefaultArgumentConfigs) {
            this.argumentConfigs.clear();
            this.isDefaultArgumentConfigs = false;
        }
        this.argumentConfigs.add(argumentConfig);
    }

    public void addGlobalArguments(String string) {
        assert (this.globalArguments != null);
        this.globalArguments.add(string);
    }

    public void setRandom(Random random) {
        assert (random != null);
        this.random = random;
    }

    public void setMax(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Max must be greater than zero!");
        }
        this.max = n;
    }

    public void setOutPipeMode(PipeMode pipeMode) {
        assert (pipeMode != null);
        if (pipeMode == PipeMode.SILENT) {
            throw new IllegalArgumentException("out-pipe-mode mustn't be silent!");
        }
        this.outPipeMode = pipeMode;
    }

    public void setErrPipeMode(PipeMode pipeMode) {
        assert (pipeMode != null);
        this.errPipeMode = pipeMode;
    }

    public void setVerboseConfig(boolean bl) {
        this.isVerboseConfig = bl;
    }

    public void setVerboseStatus(boolean bl) {
        this.isVerboseStatus = bl;
    }

    public void setVerboseWinner(boolean bl) {
        this.isVerboseWinner = bl;
    }

    public void setVerboseWorkers(boolean bl) {
        this.isVerboseWorkers = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("--verbose=%s,%s,%s,%s ", this.isVerboseConfig ? "config" : "", this.isVerboseStatus ? "status" : "", this.isVerboseWinner ? "winner" : "", this.isVerboseWorkers ? "workers" : ""));
        stringBuilder.append(String.format("--%s ", this.factory.getName()));
        for (ArgumentConfig argumentConfig : this.argumentConfigs) {
            stringBuilder.append(String.format("--worker%s ", argumentConfig));
        }
        stringBuilder.append(String.format("--global=%s ", this.globalArguments));
        stringBuilder.append(String.format("--max=%d ", this.max));
        if (this.file != null) {
            stringBuilder.append(this.file.getAbsolutePath());
        }
        return stringBuilder.toString().trim();
    }

    static {
        ArrayList<ArgumentConfig> arrayList = new ArrayList<ArgumentConfig>();
        int n = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < n; ++i) {
            String string = i < DEFAULT_ARGUMENTS.length ? DEFAULT_ARGUMENTS[i] : DEFAULT_REST_ARGUMENT;
            arrayList.add(new ArgumentConfig("1:\"" + string + "\""));
        }
        DEFAULT_ARGUMENT_CONFIGS = arrayList.toArray(new ArgumentConfig[arrayList.size()]);
    }

    public static final class ArgumentConfig {
        public final int nInstances;
        public final String argument;

        public ArgumentConfig(String string) {
            String string2;
            this.nInstances = Integer.valueOf(string.substring(0, string.indexOf(58)));
            this.argument = string2 = string.substring(string.indexOf(58) + 1).replace('\"', ' ').trim();
        }

        public String toString() {
            return String.format("%d:\"%s\"", this.nInstances, this.argument);
        }
    }

    public static enum PipeMode {
        IMMEDIATE("immediate"),
        LATE_ON_SELF_TERMINATION("late"),
        SILENT("silent");

        private final String representation;

        private PipeMode(String string2) {
            this.representation = string2;
        }

        public static PipeMode parse(String string) {
            for (PipeMode pipeMode : PipeMode.values()) {
                if (!pipeMode.representation.equals(string)) continue;
                return pipeMode;
            }
            return null;
        }

        public String toString() {
            return this.representation;
        }
    }
}

