/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeMap;
import spec.reporter.BenchmarkRecord;
import spec.reporter.HTMLWriter;
import spec.reporter.PlainWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Writer {
    protected PrintStream stream;
    protected FileOutputStream fos;
    String type;

    protected Writer(String outputFileName) {
        try {
            this.fos = new FileOutputStream(outputFileName);
            this.stream = new PrintStream(this.fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void closeStream() {
        this.stream.close();
    }

    public void startTable(String header, boolean needHeader) {
    }

    public void startTable(String header, boolean needHeader, boolean showBorder, boolean onlyTableStart) {
    }

    public abstract void startDetailsTable();

    public void endTable(boolean endTbody) {
    }

    public abstract void insertRecord(String var1, String var2);

    public abstract void insertRecords(ArrayList var1);

    public abstract void putSummaryTable(String var1, TreeMap<String, Double> var2);

    public abstract void putHat(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11);

    public void startRecordAndData() {
    }

    public void endRecordAndData() {
    }

    public void endAndStartRecordAndData() {
    }

    public void endAndStartData() {
    }

    public void endTable() {
    }

    public abstract void handleBenchmarkRecord(BenchmarkRecord var1);

    public void startReport() {
    }

    public void endReport() {
    }

    public abstract String getCopyRightSign();

    public static Writer getInstance(String desc, String outputFileName) {
        if ("html".equals(desc)) {
            return new HTMLWriter(outputFileName);
        }
        if ("plain".equals(desc)) {
            return new PlainWriter(outputFileName);
        }
        throw new RuntimeException("Cannot instantiate writer of type '" + desc + "'");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }
}

