/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import spec.reporter.BenchmarkRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final Double INVALID_SCORE = -1.0;
    static final String HTML_WRITER_TYPE = "html";
    static final String PLAIN_WRITER_TYPE = "plain";
    static final String CSCORE_NAME = "composite score";
    static final String[] DETAILS_TABLE_COLUMNS_NAMES = new String[]{"benchmark name", "configuration", "iteration", "expected run time (millis)", "actual run time(millis)", "operations", "ops/m", "graph"};
    static final String[] DETAILS_TABLE_BM_CONF_NAMES = new String[]{"number of threads", "minIter", "maxIter", "warmup time", "run time", "iteration delay", "analyzers", "analyzers frequency"};
    static final String[] BM_CONFIGURATION_ENAMES = new String[]{"numberBmThreads", "minIter", "maxIter", "warmupTime", "iterationTime", "iterationDelay", "analyzers", "analyzerFreq"};
    public static String REPORTER_DIR;
    public static String IMAGES_DIR;
    public static boolean debug;
    private static Hashtable<String, String> descriptions;
    static final DecimalFormat df;
    static final HashMap colorMap;

    public static void createBmResultGraph(BenchmarkRecord record) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String iterName = "";
        double max = 0.0;
        double min = 9.223372036854776E18;
        for (int i = 0; i < record.iterRecords.size(); ++i) {
            BenchmarkRecord.IterationRecord iterRecord = record.iterRecords.get(i);
            String shortName = iterRecord.iterName.replaceFirst("ation", "");
            if (iterRecord.score > max) {
                max = iterRecord.score;
                iterName = shortName;
            }
            if (iterRecord.score < min) {
                min = iterRecord.score;
            }
            dataset.addValue(iterRecord.score, (Comparable)((Object)" "), (Comparable)((Object)shortName));
        }
        JFreeChart chart = ChartFactory.createLineChart((String)"  ", (String)"iterations", (String)"ops/m", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)new Color(201, 222, 254));
        plot.setRangeGridlinePaint((Paint)Color.WHITE);
        if (record.isValidRun() && min != 9.223372036854776E18) {
            plot.getRangeAxis().setRange(min - 10.0, max + 10.0);
        } else {
            plot.getRangeAxis().setRange(0.0, max + 10.0);
        }
        ValueMarker vm = new ValueMarker(record.maxScore);
        vm.setLabel(df.format(record.maxScore));
        vm.setLabelAnchor(RectangleAnchor.TOP_LEFT);
        vm.setLabelTextAnchor(TextAnchor.HALF_ASCENT_LEFT);
        plot.addRangeMarker((Marker)vm);
        CategoryMarker marker = new CategoryMarker((Comparable)((Object)iterName));
        marker.setDrawAsLine(true);
        marker.setPaint(vm.getPaint());
        plot.addDomainMarker(marker);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setFillPaint((Paint)Color.WHITE);
        renderer.setSeriesPaint(0, (Paint)Color.BLUE.darker());
        try {
            ChartUtilities.saveChartAsJPEG((File)new File(Utils.getFullImageName(record.name + "_results")), (JFreeChart)chart, (int)300, (int)200);
        }
        catch (Exception e) {
            System.out.println("Problems...");
        }
    }

    private static void initDescriptions() {
        descriptions = new Hashtable();
        descriptions.put("spec.jvm2008.report.run.date", "Test date:");
        descriptions.put("spec.jvm2008.report.run.submitter.url", "Submitter URL");
        descriptions.put("spec.jvm2008.report.run.license", "SPEC license");
        descriptions.put("spec.jvm2008.report.run.tester", "Tester");
        descriptions.put("spec.jvm2008.report.run.submitter", "Submitter");
        descriptions.put("spec.jvm2008.report.run.location", "Location");
        descriptions.put("spec.jvm2008.report.jvm.vendor", "Vendor");
        descriptions.put("spec.jvm2008.report.jvm.vendor.url", "Vendor URL");
        descriptions.put("spec.jvm2008.report.jvm.name", "JVM name");
        descriptions.put("spec.jvm2008.report.jvm.version", "JVM version");
        descriptions.put("spec.jvm2008.report.jvm.available.date", "JVM available");
        descriptions.put("spec.jvm2008.report.jvm.java.specification", "Java Specification");
        descriptions.put("spec.jvm2008.report.jvm.address.bits", "JVM address bits");
        descriptions.put("spec.jvm2008.report.jvm.command.line.initial.heap.size", "JVM initial heap memory");
        descriptions.put("spec.jvm2008.report.jvm.command.line.max.heap.size", "JVM maximum heap memory");
        descriptions.put("spec.jvm2008.report.jvm.command.line", "JVM command line");
        descriptions.put("spec.jvm2008.report.jvm.startup.command.line", "JVM command line startup");
        descriptions.put("spec.jvm2008.report.jvm.startup.launcher", "JVM launcher startup");
        descriptions.put("spec.jvm2008.report.jvm.other.tuning", "Additional JVM tuning");
        descriptions.put("spec.jvm2008.report.jvm.app.class.path", "JVM class path");
        descriptions.put("spec.jvm2008.report.jvm.boot.class.path", "JVM boot class path");
        descriptions.put("spec.jvm2008.report.os.name", "OS name");
        descriptions.put("spec.jvm2008.report.os.available.date", "OS available");
        descriptions.put("spec.jvm2008.report.os.address.bits", "OS address bits");
        descriptions.put("spec.jvm2008.report.os.tuning", "OS tuning");
        descriptions.put("spec.jvm2008.report.sw.filesystem", "Filesystem");
        descriptions.put("spec.jvm2008.report.sw.other.name", "Other s/w name");
        descriptions.put("spec.jvm2008.report.sw.other.tuning", "Other s/w tuning");
        descriptions.put("spec.jvm2008.report.sw.other.available", "Other s/w available");
        descriptions.put("spec.jvm2008.report.hw.vendor", "HW vendor");
        descriptions.put("spec.jvm2008.report.hw.vendor.url", "HW vendor's URL");
        descriptions.put("spec.jvm2008.report.hw.model", "HW model");
        descriptions.put("spec.jvm2008.report.hw.available", "HW available");
        descriptions.put("spec.jvm2008.report.hw.cpu.vendor", "CPU vendor");
        descriptions.put("spec.jvm2008.report.hw.cpu.vendor.url", "CPU vendor's URL");
        descriptions.put("spec.jvm2008.report.hw.cpu.name", "CPU name");
        descriptions.put("spec.jvm2008.report.hw.cpu.speed", "CPU frequency");
        descriptions.put("spec.jvm2008.report.hw.logical.cpus", "# of logical cpus");
        descriptions.put("spec.jvm2008.report.hw.number.of.chips", "# of chips");
        descriptions.put("spec.jvm2008.report.hw.number.of.cores", "# of cores");
        descriptions.put("spec.jvm2008.report.hw.number.of.cores.per.chip", "Cores per chip");
        descriptions.put("spec.jvm2008.report.hw.threads.per.core", "Threads per core");
        descriptions.put("spec.jvm2008.report.hw.threading.enabled", "Threading enabled");
        descriptions.put("spec.jvm2008.report.hw.address.bits", "HW address bits");
        descriptions.put("spec.jvm2008.report.hw.cpu.cache.l1", "Primary cache");
        descriptions.put("spec.jvm2008.report.hw.cpu.cache.l2", "Secondary cache");
        descriptions.put("spec.jvm2008.report.hw.cpu.cache.other", "Other cache");
        descriptions.put("spec.jvm2008.report.hw.memory.details", "Memory details");
        descriptions.put("spec.jvm2008.report.hw.memory.size", "Memory size");
        descriptions.put("spec.jvm2008.report.hw.details.other", "Other HW details");
        descriptions.put("category", "Category of run");
        descriptions.put("iterationTime", "Iteration duration");
        descriptions.put("warmupTime", "Warm up time");
        descriptions.put("minIter", "Minimum Iterations");
        descriptions.put("maxIter", "Maximum Iterations");
        descriptions.put("analyzers", "Analyzer names");
        descriptions.put("analyzerFreq", "Analyzer frequency");
        descriptions.put("specjvm.benchmark.systemgc", "System.gc in between benchmarks");
        descriptions.put("benchmarkDelay", "Benchmark delay");
        descriptions.put("specjvm.iteration.systemgc", "System.gc in between iterations");
        descriptions.put("iterationDelay", "Iteration delay");
    }

    public static String getDescription(String prop) {
        String result;
        if (descriptions == null) {
            Utils.initDescriptions();
        }
        return (result = descriptions.get(prop)) != null ? result : prop;
    }

    public static final HashMap initColorMap() {
        HashMap<String, Color> result = new HashMap<String, Color>();
        result.put(CSCORE_NAME, new Color(192, 0, 0));
        result.put("sunflow", new Color(85, 255, 85));
        result.put("mpegaudio", new Color(169, 22, 218));
        result.put("scimark.large", new Color(90, 150, 77));
        result.put("scimark.small", new Color(255, 85, 255));
        result.put("startup", new Color(85, 255, 255));
        result.put("compress", new Color(0, 0, 192));
        result.put("serial", new Color(0, 192, 0));
        result.put("crypto", new Color(192, 0, 192));
        result.put("compiler", new Color(0, 192, 192));
        result.put("derby", new Color(255, 64, 64));
        result.put("xml", new Color(64, 64, 255));
        return result;
    }

    public static void generateMainChart(double compositeScore, TreeMap<String, Double> scores) {
        Color[] colors = new Color[scores.size() + 8];
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int count = 0;
        for (String key : scores.keySet()) {
            Double score = scores.get(key);
            if (!Utils.isValidScore(score)) continue;
            dataset.addValue((Number)score, (Comparable)((Object)key), (Comparable)((Object)key));
            colors[count++] = (Color)colorMap.get(key);
        }
        if (Utils.isValidScore(compositeScore)) {
            dataset.addValue(compositeScore, (Comparable)((Object)CSCORE_NAME), (Comparable)((Object)CSCORE_NAME));
            colors[count++] = (Color)colorMap.get(CSCORE_NAME);
        }
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"Scores", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        CategoryItemRenderer renderer = chart.getCategoryPlot().getRendererForDataset((CategoryDataset)dataset);
        for (int i = 0; i < count; ++i) {
            Color paint = colors[i];
            if (paint == null) continue;
            renderer.setSeriesPaint(i, (Paint)paint);
        }
        try {
            ChartUtilities.saveChartAsJPEG((File)new File(Utils.getFullImageName("all")), (JFreeChart)chart, (int)600, (int)(50 + dataset.getRowCount() * 20));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final boolean isCheck(BenchmarkRecord record) {
        return "check".equals(record.name);
    }

    static final boolean isScimarkMonteCarlo(BenchmarkRecord record) {
        return record != null && "scimark.monte_carlo".equals(record.name);
    }

    static final boolean isScimarkLarge(BenchmarkRecord record) {
        return record.name.startsWith("scimark") && record.name.endsWith("large");
    }

    static final boolean isScimarkSmall(BenchmarkRecord record) {
        return record.name.startsWith("scimark") && record.name.endsWith("small");
    }

    static final String getImageName(String pictureName) {
        return "images/" + pictureName + ".jpg";
    }

    static final String getFullImageName(String pictureName) {
        return IMAGES_DIR + "/" + pictureName + ".jpg";
    }

    static final String getRunStatus(boolean validRun, boolean compliantRun) {
        if (validRun && compliantRun) {
            return "Run is compliant";
        }
        if (validRun) {
            return "Run is valid, but not compliant";
        }
        return "Run is not valid";
    }

    static final String formatScore(double score) {
        return Utils.formatScore(score, "", "");
    }

    static final String formatScore(double score, String postfix) {
        return Utils.formatScore(score, "", postfix);
    }

    static final String formatScore(double score, String prefix, String postfix) {
        return !Utils.isValidScore(score) ? "not valid" : prefix + df.format(score) + postfix;
    }

    static void dbgPrint(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    static boolean isValidScore(Double score) {
        return !INVALID_SCORE.equals(score);
    }

    static boolean isValidScore(double score) {
        return !INVALID_SCORE.equals(score);
    }

    static {
        debug = false;
        df = new DecimalFormat("#.##");
        colorMap = Utils.initColorMap();
    }
}

