/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import spec.harness.StopBenchmarkException;
import spec.reporter.ReportGenerator;

public class SPECSubmissionProcessor {
    private static String inFileNameAbsolute = null;
    private static String reportRootDir = null;
    private static String reportRootName = null;
    private static String resultDirBase = null;
    private static String resultDirPeak = null;
    private static String mergedSubFileName = null;
    private static String baseRawFileName = null;
    private static String peakRawFileName = null;
    private static String specNonCompliance = null;
    private static String specNonComplianceReason = null;
    private static String specNonComplianceRemedy = null;
    private static String specReportPreparedDate = null;
    private static LinkedList<String> errors = new LinkedList();
    private static String[] modeBasedProps = new String[]{"spec.jvm2008.report.result.status", "spec.jvm2008.report.result.score", "spec.jvm2008.report.result.metric", "spec.jvm2008.report.result.workload.name", "spec.jvm2008.report.result.workload.mode", "spec.jvm2008.report.run.date", "spec.jvm2008.report.jvm.command.line", "spec.jvm2008.report.jvm.command.line.initial.heap.size", "spec.jvm2008.report.jvm.command.line.max.heap.size", "spec.jvm2008.report.jvm.startup.command.line", "spec.jvm2008.report.jvm.other.tuning", "spec.jvm2008.report.os.tuning", "spec.jvm2008.report.sw.other.tuning"};
    private static String[] commonProps = new String[]{"spec.jvm2008.report.run.tester", "spec.jvm2008.report.run.submitter", "spec.jvm2008.report.run.submitter.url", "spec.jvm2008.report.run.location", "spec.jvm2008.report.run.license", "spec.jvm2008.report.jvm.name", "spec.jvm2008.report.jvm.version", "spec.jvm2008.report.jvm.vendor", "spec.jvm2008.report.jvm.vendor.url", "spec.jvm2008.report.jvm.java.specification", "spec.jvm2008.report.jvm.address.bits", "spec.jvm2008.report.jvm.available.date", "spec.jvm2008.report.jvm.startup.launcher", "spec.jvm2008.report.jvm.app.class.path", "spec.jvm2008.report.jvm.boot.class.path", "spec.jvm2008.report.os.name", "spec.jvm2008.report.os.address.bits", "spec.jvm2008.report.os.available.date", "spec.jvm2008.report.sw.filesystem", "spec.jvm2008.report.sw.other.name", "spec.jvm2008.report.sw.other.available", "spec.jvm2008.report.hw.vendor", "spec.jvm2008.report.hw.vendor.url", "spec.jvm2008.report.hw.model", "spec.jvm2008.report.hw.available", "spec.jvm2008.report.hw.cpu.vendor", "spec.jvm2008.report.hw.cpu.vendor.url", "spec.jvm2008.report.hw.cpu.name", "spec.jvm2008.report.hw.cpu.speed", "spec.jvm2008.report.hw.logical.cpus", "spec.jvm2008.report.hw.number.of.chips", "spec.jvm2008.report.hw.number.of.cores", "spec.jvm2008.report.hw.number.of.cores.per.chip", "spec.jvm2008.report.hw.threading.enabled", "spec.jvm2008.report.hw.threads.per.core", "spec.jvm2008.report.hw.address.bits", "spec.jvm2008.report.hw.cpu.cache.l1", "spec.jvm2008.report.hw.cpu.cache.l2", "spec.jvm2008.report.hw.cpu.cache.other", "spec.jvm2008.report.hw.memory.size", "spec.jvm2008.report.hw.memory.details", "spec.jvm2008.report.hw.details.other", "spec.jvm2008.benchmark.version"};

    private static void unzipFile(String zipFileName, String rawFileName) throws StopBenchmarkException {
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            if (!entries.hasMoreElements()) {
                throw new StopBenchmarkException("Submitted file '" + zipFileName + "' is empty.");
            }
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                throw new StopBenchmarkException("Zip file contains directory structure. Not allowed.");
            }
            if (entries.hasMoreElements()) {
                throw new StopBenchmarkException("Submitted file '" + zipFileName + "' contains more than one file. Not allowed.");
            }
            System.err.println("Extracting file: " + entry.getName());
            InputStream in = zipFile.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(rawFileName));
            byte[] buf = new byte[1024];
            int n = in.read(buf);
            while (n > 0) {
                ((OutputStream)out).write(buf, 0, n);
                n = in.read(buf);
            }
            in.close();
            ((OutputStream)out).close();
            zipFile.close();
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            throw new StopBenchmarkException("Failed extracting zipfile '" + zipFileName + "'");
        }
    }

    private static String getResultFile(String workLoadLine, String resultDir) {
        String resultFile = null;
        if (workLoadLine != null && workLoadLine.indexOf("Base") != -1) {
            resultDirBase = reportRootDir + "/" + reportRootName + ".base";
            new File(resultDirBase).mkdir();
            baseRawFileName = resultFile = resultDirBase + "/" + "SPECjvm2008.base.raw";
        } else if (workLoadLine != null && workLoadLine.indexOf("Peak") != -1) {
            resultDirPeak = reportRootDir + "/" + reportRootName + ".peak";
            new File(resultDirPeak).mkdir();
            peakRawFileName = resultFile = resultDirPeak + "/" + "SPECjvm2008.peak.raw";
        } else {
            throw new UnsupportedOperationException("Unknown workload: " + workLoadLine);
        }
        return resultFile;
    }

    private static void splitMergedRawFile(String inFileName) throws IOException {
        String line;
        File inFile = new File(inFileName);
        inFileNameAbsolute = inFile.getAbsolutePath();
        reportRootDir = new File(inFileNameAbsolute).getParent();
        int ePos = Math.max(inFileNameAbsolute.indexOf(".raw"), inFileNameAbsolute.indexOf(".xml"));
        reportRootName = inFileNameAbsolute.substring(reportRootDir.length(), ePos);
        if (reportRootName.charAt(0) == '/' || reportRootName.charAt(0) == '\\') {
            reportRootName = reportRootName.substring(1);
        }
        BufferedReader rawFileStream = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
        String headerLine = line = rawFileStream.readLine();
        String[] workLoadLines = new String[2];
        int i = 0;
        String stag1 = "<spec.jvm2008.result.noncompliant>";
        String etag1 = "</spec.jvm2008.result.noncompliant>";
        String stag2 = "<spec.jvm2008.result.noncompliant.reason>";
        String etag2 = "</spec.jvm2008.result.noncompliant.reason>";
        String stag3 = "<spec.jvm2008.result.noncompliant.remedy>";
        String etag3 = "</spec.jvm2008.result.noncompliant.remedy>";
        String stag4 = "<spec.jvm2008.result.date>";
        String etag4 = "</spec.jvm2008.result.date>";
        while (line != null) {
            if (line.indexOf("<workload>") != -1) {
                if (i > 1) {
                    System.out.println("Error: Finds more than 2 workloads in raw file.");
                    System.exit(-1);
                }
                workLoadLines[i++] = line;
            }
            if (line.indexOf(stag1) != -1 && (specNonCompliance = line.substring(line.indexOf(stag1) + stag1.length(), line.indexOf(etag1))) == "no") {
                specNonCompliance = null;
            }
            if (line.indexOf(stag2) != -1) {
                specNonComplianceReason = line.substring(line.indexOf(stag2) + stag2.length(), line.indexOf(etag2));
            }
            if (line.indexOf(stag3) != -1) {
                specNonComplianceRemedy = line.substring(line.indexOf(stag3) + stag3.length(), line.indexOf(etag3));
            }
            if (line.indexOf(stag4) != -1) {
                specReportPreparedDate = line.substring(line.indexOf(stag4) + stag4.length(), line.indexOf(etag4));
            }
            line = rawFileStream.readLine();
        }
        rawFileStream.close();
        String resultDir = inFile.getParent();
        String resultFileName = SPECSubmissionProcessor.getResultFile(workLoadLines[0], resultDir);
        System.out.println("Creating file " + resultFileName);
        File resultFile = new File(resultFileName);
        PrintStream resultFileStream = new PrintStream(new FileOutputStream(resultFile));
        inFile = new File(inFileName);
        rawFileStream = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
        line = rawFileStream.readLine();
        while (line != null && line.indexOf("<specjvm-result>") == -1) {
            line = rawFileStream.readLine();
        }
        resultFileStream.println(headerLine);
        while (line != null && line.indexOf("</specjvm-result>") == -1) {
            resultFileStream.println(line);
            line = rawFileStream.readLine();
        }
        resultFileStream.println(line);
        resultFileStream.close();
        if (workLoadLines[1] != null) {
            resultFileName = SPECSubmissionProcessor.getResultFile(workLoadLines[1], resultDir);
            resultFile = new File(resultFileName);
            System.out.println("Creating file " + resultFileName);
            resultFile.createNewFile();
            resultFileStream = new PrintStream(new FileOutputStream(resultFile));
            while (line != null && line.indexOf("<specjvm-result>") == -1) {
                line = rawFileStream.readLine();
            }
            resultFileStream.println(headerLine);
            while (line != null && line.indexOf("</specjvm-result>") == -1) {
                resultFileStream.println(line);
                line = rawFileStream.readLine();
            }
            resultFileStream.println(line);
            resultFileStream.close();
        }
        rawFileStream.close();
    }

    private static void createMergedSubFile() throws IOException {
        String peakValue;
        String baseValue;
        String key;
        int i;
        String peakSubFileName;
        File peakSubFile;
        String baseSubFileName = reportRootDir + "/" + reportRootName + ".base/SPECjvm2008.base.sub";
        File baseSubFile = new File(baseSubFileName);
        if (!baseSubFile.exists()) {
            baseSubFile = null;
        }
        if (!(peakSubFile = new File(peakSubFileName = reportRootDir + "/" + reportRootName + ".peak/SPECjvm2008.peak.sub")).exists()) {
            peakSubFile = null;
        }
        mergedSubFileName = reportRootDir + "/" + reportRootName + ".sub";
        PrintStream resultFileStream = new PrintStream(new FileOutputStream(mergedSubFileName));
        Properties peak = new Properties();
        Properties base = new Properties();
        if (baseSubFile != null) {
            base.load(new FileInputStream(baseSubFileName));
        } else {
            errors.add("Missing base submission property file.");
        }
        if (peakSubFile != null) {
            peak.load(new FileInputStream(peakSubFileName));
        }
        resultFileStream.println("spec.jvm2008.result.noncompliant=" + (specNonCompliance == null ? "no" : specNonCompliance));
        resultFileStream.println("spec.jvm2008.result.noncompliant.reason=" + (specNonComplianceReason == null ? "" : specNonComplianceReason));
        resultFileStream.println("spec.jvm2008.result.noncompliant.remedy=" + (specNonComplianceRemedy == null ? "" : specNonComplianceRemedy));
        resultFileStream.println("spec.jvm2008.result.prepared.date=" + (specReportPreparedDate == null ? "" : specReportPreparedDate));
        for (i = 0; i < modeBasedProps.length; ++i) {
            key = modeBasedProps[i];
            baseValue = base.getProperty(key);
            peakValue = peak.getProperty(key);
            resultFileStream.println(key + ".base=" + (baseValue != null ? baseValue : ""));
            resultFileStream.println(key + ".peak=" + (peakValue != null ? peakValue : ""));
        }
        for (i = 0; i < commonProps.length; ++i) {
            key = commonProps[i];
            baseValue = base.getProperty(key);
            peakValue = peak.getProperty(key);
            String value = baseValue;
            if (baseValue == null) {
                errors.add("Base missing value for " + key);
                value = peakValue;
            }
            if (baseValue != null && peakValue != null && !baseValue.equals(peakValue)) {
                errors.add("Base and peak has different values for " + key + "  base=" + baseValue + "  peak=" + peakValue);
            }
            resultFileStream.println(key + "=" + (value != null ? value : ""));
        }
        Iterator iter = errors.iterator();
        int i2 = 1;
        while (iter.hasNext()) {
            resultFileStream.println("spec.jvm2008.result.error." + i2 + "=" + (String)iter.next());
        }
        resultFileStream.close();
    }

    private static void createResultFile(Properties p) throws Exception {
        String testerName = p.getProperty("spec.jvm2008.report.run.submitter", "n/a");
        String testerUrl = p.getProperty("spec.jvm2008.report.run.submitter.url", "n/a");
        String jvmCompanyName = p.getProperty("spec.jvm2008.report.jvm.vendor", "n/a");
        String jvmCompanyUrl = p.getProperty("spec.jvm2008.report.jvm.vendor.url", "n/a");
        String jvmName = p.getProperty("spec.jvm2008.report.jvm.name", "n/a");
        String jvmVersion = p.getProperty("spec.jvm2008.report.jvm.version", "n/a");
        String hwCompanyName = p.getProperty("spec.jvm2008.report.hw.vendor", "n/a");
        String hwCompanyUrl = p.getProperty("spec.jvm2008.report.hw.vendor", "n/a");
        String hwSystemName = p.getProperty("spec.jvm2008.report.hw.model", "n/a");
        String noHWThreads = p.getProperty("spec.jvm2008.report.hw.logical.cpus", "n/a");
        String noCores = p.getProperty("spec.jvm2008.report.hw.number.of.cores", "n/a");
        String noChips = p.getProperty("spec.jvm2008.report.hw.number.of.chips", "n/a");
        String baseOps = p.getProperty("spec.jvm2008.report.result.score.base", "").trim();
        String peakOps = p.getProperty("spec.jvm2008.report.result.score.peak", "").trim();
        String baseMetric = p.getProperty("spec.jvm2008.report.result.metric.base", "");
        String peakMetric = p.getProperty("spec.jvm2008.report.result.metric.peak", "");
        String summaryLink = reportRootDir + "/" + reportRootName + ".html";
        String fdrLinkBaseHtml = baseOps == null || baseOps.length() == 0 ? null : "./" + reportRootName + ".base/SPECjvm2008.base.html";
        String fdrLinkBaseTxt = baseOps == null || baseOps.length() == 0 ? null : "./" + reportRootName + ".base/SPECjvm2008.base.txt";
        String fdrLinkPeakHtml = peakOps == null || peakOps.length() == 0 ? null : "./" + reportRootName + ".peak/SPECjvm2008.peak.html";
        String fdrLinkPeakTxt = peakOps == null || peakOps.length() == 0 ? null : "./" + reportRootName + ".peak/SPECjvm2008.peak.txt";
        String summaryHtmlName = summaryLink;
        System.out.println("Creating report " + summaryHtmlName);
        PrintStream summaryHtmlStream = new PrintStream(new FileOutputStream(summaryHtmlName));
        summaryHtmlStream.println("<HTML>");
        summaryHtmlStream.println("  <HEAD>");
        summaryHtmlStream.println("    <META NAME=\"GENERATOR\" CONTENT=\"SPEC Java Reporter\">");
        summaryHtmlStream.println("    <TITLE>SPECjvm2008</TITLE>");
        summaryHtmlStream.println("  </HEAD>");
        summaryHtmlStream.println("  <BODY >");
        summaryHtmlStream.println("    <TABLE WIDTH=100% >");
        summaryHtmlStream.println("      <TR> ");
        summaryHtmlStream.println("        <TD ALIGN=LEFT ROWSPAN=2> <FONT SIZE=+3 COLOR=BLUE>SPECjvm2008 SPEC Summary Report</FONT></TD>");
        summaryHtmlStream.println("      </TR>");
        summaryHtmlStream.println("    </TABLE>");
        summaryHtmlStream.println("    <TABLE WIDTH=100% >");
        summaryHtmlStream.println("        <THEAD>");
        summaryHtmlStream.println("           <COL width = 30%>");
        summaryHtmlStream.println("           <COL width = 70%>");
        summaryHtmlStream.println("        </THEAD>");
        summaryHtmlStream.println("        <TBODY>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Tester</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT><A HREF=\"" + testerUrl + "\">" + testerName + "</A></TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>JVM Vendor</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT><A HREF=\"" + jvmCompanyUrl + "\">" + jvmCompanyName + "</A></TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>JVM</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>" + jvmName + " " + jvmVersion + "</TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Hardware Company</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT><A HREF=\"" + hwCompanyUrl + "\">" + hwCompanyName + "</A></TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Hardware Model</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>" + hwSystemName + "</TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Number of chips</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>" + noChips + "</TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Number of cores</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>" + noCores + "</TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Number of logical CPUs</TD>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>" + noHWThreads + "</TD>");
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Base result</TD>");
        if (baseOps != null) {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>" + baseOps + " " + baseMetric + "</TD>");
        } else {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>&nbsp;</TD>");
        }
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Peak result</TD>");
        if (peakOps != null) {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>" + peakOps + " " + peakMetric + "</TD>");
        } else {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>&nbsp;</TD>");
        }
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Base report</TD>");
        if (fdrLinkBaseHtml != null) {
            summaryHtmlStream.println("            <TD ALIGN=LEFT><A HREF=\"" + fdrLinkBaseHtml + "\">html</A>, <A HREF=\"" + fdrLinkBaseTxt + "\">txt</A></TD>");
        } else {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>&nbsp;</TD>");
        }
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("          <TR>");
        summaryHtmlStream.println("            <TD ALIGN=LEFT>Peak report</TD>");
        if (fdrLinkPeakHtml != null) {
            summaryHtmlStream.println("            <TD ALIGN=LEFT><A HREF=\"" + fdrLinkPeakHtml + "\">html</A>, <A HREF=\"" + fdrLinkPeakTxt + "\">txt</A></TD>");
        } else {
            summaryHtmlStream.println("            <TD ALIGN=LEFT>&nbsp;</TD>");
        }
        summaryHtmlStream.println("          </TR>");
        summaryHtmlStream.println("       </TBODY>");
        summaryHtmlStream.println("    </TABLE>");
        Iterator i = errors.iterator();
        if (i.hasNext()) {
            summaryHtmlStream.println("    <BR><BR>");
            summaryHtmlStream.println("    <TABLE WIDTH=100% >");
            summaryHtmlStream.println("      <TR><TD>Warnings:</TD></TR>");
            while (i.hasNext()) {
                summaryHtmlStream.println("      <TR><TD>" + (String)i.next() + "</TD></TR>");
            }
            summaryHtmlStream.println("    </TABLE>");
        }
        summaryHtmlStream.println("  </BODY>");
        summaryHtmlStream.println("</HTML>");
        summaryHtmlStream.close();
    }

    public static void main(String[] args) throws Exception {
        String[] rArgs;
        String inRawFileName;
        String inZipFileName;
        File inFile;
        if (args.length != 1) {
            System.out.println("Usage: spec.reporter.BasePeakReporter <merged raw file> ");
        }
        if (!(inFile = new File(inZipFileName = args[0])).exists()) {
            System.out.println("Cannot find file '" + inZipFileName + "'");
            return;
        }
        int dotZipPos = inZipFileName.indexOf(".zip");
        int dotXmlPos = inZipFileName.indexOf(".xml");
        int dotRawPos = inZipFileName.indexOf(".raw");
        if (dotZipPos == -1 && dotXmlPos == -1 && dotRawPos == -1) {
            System.out.println("Expecting a file name *.zip, *.xml or *.raw, but got: '" + inZipFileName + "'");
            return;
        }
        if (dotZipPos != -1) {
            inRawFileName = inZipFileName.substring(0, dotZipPos);
            SPECSubmissionProcessor.unzipFile(inZipFileName, inRawFileName);
        } else {
            inRawFileName = inZipFileName;
        }
        SPECSubmissionProcessor.splitMergedRawFile(inRawFileName);
        ReportGenerator.specLogo = System.getProperty("spec.jvm2008.result.logo");
        ReportGenerator.specNonCompliance = System.getProperty("spec.jvm2008.result.noncompliant", specNonCompliance);
        ReportGenerator.specNonComplianceReason = System.getProperty("spec.jvm2008.result.noncompliant.reason", specNonComplianceReason);
        ReportGenerator.specNonComplianceRemedy = System.getProperty("spec.jvm2008.result.noncompliant.remedy", specNonComplianceRemedy);
        if (baseRawFileName != null) {
            rArgs = new String[]{baseRawFileName};
            ReportGenerator.main(rArgs);
        }
        if (peakRawFileName != null) {
            rArgs = new String[]{peakRawFileName};
            ReportGenerator.main(rArgs);
        }
        SPECSubmissionProcessor.createMergedSubFile();
        Properties p = new Properties();
        p.load(new FileInputStream(mergedSubFileName));
        SPECSubmissionProcessor.createResultFile(p);
    }
}

