/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import spec.harness.results.TestResult;
import spec.reporter.BenchmarkChart;
import spec.reporter.BenchmarkGroupRecords;
import spec.reporter.BenchmarkRecord;
import spec.reporter.Utils;
import spec.reporter.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGenerator {
    private ArrayList<Writer> writer = new ArrayList();
    private Element root;
    private BenchmarkGroupRecords records = new BenchmarkGroupRecords();
    private double compositeScore;
    private String metric;
    TreeMap<String, Double> subGroupScores;
    private ArrayList<String> violations;
    private ArrayList<String> configs;
    private String subFileName = null;
    private String summaryFileName = null;
    protected static String reporterDir = null;
    protected static String specNonCompliance = System.getProperty("spec.jvm2008.result.noncompliant");
    protected static String specNonComplianceReason = System.getProperty("spec.jvm2008.result.noncompliant.reason");
    protected static String specNonComplianceRemedy = System.getProperty("spec.jvm2008.result.noncompliant.remedy");
    protected static String specLogo = System.getProperty("spec.jvm2008.result.logo");
    String[] runInfoTableFields = new String[]{"spec.jvm2008.report.run.submitter", "spec.jvm2008.report.run.submitter.url", "spec.jvm2008.report.run.license", "spec.jvm2008.report.run.tester", "spec.jvm2008.report.run.location", "spec.jvm2008.report.run.date"};
    String[] jvmInfoTableFields = new String[]{"spec.jvm2008.report.jvm.vendor", "spec.jvm2008.report.jvm.vendor.url", "spec.jvm2008.report.jvm.name", "spec.jvm2008.report.jvm.version", "spec.jvm2008.report.jvm.available.date", "spec.jvm2008.report.jvm.java.specification", "spec.jvm2008.report.jvm.address.bits", "spec.jvm2008.report.jvm.command.line.initial.heap.size", "spec.jvm2008.report.jvm.command.line.max.heap.size", "spec.jvm2008.report.jvm.command.line", "spec.jvm2008.report.jvm.startup.command.line", "spec.jvm2008.report.jvm.startup.launcher", "spec.jvm2008.report.jvm.other.tuning", "spec.jvm2008.report.jvm.app.class.path", "spec.jvm2008.report.jvm.boot.class.path"};
    String[] swInfoTableFields = new String[]{"spec.jvm2008.report.os.name", "spec.jvm2008.report.os.available.date", "spec.jvm2008.report.os.address.bits", "spec.jvm2008.report.os.tuning", "spec.jvm2008.report.sw.filesystem", "spec.jvm2008.report.sw.other.name", "spec.jvm2008.report.sw.other.tuning", "spec.jvm2008.report.sw.other.available"};
    String[] hwInfoTableFields = new String[]{"spec.jvm2008.report.hw.vendor", "spec.jvm2008.report.hw.vendor.url", "spec.jvm2008.report.hw.model", "spec.jvm2008.report.hw.available", "spec.jvm2008.report.hw.cpu.vendor", "spec.jvm2008.report.hw.cpu.vendor.url", "spec.jvm2008.report.hw.cpu.name", "spec.jvm2008.report.hw.cpu.speed", "spec.jvm2008.report.hw.logical.cpus", "spec.jvm2008.report.hw.number.of.chips", "spec.jvm2008.report.hw.number.of.cores", "spec.jvm2008.report.hw.number.of.cores.per.chip", "spec.jvm2008.report.hw.threads.per.core", "spec.jvm2008.report.hw.threading.enabled", "spec.jvm2008.report.hw.address.bits", "spec.jvm2008.report.hw.cpu.cache.l1", "spec.jvm2008.report.hw.cpu.cache.l2", "spec.jvm2008.report.hw.cpu.cache.other", "spec.jvm2008.report.hw.memory.size", "spec.jvm2008.report.hw.memory.details", "spec.jvm2008.report.hw.details.other"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportGenerator(String ifn, boolean doHtml, boolean doTxt, boolean doSub, boolean doSummary) {
        String inputFileName = ifn;
        Utils.REPORTER_DIR = reporterDir = new File(inputFileName).getAbsoluteFile().getParent();
        Utils.IMAGES_DIR = reporterDir + "/images";
        File images = new File(Utils.IMAGES_DIR);
        if (!images.exists()) {
            new File(Utils.IMAGES_DIR).mkdir();
        }
        FileInputStream rawFileIS = null;
        this.root = null;
        int index = inputFileName.lastIndexOf(".");
        String prefix = inputFileName.substring(0, index);
        if (doSub || doSummary || doHtml || doTxt) {
            try {
                String resDir = new File(prefix + "tmp").getParentFile().getCanonicalPath();
                System.out.println("Generating reports in:\n" + resDir);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (doSub) {
            this.subFileName = prefix + ".sub";
        }
        if (doSummary) {
            this.summaryFileName = prefix + ".summary";
        }
        try {
            if (doHtml) {
                this.writer.add(Writer.getInstance("html", prefix + ".html"));
            }
            if (doTxt) {
                this.writer.add(Writer.getInstance("plain", prefix + ".txt"));
            }
            rawFileIS = new FileInputStream(inputFileName);
            this.root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(rawFileIS).getDocumentElement();
            this.handleBenchmarksResults(this.getChildByName("benchmark-results"));
        }
        catch (Exception e) {
            try {
                rawFileIS.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            System.out.println("ERROR: Reporter cannot be initialized (" + e + ")");
            System.exit(-1);
        }
        finally {
            try {
                rawFileIS.close();
            }
            catch (IOException e) {}
        }
    }

    private void handleBenchmarksResults(Node node) {
        Node current = node.getFirstChild();
        do {
            if (!this.isNotTextNode(current)) continue;
            this.handleBenchmarkResult(current);
        } while ((current = current.getNextSibling()) != null);
        this.compositeScore = this.records.computeCompositeScore();
        if (specNonCompliance != null && !specNonCompliance.equals("no")) {
            this.compositeScore = 0.0;
        }
    }

    private String getValue(NamedNodeMap nodeMap, String name) {
        Node node = nodeMap.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    private Node getChildByName(String name) {
        return this.root.getElementsByTagName(name).item(0);
    }

    private void collectBmConfiguration(BenchmarkRecord record, NamedNodeMap attrs) {
        for (int i = 0; i < Utils.BM_CONFIGURATION_ENAMES.length; ++i) {
            record.configuration[i] = this.getValue(attrs, Utils.BM_CONFIGURATION_ENAMES[i]);
        }
    }

    private void handleBenchmarkResult(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        String bmName = this.getValue(attrs, "name");
        String numberBmThreads = this.getValue(attrs, "numberBmThreads");
        BenchmarkRecord record = new BenchmarkRecord(bmName, Integer.parseInt(numberBmThreads));
        this.collectBmConfiguration(record, attrs);
        BenchmarkChart chart = new BenchmarkChart(bmName);
        Utils.dbgPrint(bmName + numberBmThreads);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!this.isNotTextNode(current)) continue;
            Utils.dbgPrint("\t?:" + current.getNodeName());
            record.startHandling(current.getNodeName());
            NodeList children2 = current.getChildNodes();
            for (int j = 0; j < children2.getLength(); ++j) {
                Node current2 = children2.item(j);
                if (!this.isNotTextNode(current2)) continue;
                this.handleIterationResult(record, chart, current2);
            }
        }
        this.records.addNewBenchmarkRecord(record);
        Utils.createBmResultGraph(record);
        chart.buildJPEG();
    }

    private void generateHat(Writer w, String runStatus, String score, String workloadName) {
        w.putHat(runStatus, score, workloadName, "", this.getProperty("spec.jvm2008.report.hw.vendor"), this.getProperty("spec.jvm2008.report.jvm.vendor"), this.getProperty("spec.jvm2008.report.hw.model"), this.getProperty("spec.jvm2008.report.jvm.name"), this.getProperty("spec.jvm2008.report.run.submitter"), this.getProperty("spec.jvm2008.report.run.date"), this.getProperty("spec.jvm2008.report.jvm.version"));
    }

    private void generateSummaryTable(Writer w, String scoreString) {
        w.putSummaryTable(scoreString, this.records.scores);
    }

    private void generateConfigTable(Writer w) {
        w.startTable("", false);
        w.startRecordAndData();
        this.generateInfoTable(this.getChildByName("run-info"), w, this.runInfoTableFields);
        w.endAndStartData();
        this.generateInfoTable(this.getChildByName("sw-info"), w, this.swInfoTableFields);
        w.endAndStartRecordAndData();
        this.generateInfoTable(this.getChildByName("jvm-info"), w, this.jvmInfoTableFields);
        w.endAndStartData();
        this.generateInfoTable(this.getChildByName("hw-info"), w, this.hwInfoTableFields);
        w.endAndStartRecordAndData();
        this.generateViolationsTable(w);
        this.insertSuiteConfiguration(w);
        w.endRecordAndData();
        w.endTable(true);
    }

    private ArrayList<String> findProperties(String ename, String subelementName) {
        NodeList currentNode = this.root.getElementsByTagName(ename);
        if (currentNode == null) {
            return null;
        }
        Node violation = currentNode.item(0);
        if (violation == null) {
            return null;
        }
        NodeList children = violation.getChildNodes();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!subelementName.equals(current.getNodeName())) continue;
            result.add(current.getTextContent());
        }
        return result;
    }

    private void generateViolationsTable(Writer w) {
        w.startTable("violations", true);
        if (this.violations != null && this.violations.size() != 0) {
            w.insertRecords(this.violations);
        }
        w.endTable(true);
    }

    private void generateDetailsTable(Writer w) {
        w.startDetailsTable();
        BenchmarkGroupRecords.BenchmarkResultsIterator iter = this.records.new BenchmarkGroupRecords.BenchmarkResultsIterator();
        while (iter.next() != null) {
            w.handleBenchmarkRecord(iter.getCurrentRecord());
        }
        w.endTable(true);
    }

    public void generateCopyRightStatement(Writer w) {
        GregorianCalendar g = new GregorianCalendar();
        int year = g.get(1);
        ArrayList<String> al = new ArrayList<String>();
        al.add("SPECjvm2008 Version: [" + this.getProperty("suite-build-version") + "]");
        if (year > 2008) {
            al.add("Copyright " + w.getCopyRightSign() + " 2008-" + year + " SPEC. All rights reserved");
        } else {
            al.add("Copyright " + w.getCopyRightSign() + " 2008 SPEC. All rights reserved");
        }
        w.startTable("", false, false, true);
        w.insertRecords(al);
        w.endTable();
    }

    public String generateReport() {
        String scoreString;
        String workloadName;
        this.violations = this.findProperties("violations", "violation");
        this.configs = this.findProperties("configs", "config");
        String workloadMode = workloadName = this.getProperty("workload");
        String score = Utils.formatScore(this.compositeScore);
        String runStatus = Utils.getRunStatus(this.isValidRun(), this.isCompliantRun());
        boolean isComp = this.isCompliantRun();
        boolean isValid = this.isValidRun();
        if (specNonCompliance != null && !specNonCompliance.equals("no")) {
            isComp = false;
            if (specNonCompliance.equalsIgnoreCase("na")) {
                runStatus = "Not Available";
            } else if (specNonCompliance.equalsIgnoreCase("nc")) {
                runStatus = "Not Compliant";
            } else if (specNonCompliance.equalsIgnoreCase("cd")) {
                runStatus = "Code Defect";
                isValid = false;
            } else {
                runStatus = specNonCompliance;
            }
            score = "";
            this.metric = "";
            scoreString = runStatus;
        } else if (isValid) {
            if ("SPECjvm2008 Lagom Workload".equals(workloadMode)) {
                if (isComp) {
                    this.metric = "ops/m";
                    scoreString = "Composite result: ";
                } else {
                    this.metric = "ops/m";
                    scoreString = "Noncompliant composite result: ";
                }
            } else if (isComp) {
                this.metric = workloadName + " " + "ops/m";
                scoreString = "Composite result: ";
            } else {
                this.metric = "ops/m";
                scoreString = "Noncompliant composite result: ";
            }
        } else {
            this.metric = "";
            scoreString = "Composite result: ";
        }
        scoreString = scoreString + score + " " + this.metric;
        this.createSummary(scoreString, workloadName, workloadMode);
        this.createSubFile(runStatus, score, this.metric, workloadName, workloadMode);
        for (int i = 0; i < this.writer.size(); ++i) {
            this.writer.get(i).startReport();
            this.generateHat(this.writer.get(i), runStatus, scoreString, workloadName);
            if (specNonCompliance != null && !specNonCompliance.equals("no")) {
                this.writer.get(i).startTable("", false);
                this.writer.get(i).startRecordAndData();
                this.writer.get(i).startTable("SPEC non-compliance", true);
                ArrayList<String> ncs = new ArrayList<String>(2);
                if (specNonComplianceReason != null) {
                    ncs.add("Reason: " + specNonComplianceReason);
                }
                if (specNonComplianceRemedy != null) {
                    ncs.add("Remedy: " + specNonComplianceRemedy);
                }
                this.writer.get(i).insertRecords(ncs);
                this.writer.get(i).endTable();
                this.writer.get(i).endRecordAndData();
                this.writer.get(i).endTable();
            } else {
                Utils.generateMainChart(this.compositeScore, this.records.scores);
                this.generateSummaryTable(this.writer.get(i), scoreString);
            }
            this.generateConfigTable(this.writer.get(i));
            this.generateDetailsTable(this.writer.get(i));
            this.generateCopyRightStatement(this.writer.get(i));
            this.writer.get(i).endReport();
            this.writer.get(i).closeStream();
        }
        return scoreString;
    }

    private void generateInfoTable(Node base, Writer w, String[] fields) {
        LinkedList<Pair<String, String>> l1 = new LinkedList<Pair<String, String>>();
        for (Node current = base.getFirstChild(); current != null; current = current.getNextSibling()) {
            Pair<String, String> p = new Pair<String, String>(current.getNodeName(), current.getTextContent());
            if (!this.isNotTextNode(current)) continue;
            l1.add(p);
        }
        LinkedList<Pair<String, String>> l2 = new LinkedList<Pair<String, String>>();
        block1: for (int i = 0; i < fields.length; ++i) {
            Iterator iterator = l1.iterator();
            while (iterator.hasNext()) {
                Pair p = (Pair)iterator.next();
                if (p.fst == null || !((String)p.fst).equals(fields[i])) continue;
                l2.add(p);
                iterator.remove();
                continue block1;
            }
        }
        l2.addAll(l1);
        w.startTable(base.getNodeName(), true);
        for (Pair pair : l2) {
            w.insertRecord(Utils.getDescription((String)pair.fst), this.insertBRTag(TestResult.correctContent((String)pair.snd, false), w));
        }
        w.endTable(true);
    }

    private String insertBRTag(String text, Writer w) {
        if (text.length() < 50) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            sb.append(ch);
            if (++count <= 40 || ch != ';' && ch != ':') continue;
            if (w.getType().equals("html")) {
                sb.append("<BR>");
            }
            count = 0;
        }
        return sb.toString();
    }

    private void handleIterationResult(BenchmarkRecord record, BenchmarkChart chart, Node node) {
        Utils.dbgPrint("\t\t:" + node.getNodeName());
        NamedNodeMap attrs = node.getAttributes();
        String startTime = this.getValue(attrs, "startTime");
        String endTime = this.getValue(attrs, "endTime");
        if (startTime == null) {
            startTime = "0";
        }
        if (endTime == null) {
            endTime = "0";
        }
        chart.setStartTime(Long.parseLong(startTime));
        String operations = this.getValue(attrs, "operations");
        if (operations == null) {
            operations = "0";
        }
        BenchmarkRecord.IterationRecord iterRecord = record.addIterationRecord(this.getValue(attrs, "iteration"), this.getValue(attrs, "expectedDuration"), startTime, endTime, operations);
        if (this.checkName("iterations", node.getParentNode())) {
            chart.addMarker(Long.parseLong(startTime), Utils.df.format(iterRecord.operations) + " ops");
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currrent = children.item(i);
            if (this.checkName("loops", currrent)) {
                this.handleLoopsNode(iterRecord, chart, currrent);
                continue;
            }
            if (!this.checkName("analyzers", currrent)) continue;
            this.handleAnalyzersNode(chart, currrent);
        }
    }

    private boolean checkName(String name, Node node) {
        return name.equals(node.getNodeName());
    }

    private boolean isNotTextNode(Node node) {
        return node.getNodeType() != 3;
    }

    private void handleLoopsNode(BenchmarkRecord.IterationRecord record, BenchmarkChart chart, Node node) {
        Utils.dbgPrint("\t\t\t:" + node.getNodeName());
        NodeList children = node.getChildNodes();
        Utils.dbgPrint("HandleLoopsNode");
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!this.checkName("loop-result", current)) continue;
            NamedNodeMap attrs = current.getAttributes();
            chart.addTimeInfo("bmThread" + this.getValue(attrs, "bmThreadId"), Long.parseLong(this.getValue(attrs, "startTime")), Long.parseLong(this.getValue(attrs, "endTime")));
            this.checkErrors(record, current);
        }
    }

    private void checkErrors(BenchmarkRecord.IterationRecord iterRecord, Node loopsNode) {
        NodeList children = loopsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!"errors".equals(current.getNodeName())) continue;
            NodeList errors = current.getChildNodes();
            for (int j = 0; j < errors.getLength(); ++j) {
                if (!"error".equals(errors.item(j).getNodeName())) continue;
                iterRecord.addError(errors.item(j).getTextContent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSummary(String scoreString, String workloadName, String workloadMode) {
        if (this.summaryFileName == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.summaryFileName);
            PrintStream ps = new PrintStream(fos);
            ps.println("Report:      " + workloadName + (workloadName.equals(workloadMode) ? "" : ", " + workloadMode) + " summary");
            ps.println("Result:      " + scoreString);
            ps.println("HW Model:    " + this.getProperty("spec.jvm2008.report.hw.vendor") + ", " + this.getProperty("spec.jvm2008.report.hw.model"));
            ps.println("HW CPU:      " + this.getProperty("spec.jvm2008.report.hw.cpu.vendor") + ", " + this.getProperty("spec.jvm2008.report.hw.cpu.name"));
            ps.println("OS:          " + this.getProperty("spec.jvm2008.report.os.name"));
            ps.println("JVM:         " + this.getProperty("spec.jvm2008.report.jvm.vendor") + ", " + this.getProperty("spec.jvm2008.report.jvm.name") + ", " + this.getProperty("spec.jvm2008.report.jvm.version"));
            ps.println("JVM tuning:  " + this.getProperty("spec.jvm2008.report.jvm.command.line"));
            ps.println("JVM startup: " + this.getProperty("spec.jvm2008.report.jvm.startup.command.line"));
            ps.println("Tester:      " + this.getProperty("spec.jvm2008.report.run.tester") + ", " + this.getProperty("spec.jvm2008.report.run.submitter"));
            ps.println("Run date:    " + this.getProperty("spec.jvm2008.report.run.date"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    private void printConstantProp(PrintStream ps, String prop) {
        ps.println(prop + "=" + this.getProperty(prop));
    }

    private void printConstantProp(PrintStream ps, String prop, String value) {
        ps.println(prop + "=" + value);
    }

    private void createSubFile(String runStatus, String compositeScore, String metric, String workloadName, String workloadMode) {
        if (this.subFileName == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.subFileName);
            PrintStream ps = new PrintStream(fos);
            ps.println("spec.jvm2008.report.result.status=" + runStatus);
            ps.println("spec.jvm2008.report.result.score=" + compositeScore);
            ps.println("spec.jvm2008.report.result.metric=" + metric);
            ps.println("spec.jvm2008.report.result.workload.name=" + workloadName);
            ps.println("spec.jvm2008.report.result.workload.mode=" + workloadMode);
            this.printConstantProp(ps, "spec.jvm2008.report.run.date");
            this.printConstantProp(ps, "spec.jvm2008.report.run.tester");
            this.printConstantProp(ps, "spec.jvm2008.report.run.submitter");
            this.printConstantProp(ps, "spec.jvm2008.report.run.submitter.url");
            this.printConstantProp(ps, "spec.jvm2008.report.run.location");
            this.printConstantProp(ps, "spec.jvm2008.report.run.license");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.name");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.version");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.vendor");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.vendor.url");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.java.specification");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.address.bits");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.available.date");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.command.line");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.command.line.initial.heap.size");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.command.line.max.heap.size");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.startup.launcher");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.startup.command.line");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.other.tuning");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.app.class.path");
            this.printConstantProp(ps, "spec.jvm2008.report.jvm.boot.class.path");
            this.printConstantProp(ps, "spec.jvm2008.report.os.name");
            this.printConstantProp(ps, "spec.jvm2008.report.os.address.bits");
            this.printConstantProp(ps, "spec.jvm2008.report.os.available.date");
            this.printConstantProp(ps, "spec.jvm2008.report.os.tuning");
            this.printConstantProp(ps, "spec.jvm2008.report.sw.filesystem");
            this.printConstantProp(ps, "spec.jvm2008.report.sw.other.name");
            this.printConstantProp(ps, "spec.jvm2008.report.sw.other.tuning");
            this.printConstantProp(ps, "spec.jvm2008.report.sw.other.available");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.vendor");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.vendor.url");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.model");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.available");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.vendor");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.vendor.url");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.name");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.speed");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.logical.cpus");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.number.of.chips");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.number.of.cores");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.number.of.cores.per.chip");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.threading.enabled");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.threads.per.core");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.address.bits");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.cache.l1");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.cache.l2");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.cpu.cache.other");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.memory.size");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.memory.details");
            this.printConstantProp(ps, "spec.jvm2008.report.hw.details.other");
            this.printConstantProp(ps, "spec.jvm2008.benchmark.version", this.getProperty("suite-build-version"));
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleAnalyzersNode(BenchmarkChart chart, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (!this.checkName("tyinfo", current)) continue;
            NamedNodeMap attrs = current.getAttributes();
            String name = this.getValue(attrs, "name");
            long time = Long.parseLong(this.getValue(attrs, "time"));
            long value = Long.parseLong(this.getValue(attrs, "value"));
            String units = this.getValue(attrs, "unit");
            if ("Total Memory in Heap".equals(name)) {
                chart.addTotalHeapInfo(time, value);
                continue;
            }
            if ("Free Memory in Heap".equals(name)) {
                chart.addFreeHeapInfo(time, value);
                continue;
            }
            chart.addAnalyzerReport(name, units, time, value);
        }
    }

    private String getProperty(String prop) {
        return this.root.getElementsByTagName(prop).item(0).getTextContent();
    }

    private boolean isValidRun() {
        return this.records.allBenchmarksValid;
    }

    private boolean isCompliantRun() {
        return this.violations == null || this.violations.size() == 0;
    }

    private void insertSuiteConfiguration(Writer w) {
        w.startTable("suite configuration", true);
        w.insertRecords(this.configs);
        w.endTable(true);
    }

    public static String main2(String[] args) throws Exception {
        String rawFile = null;
        boolean doSub = true;
        boolean doHtml = true;
        boolean doSummary = true;
        boolean doTxt = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-html")) {
                try {
                    doHtml = Boolean.parseBoolean(args[++i]);
                }
                catch (Exception e) {
                    System.out.println("Error: Argument " + args[i - 1] + " expects a boolean value.");
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-txt")) {
                try {
                    doTxt = Boolean.parseBoolean(args[++i]);
                }
                catch (Exception e) {
                    System.out.println("Error: Argument " + args[i - 1] + " expects a boolean value.");
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-summary")) {
                try {
                    doSummary = Boolean.parseBoolean(args[++i]);
                }
                catch (Exception e) {
                    System.out.println("Error: Argument " + args[i - 1] + " expects a boolean value.");
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-sub")) {
                try {
                    doSub = Boolean.parseBoolean(args[++i]);
                }
                catch (Exception e) {
                    System.out.println("Error: Argument " + args[i - 1] + " expects a boolean value.");
                }
                continue;
            }
            if (new File(args[i]).exists()) {
                rawFile = args[i];
                continue;
            }
            System.out.println("Error: Cannot parse argument " + args[i] + ". Not a file.");
        }
        if (rawFile == null) {
            System.out.println("java spec.reporter.Reporter <raw file>");
            System.out.println("java spec.reporter.Reporter <raw file> [-html <bool>] [-txt <bool>] [-summary <bool>] [-sub <bool>]");
            return null;
        }
        if (!new File(rawFile).exists()) {
            System.out.println("Cannot find file '" + rawFile + "'");
            return null;
        }
        ReportGenerator reporter = new ReportGenerator(rawFile, doHtml, doTxt, doSub, doSummary);
        return reporter.generateReport();
    }

    public static void main(String[] args) throws Exception {
        ReportGenerator.main2(args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<A, B> {
        public A fst;
        public B snd;

        public Pair(A first, B second) {
            this.fst = first;
            this.snd = second;
        }
    }
}

